<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('delivery_types', function (Blueprint $table) {
            $table->string('delivery_method')->nullable();
            $table->dropColumn('is_cost');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('delivery_types', function (Blueprint $table) {
            $table->dropColumn('delivery_method');
            $table->boolean('is_cost')->default(false);
        });
    }
};
