<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('area_management', function (Blueprint $table) {
            $table->id();
            $table->integer('area_id')->nullable(); // area_id می‌تواند 0 یا null باشد و foreign key نیست
            $table->string('day'); // روز
            $table->time('service_time_from'); // زمان شروع
            $table->time('service_time_to'); // زمان پایان
            $table->integer('min_order'); // حداقل سفارش
            $table->integer('delivery_time'); // زمان تحویل
            $table->integer('order_limit_per_half_hour')->nullable(); // محدودیت سفارش
            $table->boolean('free_delivery')->default(false); // ارسال رایگان
            $table->integer('free_delivery_min_amount')->nullable(); // حداقل مبلغ برای ارسال رایگان
            $table->integer('out_of_range_price')->default(0); // هزینه خارج از محدوده
            $table->boolean('status')->default(true); // وضعیت
            $table->integer('service_fee')->default(0); // هزینه سرویس رستوران
            $table->json('order_amounts')->nullable(); // مبالغ سفارش (orderAmount1, orderAmount2, orderAmountDelivery)
            $table->json('shipping_methods')->nullable(); // روش‌های ارسال (shipping_method1, shipping_method2, etc.)
            $table->timestamps(); // زمان‌های ایجاد و بروزرسانی
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('area_management');
    }
};
