<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('printer_devices', function (Blueprint $t) {
            $t->id();

            // Core
            $t->string('name');
            $t->string('slug')->nullable()->unique();
            $t->enum('type', ['escpos','cups','qz','printnode','raw_socket'])->index();
            $t->string('purpose')->nullable()->index(); // kitchen, bar, cashier, ...
            $t->foreignId('branch_id')->nullable()->index(); // اگر stores دارید، می‌توانید constrained هم بکنید
            $t->boolean('is_active')->default(true)->index();
            $t->boolean('is_default')->default(false)->index();
            $t->tinyInteger('priority')->default(0);

            // Connection
            $t->string('host')->nullable();
            $t->unsignedInteger('port')->nullable(); // 9100...
            $t->string('queue')->nullable();         // CUPS queue name
            $t->string('qz_name')->nullable();       // QZ Tray printer name
            $t->unsignedBigInteger('printnode_printer_id')->nullable();

            // Formatting / Print settings
            $t->string('template_key')->nullable();
            $t->unsignedSmallInteger('paper_width_mm')->nullable(); // 58 / 80
            $t->unsignedSmallInteger('dpi')->nullable();
            $t->string('escpos_profile')->nullable(); // Epson / Star / Generic
            $t->json('capabilities')->nullable();     // {"supports_cut":true,...}

            $t->json('include_sections')->nullable(); //'header','items','totals','footer'
            
            // Rules
            $t->json('item_filters')->nullable();
            $t->json('order_filters')->nullable();
            $t->json('enabled_time_windows')->nullable();

            // Reliability/Security
            $t->unsignedTinyInteger('max_retries')->default(3);
            $t->unsignedSmallInteger('backoff_seconds')->default(30);
            $t->json('allowlist_ips')->nullable();

            // Observability
            $t->string('location')->nullable();
            $t->timestamp('last_seen_at')->nullable();
            $t->timestamp('last_job_at')->nullable();
            $t->timestamp('last_error_at')->nullable();
            $t->text('last_error')->nullable();

            $t->timestamps();
            $t->softDeletes();

            // Unique combo for networked devices
            $t->unique(['type','host','port']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('printer_devices');
    }
};
