<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('print_jobs', function (Blueprint $t) {
            $t->id();

            $t->foreignId('order_id')->constrained()->cascadeOnDelete();
            $t->foreignId('printer_device_id')->constrained('printer_devices')->cascadeOnDelete();

            $t->enum('status', ['queued','sent','printed','failed'])->default('queued')->index();
            $t->unsignedTinyInteger('attempts')->default(0);
            $t->text('last_error')->nullable();
            $t->string('payload_path')->nullable(); // مسیر فایل موقت PDF/TXT

            $t->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('print_jobs');
    }
};
