<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('area_special_conditions', function (Blueprint $table) {
            $table->id();
            $table->json('branch_id');
            $table->json('area_id');
            $table->string('title')->nullable();
            $table->string('description')->nullable();
            $table->time('start_time');
            $table->time('end_time');
            $table->string('date');
            $table->integer('percent');
            $table->string('status')->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('area_special_conditions');
    }
};
