<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // ابتدا داده‌های نامعتبر datetime را اصلاح می‌کنیم
        DB::statement("SET sql_mode = ''");
        DB::statement("UPDATE categories SET created_at = '2024-01-01 00:00:00' WHERE created_at = '0000-00-00 00:00:00' OR created_at IS NULL");
        DB::statement("UPDATE categories SET updated_at = '2024-01-01 00:00:00' WHERE updated_at = '0000-00-00 00:00:00' OR updated_at IS NULL");

        Schema::table('categories', function (Blueprint $table) {
            $table->enum('status', ['active', 'inactive'])->default('active')->after('end_serving');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('categories', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
};
