<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_mobiles', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id');
            $table->enum('type', [
                'order_new',
                'order_cancelled',
                'order_ready',
                'ticket_new',
                'ticket_answered',
                'driver_assigned',
                'payment_received',
                'system_alert'
            ]);
            $table->string('mobile', 20);
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // Foreign key constraint
            $table->foreign('branch_id')->references('id')->on('branches')->onDelete('cascade');

            // Unique constraint to prevent duplicate entries
            $table->unique(['branch_id', 'type', 'mobile'], 'unique_branch_type_mobile');

            // Indexes for better performance
            $table->index(['branch_id', 'type'], 'idx_branch_type');
            $table->index('is_active', 'idx_active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_mobiles');
    }
};
