<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('branch_holidays', function (Blueprint $table) {
            $table->enum('holiday_reason_type', [
                'power_outage',
                'internal_repairs',
                'equipment_failure',
                'location_move',
                'no_delivery_person',
                'food_supplies_finished',
                'holidays',
                'no_service',
                'weather_condition',
                'menu_update',
                'no_staff',
                'other'
            ])->nullable()->after('reason')->comment('نوع علت تعطیلی');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('branch_holidays', function (Blueprint $table) {
            $table->dropColumn('holiday_reason_type');
        });
    }
};
