<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('popup_alarms', function (Blueprint $table) {
            $table->enum('page_type', ['home', 'cart_check', 'cart_payment'])->default('home')->after('status');
            $table->index('page_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('popup_alarms', function (Blueprint $table) {
            $table->dropIndex(['page_type']);
            $table->dropColumn('page_type');
        });
    }
};
