<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notification_mobiles', function (Blueprint $table) {
            // اضافه کردن نوع جدید order_delay_delivery به enum
            $table->enum('type', [
                'order_new',
                'order_cancelled',
                'order_ready',
                'ticket_new',
                'ticket_answered',
                'driver_assigned',
                'payment_received',
                'system_alert',
                'order_delay_approval',
                'order_delay_delivery'
            ])->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notification_mobiles', function (Blueprint $table) {
            // برگرداندن enum به حالت قبلی
            $table->enum('type', [
                'order_new',
                'order_cancelled',
                'order_ready',
                'ticket_new',
                'ticket_answered',
                'driver_assigned',
                'payment_received',
                'system_alert',
                'order_delay_approval'
            ])->change();
        });
    }
};
