<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // اضافه کردن مقدار جدید به enum
        DB::statement("ALTER TABLE notification_mobiles MODIFY COLUMN type ENUM(
            'order_new',
            'order_cancelled',
            'order_ready',
            'ticket_new',
            'ticket_answered',
            'driver_assigned',
            'payment_received',
            'system_alert',
            'order_delay_approval',
            'order_delay_delivery',
            'product_inactive'
        ) NOT NULL");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // حذف مقدار جدید از enum
        DB::statement("ALTER TABLE notification_mobiles MODIFY COLUMN type ENUM(
            'order_new',
            'order_cancelled',
            'order_ready',
            'ticket_new',
            'ticket_answered',
            'driver_assigned',
            'payment_received',
            'system_alert',
            'order_delay_approval',
            'order_delay_delivery'
        ) NOT NULL");
    }
};
