<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\BranchHoliday;
use App\Models\Branch;
use Carbon\Carbon;

class BranchHolidaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // دریافت اولین شعبه برای تست
        $branch = Branch::first();

        if (!$branch) {
            $this->command->info('هیچ شعبه‌ای یافت نشد. ابتدا شعب را ایجاد کنید.');
            return;
        }

        // تعطیلی تک روزه (مثال: تعطیلی رسمی)
        BranchHoliday::create([
            'branch_id' => $branch->id,
            'holiday_type' => 'single_date',
            'start_date' => '2025-02-11', // مثال: تعطیلی رسمی
            'is_full_day' => true,
            'reason' => 'تعطیلی رسمی',
            'status' => 'active'
        ]);

        // تعطیلی بازه‌ای (مثال: تعطیلی تعمیرات)
        BranchHoliday::create([
            'branch_id' => $branch->id,
            'holiday_type' => 'date_range',
            'start_date' => '2025-02-15',
            'end_date' => '2025-02-17',
            'start_time' => '09:00:00',
            'end_time' => '18:00:00',
            'is_full_day' => false,
            'reason' => 'تعمیرات سالانه',
            'status' => 'active'
        ]);

        // تعطیلی هفتگی (مثال: تعطیلی دوشنبه‌ها)
        BranchHoliday::create([
            'branch_id' => $branch->id,
            'holiday_type' => 'weekly_pattern',
            'start_date' => '2025-01-01',
            'week_days' => ['monday'],
            'start_time' => '00:00:00',
            'end_time' => '23:59:59',
            'is_full_day' => true,
            'reason' => 'تعطیلی هفتگی دوشنبه‌ها',
            'status' => 'active'
        ]);

        // تعطیلی سالانه (مثال: سال نو)
        BranchHoliday::create([
            'branch_id' => $branch->id,
            'holiday_type' => 'single_date',
            'start_date' => '2025-03-21', // نوروز
            'is_full_day' => true,
            'reason' => 'تعطیلی نوروز',
            'repeat_yearly' => true,
            'status' => 'active'
        ]);

        $this->command->info('Seeder تعطیلی‌های رستوران با موفقیت اجرا شد.');
    }
}
