# 🚀 راهنمای سریع: سیستم یادآوری محصولات غیرفعال

## 📝 خلاصه

این سیستم به صورت خودکار به رستوران‌هایی که محصولات غیرفعال زیادی دارند، پیامک یادآوری ارسال می‌کند.

## 📱 متن پیامک

```
{تعداد} عدد از محصولات فروشگاه {نام رستوران} شما غیرفعال میباشد لطفا سریعا نسبت به تعیین وضعیت و فعال سازی محصولات اقدام فرمایید
```

## ⚡ راه‌اندازی سریع (3 مرحله)

### 1️⃣ اجرای Migration

```bash
php artisan migrate
```

### 2️⃣ تنظیم Pattern در پنل SMS

در فایل `.env` این متغیرها را اضافه کنید:

```env
# برای Kavenegar
KAVENEGAR_SEND_SMS_INACTIVE_PRODUCTS=your_pattern_id

# برای FarazSMS
FARAZSMS_SEND_SMS_INACTIVE_PRODUCTS=your_pattern_id

# برای Melipayamak
MELIPAYAMAK_SEND_SMS_INACTIVE_PRODUCTS=your_pattern_id
```

**پارامترهای Pattern:**
- `{inactiveCount}` یا `token1`: تعداد محصولات غیرفعال
- `{restaurantName}` یا `token2`: نام رستوران

### 3️⃣ تنظیم Cron Job

در فایل `app/Console/Kernel.php`:

```php
protected function schedule(Schedule $schedule)
{
    // اجرای روزانه در ساعت 9 صبح
    $schedule->command('products:send-inactive-reminders --min-count=5')
             ->dailyAt('09:00');
}
```

## 🎯 نحوه کار

### الگوریتم ارسال پیامک:

```
برای هر رستوران:
  ├─ تعداد محصولات غیرفعال >= 5؟
  │  └─ خیر → رد شود
  │  
  └─ بله → ادامه
     │
     ├─ شماره در notification_mobiles ثبت شده؟
     │  ├─ بله → به تمام شماره‌های ثبت شده ارسال
     │  └─ خیر → به شماره مدیر رستوران ارسال
```

## 🔧 دستورات

### اجرای دستی

```bash
# با حد پیش‌فرض (5 محصول)
php artisan products:send-inactive-reminders

# با حد سفارشی (10 محصول)
php artisan products:send-inactive-reminders --min-count=10
```

### افزودن شماره‌های اختصاصی (اختیاری)

```sql
INSERT INTO notification_mobiles (branch_id, type, mobile, is_active) 
VALUES (1, 'product_inactive', '09121234567', true);
```

یا از API:

```http
POST /api/v1/admin/notification-mobiles
{
  "branch_id": 1,
  "type": "product_inactive",
  "mobile": "09121234567"
}
```

## 💡 مثال

### سناریو:
- **رستوران**: شعبه شماره 5 (رستوران سنتی)
- **محصولات غیرفعال**: 12 عدد
- **شماره مدیر**: 09121111111

### حالت 1: بدون notification_mobiles
```bash
php artisan products:send-inactive-reminders --min-count=5
```

**نتیجه:** 
✅ پیامک به `09121111111` (شماره مدیر) ارسال می‌شود

### حالت 2: با notification_mobiles
```sql
INSERT INTO notification_mobiles VALUES 
(5, 'product_inactive', '09122222222', true),
(5, 'product_inactive', '09123333333', true);
```

**نتیجه:** 
✅ پیامک به `09122222222` و `09123333333` ارسال می‌شود  
❌ به شماره مدیر ارسال **نمی‌شود** (اولویت با notification_mobiles است)

## ⚙️ تنظیمات پیشرفته

### تغییر زمان اجرا

```php
// هر روز ساعت 8 صبح
->dailyAt('08:00')

// هر یکشنبه ساعت 10 صبح  
->weeklyOn(0, '10:00')

// هر ماه روز اول ساعت 9 صبح
->monthlyOn(1, '09:00')

// هر 6 ساعت یکبار
->everySixHours()
```

### تغییر حد محصولات

```php
// فقط رستوران‌هایی با بیش از 10 محصول غیرفعال
->command('products:send-inactive-reminders --min-count=10')

// حساس‌تر: بیش از 3 محصول
->command('products:send-inactive-reminders --min-count=3')
```

## 📊 مانیتورینگ

### مشاهده رستوران‌های دارای محصول غیرفعال

```sql
SELECT 
    b.id,
    b.title,
    COUNT(p.id) as inactive_count
FROM branches b
LEFT JOIN products p ON p.branch_id = b.id AND p.status = 'inactive'
GROUP BY b.id, b.title
HAVING inactive_count > 5
ORDER BY inactive_count DESC;
```

### بررسی لاگ‌ها

```bash
tail -f storage/logs/laravel.log | grep "محصولات غیرفعال"
```

## ✅ Checklist راه‌اندازی

- [ ] Migration اجرا شده است
- [ ] Pattern در پنل SMS تعریف شده
- [ ] Environment variables در .env تنظیم شده
- [ ] Cron job در Kernel.php اضافه شده
- [ ] Queue worker در حال اجرا است (`php artisan queue:work`)
- [ ] Command به صورت دستی تست شده
- [ ] Cron سرور تنظیم شده

## 🆘 عیب‌یابی

### پیامک ارسال نمی‌شود؟

1. **بررسی Queue:**
   ```bash
   php artisan queue:work
   ```

2. **بررسی لاگ:**
   ```bash
   tail -100 storage/logs/laravel.log
   ```

3. **اجرای دستی:**
   ```bash
   php artisan products:send-inactive-reminders --min-count=1
   ```

4. **بررسی شماره‌ها:**
   ```sql
   SELECT * FROM notification_mobiles 
   WHERE branch_id = ? AND type = 'product_inactive';
   ```

## 📖 مستندات کامل

برای اطلاعات بیشتر: [inactive-products-reminder-system.md](./inactive-products-reminder-system.md)

---

**نکته:** اگر برای رستورانی شماره‌ای در `notification_mobiles` ثبت نکرده‌اید، نگران نباشید! سیستم به صورت خودکار از شماره مدیر رستوران استفاده می‌کند. 🎯





