# Admin Cash Back API Documentation

## Overview
این API ها برای مدیریت و مشاهده موجودی cash back کاربران توسط ادمین طراحی شده‌اند.

## Authentication
تمام API های زیر نیاز به احراز هویت ادمین دارند و باید از middleware `auth:api` و `CheckAccess` استفاده کنند.

## Endpoints

### 1. دریافت موجودی Cash Back کاربر در تمام رستوران‌ها (ادمین)

**Endpoint:** `GET /api/v1/admin/cash-back/user-balance`

**Description:** نمایش موجودی فعال cash back کاربر مشخص در تمام رستوران‌ها

**Headers:**
```
Authorization: Bearer {admin_token}
Content-Type: application/json
```

**Query Parameters:**
- `user_id` (required): شناسه کاربر

**Response:**
```json
{
    "status": 200,
    "message": "موجودی cash back کاربر با موفقیت دریافت شد",
    "data": {
        "user_id": 123,
        "balances": [
            {
                "branch_id": 1,
                "branch_name": "رستوران شاندیز",
                "branch_logo": "https://example.com/logo.png",
                "branch_address": "تهران، خیابان ولیعصر",
                "balance": 75000,
                "expired_at": "2024-12-31T23:59:59.000000Z",
                "is_expired": false,
                "days_until_expiry": 25
            }
        ]
    }
}
```

### 2. دریافت موجودی Cash Back کاربر در رستوران خاص (ادمین)

**Endpoint:** `GET /api/v1/admin/cash-back/user-balance/{branchId}`

**Description:** نمایش موجودی cash back کاربر مشخص در رستوران خاص

**Query Parameters:**
- `user_id` (required): شناسه کاربر

**Response:**
```json
{
    "status": 200,
    "message": "موجودی cash back کاربر با موفقیت دریافت شد",
    "data": {
        "branch_id": 1,
        "user_id": 123,
        "balance": 75000,
        "has_balance": true
    }
}
```

### 3. دریافت جزئیات کامل Cash Back کاربر (ادمین)

**Endpoint:** `GET /api/v1/admin/cash-back/user-details`

**Description:** نمایش جزئیات کامل cash back کاربر مشخص

**Query Parameters:**
- `user_id` (required): شناسه کاربر

**Response:**
```json
{
    "status": 200,
    "message": "جزئیات cash back کاربر با موفقیت دریافت شد",
    "data": {
        "user_id": 123,
        "details": {
            "summary": {
                "total_balance": 120000,
                "active_balance": 75000,
                "expired_balance": 45000,
                "total_branches": 3,
                "active_branches": 2,
                "expired_branches": 1
            },
            "branches": [
                {
                    "branch_id": 1,
                    "branch_name": "رستوران شاندیز",
                    "branch_logo": "https://example.com/logo1.png",
                    "branch_address": "تهران، خیابان ولیعصر",
                    "balance": 75000,
                    "expired_at": "2024-12-31T23:59:59.000000Z",
                    "is_expired": false,
                    "days_until_expiry": 25,
                    "cash_back_status": true,
                    "cash_back_percent": 10,
                    "cash_back_max_price": 100000
                }
            ]
        }
    }
}
```

### 4. لیست تمام کاربران با موجودی Cash Back (ادمین)

**Endpoint:** `GET /api/v1/admin/cash-back/all-users`

**Description:** نمایش لیست تمام کاربران که دارای موجودی cash back هستند

**Query Parameters:**
- `page` (optional): شماره صفحه (default: 1)
- `per_page` (optional): تعداد آیتم در هر صفحه (default: 20, max: 100)
- `search` (optional): جستجو بر اساس نام، نام خانوادگی یا شماره موبایل
- `branch_id` (optional): فیلتر بر اساس رستوران

**Response:**
```json
{
    "status": 200,
    "message": "لیست کاربران با موجودی cash back با موفقیت دریافت شد",
    "data": {
        "data": [
            {
                "user_id": 123,
                "user_name": "علی احمدی",
                "user_mobile": "09123456789",
                "total_balance": 120000,
                "active_balance": 75000,
                "expired_balance": 45000,
                "total_branches": 3,
                "active_branches": 2,
                "expired_branches": 1,
                "branches": [
                    {
                        "branch_id": 1,
                        "branch_name": "رستوران شاندیز",
                        "branch_logo": "https://example.com/logo1.png",
                        "balance": 75000,
                        "expired_at": "2024-12-31T23:59:59.000000Z",
                        "is_expired": false,
                        "days_until_expiry": 25
                    }
                ]
            }
        ],
        "pagination": {
            "current_page": 1,
            "last_page": 5,
            "per_page": 20,
            "total": 100,
            "from": 1,
            "to": 20
        }
    }
}
```

### 5. آمار کلی Cash Back سیستم (ادمین)

**Endpoint:** `GET /api/v1/admin/cash-back/statistics`

**Description:** نمایش آمار کلی cash back کل سیستم

**Response:**
```json
{
    "status": 200,
    "message": "آمار cash back با موفقیت دریافت شد",
    "data": {
        "overview": {
            "total_wallets": 1500,
            "active_wallets": 1200,
            "expired_wallets": 300,
            "total_balance": 50000000,
            "active_balance": 40000000,
            "expired_balance": 10000000,
            "unique_users": 800,
            "unique_branches": 25
        },
        "top_branches": [
            {
                "branch_id": 1,
                "branch_name": "رستوران شاندیز",
                "total_balance": 10000000,
                "active_balance": 8000000,
                "expired_balance": 2000000,
                "total_users": 200,
                "active_users": 150
            }
        ]
    }
}
```

## Error Responses

### 400 Bad Request (Validation Error)
```json
{
    "status": 400,
    "message": "خطا در اعتبارسنجی داده‌ها",
    "errors": {
        "user_id": [
            "فیلد user_id الزامی است."
        ]
    }
}
```

### 401 Unauthorized
```json
{
    "message": "Unauthenticated."
}
```

### 403 Forbidden
```json
{
    "message": "دسترسی غیرمجاز"
}
```

### 500 Internal Server Error
```json
{
    "status": 500,
    "message": "خطا در دریافت موجودی cash back",
    "error": "Error details"
}
```

## Usage Examples

### دریافت موجودی کاربر خاص
```bash
curl -X GET "https://api.example.com/api/v1/admin/cash-back/user-balance?user_id=123" \
  -H "Authorization: Bearer ADMIN_TOKEN" \
  -H "Content-Type: application/json"
```

### دریافت موجودی کاربر در رستوران خاص
```bash
curl -X GET "https://api.example.com/api/v1/admin/cash-back/user-balance/1?user_id=123" \
  -H "Authorization: Bearer ADMIN_TOKEN" \
  -H "Content-Type: application/json"
```

### جستجوی کاربران
```bash
curl -X GET "https://api.example.com/api/v1/admin/cash-back/all-users?search=علی&page=1&per_page=10" \
  -H "Authorization: Bearer ADMIN_TOKEN" \
  -H "Content-Type: application/json"
```

### دریافت آمار کلی
```bash
curl -X GET "https://api.example.com/api/v1/admin/cash-back/statistics" \
  -H "Authorization: Bearer ADMIN_TOKEN" \
  -H "Content-Type: application/json"
```

## Notes

1. **دسترسی ادمین**: تمام API ها نیاز به دسترسی ادمین دارند
2. **اعتبارسنجی**: تمام ورودی‌ها اعتبارسنجی می‌شوند
3. **صفحه‌بندی**: API لیست کاربران از صفحه‌بندی پشتیبانی می‌کند
4. **جستجو**: امکان جستجو بر اساس نام، نام خانوادگی و شماره موبایل
5. **فیلتر**: امکان فیلتر بر اساس رستوران
6. **آمار**: آمار کلی سیستم و برترین رستوران‌ها
