# Cash Back API Documentation

## Overview
این API ها برای مدیریت و نمایش موجودی cash back کاربران در رستوران‌های مختلف طراحی شده‌اند.

## Authentication
تمام API های زیر نیاز به احراز هویت دارند و باید از middleware `auth:api` استفاده کنند.

## Endpoints

### 1. دریافت موجودی Cash Back در تمام رستوران‌ها

**Endpoint:** `GET /api/v1/user/cash-back/balance`

**Description:** نمایش موجودی فعال cash back کاربر در تمام رستوران‌ها

**Headers:**
```
Authorization: Bearer {token}
Content-Type: application/json
```

**Response:**
```json
{
    "status": 200,
    "message": "موجودی cash back با موفقیت دریافت شد",
    "data": [
        {
            "branch_id": 1,
            "branch_name": "رستوران نمونه",
            "branch_logo": "https://example.com/logo.png",
            "branch_address": "تهران، خیابان نمونه",
            "balance": 50000,
            "expired_at": "2024-12-31T23:59:59.000000Z",
            "is_expired": false,
            "days_until_expiry": 30
        }
    ]
}
```

### 2. دریافت موجودی Cash Back در رستوران خاص

**Endpoint:** `GET /api/v1/user/cash-back/balance/{branchId}`

**Description:** نمایش موجودی cash back کاربر در رستوران مشخص

**Parameters:**
- `branchId` (integer): شناسه رستوران

**Headers:**
```
Authorization: Bearer {token}
Content-Type: application/json
```

**Response:**
```json
{
    "status": 200,
    "message": "موجودی cash back با موفقیت دریافت شد",
    "data": {
        "branch_id": 1,
        "user_id": 123,
        "balance": 50000,
        "has_balance": true
    }
}
```

### 3. دریافت جزئیات کامل Cash Back

**Endpoint:** `GET /api/v1/user/cash-back/details`

**Description:** نمایش جزئیات کامل cash back کاربر شامل خلاصه و لیست تمام رستوران‌ها

**Headers:**
```
Authorization: Bearer {token}
Content-Type: application/json
```

**Response:**
```json
{
    "status": 200,
    "message": "جزئیات cash back با موفقیت دریافت شد",
    "data": {
        "summary": {
            "total_balance": 150000,
            "active_balance": 100000,
            "expired_balance": 50000,
            "total_branches": 3,
            "active_branches": 2,
            "expired_branches": 1
        },
        "branches": [
            {
                "branch_id": 1,
                "branch_name": "رستوران نمونه 1",
                "branch_logo": "https://example.com/logo1.png",
                "branch_address": "تهران، خیابان نمونه 1",
                "balance": 50000,
                "expired_at": "2024-12-31T23:59:59.000000Z",
                "is_expired": false,
                "days_until_expiry": 30,
                "cash_back_status": true,
                "cash_back_percent": 10,
                "cash_back_max_price": 100000
            },
            {
                "branch_id": 2,
                "branch_name": "رستوران نمونه 2",
                "branch_logo": "https://example.com/logo2.png",
                "branch_address": "تهران، خیابان نمونه 2",
                "balance": 50000,
                "expired_at": "2024-11-30T23:59:59.000000Z",
                "is_expired": true,
                "days_until_expiry": -5,
                "cash_back_status": true,
                "cash_back_percent": 15,
                "cash_back_max_price": 150000
            }
        ]
    }
}
```

## Error Responses

### 401 Unauthorized
```json
{
    "message": "Unauthenticated."
}
```

### 500 Internal Server Error
```json
{
    "status": 500,
    "message": "خطا در دریافت موجودی cash back",
    "error": "Error details"
}
```

## Notes

1. **فیلتر موجودی فعال**: API موجودی‌های منقضی شده را فیلتر می‌کند
2. **محاسبه روزهای انقضا**: تعداد روزهای باقی‌مانده تا انقضا محاسبه می‌شود
3. **اطلاعات رستوران**: نام، لوگو و آدرس رستوران همراه با موجودی نمایش داده می‌شود
4. **خلاصه آماری**: در API جزئیات، خلاصه‌ای از کل موجودی‌ها ارائه می‌شود

## Usage Examples

### دریافت موجودی در تمام رستوران‌ها
```bash
curl -X GET "https://api.example.com/api/v1/user/cash-back/balance" \
  -H "Authorization: Bearer {your_token}" \
  -H "Content-Type: application/json"
```

### دریافت موجودی در رستوران خاص
```bash
curl -X GET "https://api.example.com/api/v1/user/cash-back/balance/1" \
  -H "Authorization: Bearer {your_token}" \
  -H "Content-Type: application/json"
```

### دریافت جزئیات کامل
```bash
curl -X GET "https://api.example.com/api/v1/user/cash-back/details" \
  -H "Authorization: Bearer {your_token}" \
  -H "Content-Type: application/json"
```
