# 📦 سیستم یادآوری محصولات غیرفعال

## 📋 توضیحات کلی

این سیستم به صورت خودکار رستوران‌هایی که تعداد زیادی محصول غیرفعال دارند را شناسایی کرده و برای آن‌ها پیامک یادآوری ارسال می‌کند.

## ⚙️ نحوه کار

1. **شناسایی رستوران‌ها**: سیستم رستوران‌هایی که تعداد محصولات غیرفعالشان بیشتر از حد مشخصی است را پیدا می‌کند.
2. **دریافت شماره‌های رستوران**: برای هر رستوران، شماره‌های موبایل از جدول `notification_mobiles` با نوع `product_inactive` دریافت می‌شود.
3. **ارسال پیامک**: برای هر شماره یک Job ارسال می‌شود که پیامک یادآوری را می‌فرستد.

## 📱 متن پیامک

```
{تعداد} عدد از محصولات فروشگاه {نام رستوران} شما غیرفعال میباشد لطفا سریعا نسبت به تعیین وضعیت و فعال سازی محصولات اقدام فرمایید
```

**پارامترها:**
- `{تعداد}`: تعداد محصولات غیرفعال
- `{نام رستوران}`: نام رستوران/شعبه

## 🚀 راه‌اندازی

### 1. اجرای Migration

```bash
php artisan migrate
```

این migration نوع جدید `product_inactive` را به جدول `notification_mobiles` اضافه می‌کند.

### 2. افزودن شماره‌های نوتیفیکیشن

برای هر رستوران باید شماره‌های موبایل را در جدول `notification_mobiles` اضافه کنید:

```sql
INSERT INTO notification_mobiles (branch_id, type, mobile, is_active) 
VALUES 
  (1, 'product_inactive', '09121234567', true),
  (1, 'product_inactive', '09129876543', true);
```

یا از طریق API:

```http
POST /api/v1/admin/notification-mobiles
Content-Type: application/json

{
  "branch_id": 1,
  "type": "product_inactive",
  "mobile": "09121234567",
  "is_active": true
}
```

### 3. تنظیم Cron Job

این Command باید به صورت دوره‌ای (مثلاً روزانه یا هفتگی) اجرا شود.

**افزودن به `app/Console/Kernel.php`:**

```php
protected function schedule(Schedule $schedule)
{
    // اجرای روزانه در ساعت 9 صبح
    $schedule->command('products:send-inactive-reminders --min-count=5')
             ->dailyAt('09:00')
             ->withoutOverlapping();
             
    // یا اجرای هفتگی در روز یکشنبه ساعت 10 صبح
    $schedule->command('products:send-inactive-reminders --min-count=10')
             ->weeklyOn(0, '10:00')
             ->withoutOverlapping();
}
```

**تنظیم Cron در سرور:**

```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

## 🔧 پارامترها

### Command Options

```bash
php artisan products:send-inactive-reminders [options]
```

**Options:**
- `--min-count=N`: حداقل تعداد محصولات غیرفعال برای ارسال پیامک (پیش‌فرض: 5)

**مثال‌ها:**

```bash
# ارسال برای رستوران‌هایی با حداقل 5 محصول غیرفعال (پیش‌فرض)
php artisan products:send-inactive-reminders

# ارسال برای رستوران‌هایی با حداقل 10 محصول غیرفعال
php artisan products:send-inactive-reminders --min-count=10

# ارسال برای رستوران‌هایی با حداقل 3 محصول غیرفعال
php artisan products:send-inactive-reminders --min-count=3
```

## 📊 ساختار جدول

### notification_mobiles

| ستون | نوع | توضیحات |
|------|-----|---------|
| id | BIGINT | شناسه یکتا |
| branch_id | BIGINT | شناسه رستوران |
| type | ENUM | نوع نوتیفیکیشن (`product_inactive`) |
| mobile | VARCHAR(20) | شماره موبایل |
| is_active | BOOLEAN | وضعیت فعال/غیرفعال |

## 🔍 Queries مفید

### مشاهده تعداد محصولات غیرفعال هر رستوران

```sql
SELECT 
    b.id,
    b.title AS restaurant_name,
    COUNT(p.id) AS inactive_products_count
FROM branches b
LEFT JOIN products p ON p.branch_id = b.id AND p.status = 'inactive'
GROUP BY b.id, b.title
HAVING inactive_products_count > 0
ORDER BY inactive_products_count DESC;
```

### مشاهده شماره‌های ثبت شده برای هر رستوران

```sql
SELECT 
    b.title AS restaurant_name,
    nm.mobile,
    nm.is_active,
    nm.created_at
FROM notification_mobiles nm
INNER JOIN branches b ON b.id = nm.branch_id
WHERE nm.type = 'product_inactive'
ORDER BY b.title, nm.id;
```

## 📝 لاگ‌ها

سیستم تمام عملیات را در Log ثبت می‌کند:

```php
// موفقیت‌آمیز
Log::info("SMS محصولات غیرفعال ارسال شد", [...]);

// خطا
Log::error("خطا در ارسال SMS محصولات غیرفعال: ...", [...]);
```

مسیر لاگ‌ها: `storage/logs/laravel.log`

## 🎯 مثال کامل

### Scenario: رستوران با 8 محصول غیرفعال

1. **وضعیت رستوران:**
   - Branch ID: 5
   - نام: رستوران سنتی شیراز
   - تعداد محصولات غیرفعال: 8

2. **شماره‌های ثبت شده:**
   - 09121111111 (فعال)
   - 09122222222 (فعال)
   - 09123333333 (غیرفعال) ← این شماره دریافت نمی‌کند

3. **اجرای Command:**
```bash
php artisan products:send-inactive-reminders --min-count=5
```

4. **نتیجه:**
   - 2 Job ایجاد می‌شود (برای 2 شماره فعال)
   - پیامک ارسال می‌شود:
   ```
   8 عدد از محصولات فروشگاه رستوران سنتی شیراز شما غیرفعال میباشد لطفا سریعا نسبت به تعیین وضعیت و فعال سازی محصولات اقدام فرمایید
   ```

## ⚠️ نکات مهم

1. **Queue**: این سیستم از Queue استفاده می‌کند. مطمئن شوید Queue Worker اجرا شده است:
   ```bash
   php artisan queue:work
   ```

2. **Pattern SMS**: باید در پنل SMS مربوطه Pattern مورد نظر را تعریف کنید:
   - `KAVENEGAR_SEND_SMS_INACTIVE_PRODUCTS`
   - `FARAZSMS_SEND_SMS_INACTIVE_PRODUCTS`
   - `MELIPAYAMAK_SEND_SMS_INACTIVE_PRODUCTS`

3. **تست**: قبل از تنظیم در Cron، حتماً Command را به صورت دستی تست کنید.

4. **شماره‌های ثبت شده**: اگر برای رستورانی شماره‌ای ثبت نشده باشد، پیامک ارسال نمی‌شود.

## 🔗 فایل‌های مرتبط

- Command: `app/Console/Commands/SendInactiveProductsReminders.php`
- Job: `app/Jobs/SendInactiveProductsSms.php`
- Migration: `database/migrations/2025_10_28_202343_add_product_inactive_to_notification_mobiles_table.php`
- Enum: `app/Enums/NotificationType.php`
- SMS Repositories: `app/Repositories/SMS/*`

## 📞 پشتیبانی

در صورت بروز مشکل، لاگ‌ها را بررسی کنید و با تیم فنی تماس بگیرید.





