# سیستم آلارم و اطلاع‌رسانی تاخیر تحویل سفارش

## توضیحات کلی

این سیستم برای ارسال پیامک خودکار به رستوران‌ها در صورت تاخیر در تحویل سفارش طراحی شده است. سیستم از notification mobile استفاده می‌کند تا شماره‌های موبایل رستوران‌ها را مدیریت کند.

## اجزای سیستم

### 1. Command جدید
- **فایل**: `app/Console/Commands/SendOrderDelayDeliveryReminders.php`
- **دستور**: `php artisan orders:send-delay-delivery-reminders`
- **پارامتر**: `--minutes=30` (پیش‌فرض: 30 دقیقه)

### 2. Job جدید
- **فایل**: `app/Jobs/SendOrderDelayDeliverySms.php`
- **وظیفه**: ارسال پیامک با استفاده از SMS Repository

### 3. متد جدید SMS
- **متد**: `sendSMSOrderDelayDelivery`
- **پارامترها**:
  - `$orderId`: شماره سفارش
  - `$customerName`: نام مشتری
  - `$mobile`: شماره موبایل رستوران

### 4. Migration جدید
- **فایل**: `database/migrations/2025_10_20_192944_add_delay_delivery_reminder_sent_at_to_orders_table.php`
- **فیلد جدید**: `delay_delivery_reminder_sent_at` در جدول `orders`

### 5. نوع جدید Notification
- **نوع**: `ORDER_DELAY_DELIVERY` در `NotificationType` enum
- **توضیحات**: پیامک تاخیر تحویل سفارش برای رستوران

## تنظیمات کرون جاب

در فایل `app/Console/Kernel.php` کرون جاب زیر اضافه شده است:

```php
$schedule->command('orders:send-delay-delivery-reminders')
    ->everyTenMinutes()
    ->withoutOverlapping()
    ->onOneServer();
```

## تنظیمات Environment Variables

برای هر سرویس SMS باید متغیرهای زیر را در فایل `.env` اضافه کنید:

### Kavenegar
```
KAVENEGAR_SEND_SMS_ORDER_DELAY_DELIVERY=your_pattern_id
```

### Melipayamak
```
MELIPAYAMAK_SEND_SMS_ORDER_DELAY_DELIVERY=your_pattern_id
```

### FarazSMS
```
FARAZSMS_SEND_SMS_ORDER_DELAY_DELIVERY=your_pattern_id
```

## نحوه کارکرد

1. **شناسایی سفارشات**: سیستم هر 10 دقیقه سفارشاتی را که بیش از 30 دقیقه در وضعیت‌های `preparing`, `sending`, یا `ready_to_send` هستند و هنوز یادآوری ارسال نشده، شناسایی می‌کند.

2. **دریافت شماره‌های رستوران**: برای هر سفارش، شماره‌های موبایل رستوران از جدول `notification_mobiles` با نوع `order_delay_delivery` دریافت می‌شود.

3. **ارسال پیامک**: برای هر شماره موبایل رستوران، یک Job ایجاد می‌شود که پیامک را ارسال می‌کند.

4. **ثبت ارسال**: پس از ارسال موفق، فیلد `delay_delivery_reminder_sent_at` به‌روزرسانی می‌شود تا از ارسال مجدد جلوگیری شود.

## تنظیم شماره‌های موبایل رستوران

برای هر رستوران باید شماره‌های موبایل را در جدول `notification_mobiles` اضافه کنید:

```sql
INSERT INTO notification_mobiles (branch_id, type, mobile, is_active) 
VALUES (1, 'order_delay_delivery', '09123456789', true);
```

## تست سیستم

برای تست دستی سیستم:

```bash
php artisan orders:send-delay-delivery-reminders --minutes=30
```

## پترن پیامک پیشنهادی

```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} بیش از حد معمول در انتظار تحویل است.
لطفا در اسرع وقت اقدام کنید.
```

## نکات مهم

1. سیستم فقط برای سفارشات با وضعیت‌های `preparing`, `sending`, `ready_to_send` کار می‌کند.
2. هر سفارش فقط یک بار یادآوری ارسال می‌شود.
3. سیستم از SMS Repository Chain استفاده می‌کند که در صورت عدم دسترسی یک سرویس، به سرویس بعدی متصل می‌شود.
4. تمام عملیات در Log ثبت می‌شوند.
5. پیامک به شماره‌های موبایل رستوران ارسال می‌شود.
6. ورودی‌های مورد نیاز: شماره سفارش و نام مشتری
7. شماره‌های موبایل از جدول `notification_mobiles` دریافت می‌شوند.
