# API مستندات سیستم پاپ‌آپ آلارم

## توضیحات کلی
این سیستم امکان ایجاد و مدیریت پاپ‌آپ آلارم‌ها برای رستوران‌ها را فراهم می‌کند. هر رستوران می‌تواند آلارم‌هایی با متن، عکس و زمان شروع و پایان ایجاد کند که فقط یکبار به هر کاربر نمایش داده می‌شود.

## جدول‌های دیتابیس

### popup_alarms
- `id`: شناسه یکتا
- `branch_id`: شناسه رستوران
- `title`: عنوان آلارم
- `message`: متن آلارم
- `image`: مسیر عکس (اختیاری)
- `start_time`: زمان شروع نمایش
- `end_time`: زمان پایان نمایش
- `status`: وضعیت (active/inactive)
- `created_at`, `updated_at`: زمان‌های ایجاد و به‌روزرسانی

### popup_alarm_views
- `id`: شناسه یکتا
- `popup_alarm_id`: شناسه آلارم
- `user_id`: شناسه کاربر
- `viewed_at`: زمان مشاهده
- `created_at`, `updated_at`: زمان‌های ایجاد و به‌روزرسانی

## API Endpoints

### 1. ایجاد آلارم جدید (برای رستوران‌ها)
**POST** `/api/v1/popup-alarms/store` (برای رستوران‌ها)
**POST** `/api/v1/admin/popup-alarms/store` (برای ادمین)

**Headers:**
```
Authorization: Bearer {token}
Content-Type: multipart/form-data
```

**Body:**
```json
{
    "branch_id": 1,
    "title": "تخفیف ویژه",
    "message": "تا پایان هفته 20% تخفیف ویژه",
    "image": "file", // اختیاری
    "start_time": "2025-10-01 10:00:00",
    "end_time": "2025-10-07 23:59:59"
}
```

**Response:**
```json
{
    "success": true,
    "message": "آلارم با موفقیت ایجاد شد",
    "data": {
        "id": 1,
        "title": "تخفیف ویژه",
        "message": "تا پایان هفته 20% تخفیف ویژه",
        "image": "uploads/popup_alarms/1234567890.jpg",
        "start_time": "1403/07/10 10:00",
        "end_time": "1403/07/16 23:59",
        "status": "active",
        "created_at": "1403/07/10 08:41"
    }
}
```

### 2. دریافت آلارم‌های فعال که کاربر ندیده
**GET** `/api/v1/popup-alarms/unseen-alarms`

**Headers:**
```
Authorization: Bearer {token}
```

**Query Parameters:**
- `branch_id` (اختیاری): فیلتر بر اساس رستوران خاص

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "branch_id": 1,
            "branch_title": "رستوران نمونه",
            "title": "تخفیف ویژه",
            "message": "تا پایان هفته 20% تخفیف ویژه",
            "image": "http://domain.com/uploads/popup_alarms/1234567890.jpg",
            "start_time": "1403/07/10 10:00",
            "end_time": "1403/07/16 23:59",
            "created_at": "1403/07/10 08:41"
        }
    ]
}
```

### 3. ثبت مشاهده آلارم توسط کاربر
**POST** `/api/v1/popup-alarms/mark-viewed`

**Headers:**
```
Authorization: Bearer {token}
Content-Type: application/json
```

**Body:**
```json
{
    "alarm_id": 1
}
```

**Response:**
```json
{
    "success": true,
    "message": "آلارم به عنوان مشاهده شده ثبت شد",
    "data": {
        "viewed_at": "1403/07/10 08:45"
    }
}
```

### 4. دریافت لیست آلارم‌های رستوران
**GET** `/api/v1/popup-alarms/my-alarms` (برای رستوران‌ها - آلارم‌های خودشان)
**GET** `/api/v1/admin/popup-alarms/branch-alarms` (برای ادمین - آلارم‌های هر رستوران)

**Headers:**
```
Authorization: Bearer {token}
```

**Query Parameters:**
- `branch_id`: شناسه رستوران (اجباری)
- `per_page`: تعداد آیتم در هر صفحه (اختیاری، پیش‌فرض: 15)

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "id": 1,
            "title": "تخفیف ویژه",
            "message": "تا پایان هفته 20% تخفیف ویژه",
            "image": "http://domain.com/uploads/popup_alarms/1234567890.jpg",
            "start_time": "1403/07/10 10:00",
            "end_time": "1403/07/16 23:59",
            "status": "active",
            "is_active": true,
            "total_views": 25,
            "created_at": "1403/07/10 08:41"
        }
    ],
    "pagination": {
        "current_page": 1,
        "last_page": 3,
        "per_page": 15,
        "total": 45
    }
}
```

### 5. به‌روزرسانی آلارم
**PUT** `/api/v1/popup-alarms/update/{id}` (برای رستوران‌ها)
**PUT** `/api/v1/admin/popup-alarms/update/{id}` (برای ادمین)

**Headers:**
```
Authorization: Bearer {token}
Content-Type: multipart/form-data
```

**Body:**
```json
{
    "title": "تخفیف ویژه جدید",
    "message": "تخفیف 30% برای تمام محصولات",
    "image": "file", // اختیاری
    "start_time": "2025-10-01 10:00:00",
    "end_time": "2025-10-07 23:59:59",
    "status": "active"
}
```

**Response:**
```json
{
    "success": true,
    "message": "آلارم با موفقیت به‌روزرسانی شد"
}
```

### 6. حذف آلارم
**DELETE** `/api/v1/popup-alarms/destroy/{id}` (برای رستوران‌ها)
**DELETE** `/api/v1/admin/popup-alarms/destroy/{id}` (برای ادمین)

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "message": "آلارم با موفقیت حذف شد"
}
```

### 7. دریافت آمار مشاهده آلارم
**GET** `/api/v1/popup-alarms/view-stats/{id}` (برای رستوران‌ها)
**GET** `/api/v1/admin/popup-alarms/view-stats/{id}` (برای ادمین)

**Headers:**
```
Authorization: Bearer {token}
```

**Response:**
```json
{
    "success": true,
    "data": {
        "total_views": 150,
        "unique_users": 120,
        "views_today": 25,
        "views_this_week": 85
    }
}
```

## دسترسی‌ها

### برای ادمین:
- می‌تواند برای هر رستوران آلارم ایجاد کند
- می‌تواند تمام آلارم‌ها را مشاهده، ویرایش و حذف کند
- می‌تواند آمار تمام آلارم‌ها را ببیند

### برای رستوران‌ها:
- فقط می‌توانند برای رستوران‌های خود آلارم ایجاد کنند
- فقط می‌توانند آلارم‌های رستوران خود را مشاهده، ویرایش و حذف کنند
- فقط می‌توانند آمار آلارم‌های رستوران خود را ببینند

## نکات مهم

1. **تاریخ‌ها**: تمام تاریخ‌ها در پاسخ‌ها به صورت شمسی نمایش داده می‌شوند
2. **تصاویر**: مسیر تصاویر به صورت کامل URL برگردانده می‌شود
3. **احراز هویت**: تمام API ها نیاز به احراز هویت دارند
4. **فیلتر زمانی**: فقط آلارم‌هایی که در بازه زمانی فعال هستند نمایش داده می‌شوند
5. **یکبار نمایش**: هر کاربر فقط یکبار هر آلارم را می‌بیند
6. **آپلود تصاویر**: تصاویر در پوشه `public/uploads/popup_alarms/` ذخیره می‌شوند
7. **کنترل دسترسی**: رستوران‌ها فقط به آلارم‌های خود دسترسی دارند

## مثال استفاده در فرانت‌اند

```javascript
// دریافت آلارم‌های ندیده
const getUnseenAlarms = async () => {
    const response = await fetch('/api/v1/popup-alarms/unseen-alarms', {
        headers: {
            'Authorization': `Bearer ${token}`,
            'Content-Type': 'application/json'
        }
    });
    const data = await response.json();
    return data.data;
};

// ثبت مشاهده آلارم
const markAsViewed = async (alarmId) => {
    const response = await fetch('/api/v1/popup-alarms/mark-viewed', {
        method: 'POST',
        headers: {
            'Authorization': `Bearer ${token}`,
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ alarm_id: alarmId })
    });
    return response.json();
};
```

