# راهنمای تنظیم پترن SMS برای تاخیر تایید و تحویل سفارش

## سیستم تاخیر تایید سفارش (برای رستوران)

### Kavenegar

#### تنظیمات Environment
```env
KAVENEGAR_SEND_SMS_ORDER_DELAY_APPROVAL=123456
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} با مبلغ {orderAmount} بیش از حد معمول در انتظار تایید است.
لطفا در اسرع وقت اقدام کنید.
```

#### نحوه استفاده در کد
```php
$SMSRepository->sendSMSOrderDelayApproval(
    $orderId,        // شماره سفارش
    $customerName,   // نام مشتری
    $orderAmount,    // مبلغ سفارش
    $restaurantName, // نام رستوران
    $mobile          // شماره موبایل رستوران
);
```

### Melipayamak

#### تنظیمات Environment
```env
MELIPAYAMAK_SEND_SMS_ORDER_DELAY_APPROVAL=123456
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} با مبلغ {orderAmount} بیش از حد معمول در انتظار تایید است.
لطفا در اسرع وقت اقدام کنید.
```

### FarazSMS

#### تنظیمات Environment
```env
FARAZSMS_SEND_SMS_ORDER_DELAY_APPROVAL=123456
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} با مبلغ {orderAmount} بیش از حد معمول در انتظار تایید است.
لطفا در اسرع وقت اقدام کنید.
```

## سیستم تاخیر تحویل سفارش (برای رستوران)

### Kavenegar

#### تنظیمات Environment
```env
KAVENEGAR_SEND_SMS_ORDER_DELAY_DELIVERY=123457
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} بیش از حد معمول در انتظار تحویل است.
لطفا در اسرع وقت اقدام کنید.
```

#### نحوه استفاده در کد
```php
$SMSRepository->sendSMSOrderDelayDelivery(
    $orderId,        // شماره سفارش
    $customerName,   // نام مشتری
    $mobile          // شماره موبایل رستوران
);
```

### Melipayamak

#### تنظیمات Environment
```env
MELIPAYAMAK_SEND_SMS_ORDER_DELAY_DELIVERY=123457
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} بیش از حد معمول در انتظار تحویل است.
لطفا در اسرع وقت اقدام کنید.
```

### FarazSMS

#### تنظیمات Environment
```env
FARAZSMS_SEND_SMS_ORDER_DELAY_DELIVERY=123457
```

#### پترن پیشنهادی
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} بیش از حد معمول در انتظار تحویل است.
لطفا در اسرع وقت اقدام کنید.
```

## نکات مهم

1. **متغیرهای پترن**: در هر سرویس، متغیرهای پترن ممکن است متفاوت باشند. لطفا با سرویس SMS خود هماهنگ کنید.

2. **تست پترن**: قبل از استفاده در محیط تولید، حتما پترن را تست کنید.

3. **محدودیت کاراکتر**: پیامک‌ها معمولا محدودیت 160 کاراکتر دارند.

4. **زبان**: از متن فارسی استفاده کنید و مطمئن شوید سرویس SMS از UTF-8 پشتیبانی می‌کند.

5. **مخاطب**: 
   - پیامک تاخیر تایید به رستوران‌ها ارسال می‌شود
   - پیامک تاخیر تحویل به رستوران‌ها ارسال می‌شود

## مثال کامل پترن‌ها

### تاخیر تایید سفارش (رستوران)
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} با مبلغ {orderAmount} بیش از حد معمول در انتظار تایید است.
لطفا در اسرع وقت اقدام کنید.
```
**تعداد کاراکتر**: 120 کاراکتر (مناسب برای SMS)

### تاخیر تحویل سفارش (رستوران)
```
سلام مدیر گرامی
سفارش شماره {orderId} از مشتری {customerName} بیش از حد معمول در انتظار تحویل است.
لطفا در اسرع وقت اقدام کنید.
```
**تعداد کاراکتر**: 100 کاراکتر (مناسب برای SMS)
