# API مستندات خریدهای قبلی کاربر از فروشگاه

## دریافت تاریخچه خرید کاربر از فروشگاه خاص

این API برای دریافت تاریخچه خریدهای یک کاربر از یک فروشگاه خاص استفاده می‌شود.

### درخواست

```http
GET /api/user-orders/branch-orders
```

### پارامترهای Query

| پارامتر | نوع | اجباری | توضیحات | مثال |
|---------|-----|--------|---------|------|
| `user_id` | integer | ✅ | شناسه کاربر | `123` |
| `branch_id` | integer | ✅ | شناسه فروشگاه | `5` |
| `per_page` | integer | ❌ | تعداد آیتم در هر صفحه (پیش‌فرض: 15) | `10` |
| `order_status` | string | ❌ | وضعیت سفارش | `delivered` |
| `payment_status` | string | ❌ | وضعیت پرداخت | `true` |
| `start_date` | string | ❌ | تاریخ شروع (فرمت: Y/m/d) | `1403/01/01` |
| `end_date` | string | ❌ | تاریخ پایان (فرمت: Y/m/d) | `1403/12/29` |
| `min_amount` | numeric | ❌ | حداقل مبلغ سفارش | `50000` |
| `max_amount` | numeric | ❌ | حداکثر مبلغ سفارش | `500000` |

### وضعیت‌های سفارش (order_status)

- `ordering` - در حال سفارش
- `wating_payment` - انتظار پرداخت
- `awaiting_restaurant_approval` - انتظار تایید رستوران
- `preparing` - در حال آماده‌سازی
- `sending` - در حال ارسال
- `delivered` - تحویل شده
- `ready_to_send` - آماده ارسال
- `returned` - برگشت خورده
- `cancelled` - لغو شده

### مثال درخواست

```bash
curl -X GET "https://api.limofood.com/api/user-orders/branch-orders?user_id=123&branch_id=5&per_page=10&order_status=delivered&start_date=1403/01/01&end_date=1403/01/31" \
  -H "Accept: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### پاسخ موفق

```json
{
  "status": "success",
  "message": "تاریخچه خرید کاربر از فروشگاه با موفقیت دریافت شد",
  "data": {
    "user": {
      "id": 123,
      "name": "احمد",
      "family": "احمدی",
      "mobile": "09123456789",
      "email": "ahmad@example.com"
    },
    "branch": {
      "id": 5,
      "title": "رستوران نمونه",
      "address": "تهران، خیابان ولیعصر، پلاک 456",
      "logo": "uploads/branches/logo5.jpg",
      "min_order": "50000",
      "vendor_id": 2
    },
    "orders": {
      "current_page": 1,
      "data": [
        {
          "id": 1,
          "code": "ORD-20240101-001",
          "order_status": "delivered",
          "payment_status": "true",
          "payment_type": "online",
          "order_price": "150000",
          "order_price_payed": "150000",
          "delivery_price": "10000",
          "cash_back_price": "5000",
          "tax_price": "15000",
          "discount_price": "10000",
          "delivery_time": "30",
          "preparation_time": "20",
          "description": "لطفاً زنگ بزنید",
          "pager_number": null,
          "table_number": null,
          "kitchen_description": null,
          "type_order": "platform",
          "created_at": "2024-01-01 10:30:00",
          "updated_at": "2024-01-01 12:00:00",
          "created_at_jalali": "1402/10/11 10:30:00",
          "updated_at_jalali": "1402/10/11 12:00:00",
          "address": {
            "id": 5,
            "title": "منزل",
            "address": "تهران، خیابان ولیعصر، پلاک 123",
            "lat": "35.7219",
            "lng": "51.3347",
            "phone_number": "09123456789"
          },
          "user": {
            "id": 123,
            "name": "احمد",
            "family": "احمدی",
            "mobile": "09123456789",
            "email": "ahmad@example.com"
          },
          "branch": {
            "id": 5,
            "title": "رستوران نمونه",
            "address": "تهران، خیابان ولیعصر، پلاک 456",
            "logo": "uploads/branches/logo5.jpg",
            "min_order": "50000",
            "vendor_id": 2
          },
          "driver": {
            "id": 1,
            "name": "علی",
            "family": "علی‌زاده",
            "mobile": "09123456788",
            "user": {
              "id": 456,
              "name": "علی",
              "family": "علی‌زاده",
              "mobile": "09123456788"
            }
          },
          "delivery_type": {
            "id": 1,
            "title": "تحویل درب منزل"
          },
          "order_cart": [
            {
              "id": 1,
              "count": 2,
              "price": "75000",
              "discount": "0",
              "description": null,
              "extras": null,
              "variety": {
                "id": 1,
                "title": "کباب کوبیده",
                "price": "75000"
              }
            }
          ]
        }
      ],
      "first_page_url": "https://api.limofood.com/api/user-orders/branch-orders?page=1",
      "from": 1,
      "last_page": 3,
      "last_page_url": "https://api.limofood.com/api/user-orders/branch-orders?page=3",
      "links": [...],
      "next_page_url": "https://api.limofood.com/api/user-orders/branch-orders?page=2",
      "path": "https://api.limofood.com/api/user-orders/branch-orders",
      "per_page": 15,
      "prev_page_url": null,
      "to": 15,
      "total": 45
    }
  }
}
```

---

## دریافت آمار خرید کاربر از فروشگاه

این API برای دریافت آمار و اطلاعات کلی خریدهای یک کاربر از یک فروشگاه خاص استفاده می‌شود.

### درخواست

```http
GET /api/user-orders/branch-stats
```

### پارامترهای Query

| پارامتر | نوع | اجباری | توضیحات | مثال |
|---------|-----|--------|---------|------|
| `user_id` | integer | ✅ | شناسه کاربر | `123` |
| `branch_id` | integer | ✅ | شناسه فروشگاه | `5` |
| `order_status` | string | ❌ | وضعیت سفارش | `delivered` |
| `payment_status` | string | ❌ | وضعیت پرداخت | `true` |
| `start_date` | string | ❌ | تاریخ شروع (فرمت: Y/m/d) | `1403/01/01` |
| `end_date` | string | ❌ | تاریخ پایان (فرمت: Y/m/d) | `1403/12/29` |
| `min_amount` | numeric | ❌ | حداقل مبلغ سفارش | `50000` |
| `max_amount` | numeric | ❌ | حداکثر مبلغ سفارش | `500000` |

### مثال درخواست

```bash
curl -X GET "https://api.limofood.com/api/user-orders/branch-stats?user_id=123&branch_id=5&start_date=1403/01/01&end_date=1403/01/31" \
  -H "Accept: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### پاسخ موفق

```json
{
  "status": "success",
  "message": "آمار خرید کاربر از فروشگاه با موفقیت دریافت شد",
  "data": {
    "user": {
      "id": 123,
      "name": "احمد",
      "family": "احمدی",
      "mobile": "09123456789",
      "email": "ahmad@example.com"
    },
    "branch": {
      "id": 5,
      "title": "رستوران نمونه",
      "address": "تهران، خیابان ولیعصر، پلاک 456",
      "logo": "uploads/branches/logo5.jpg",
      "min_order": "50000",
      "rate": "4.5"
    },
    "statistics": {
      "total_orders": 45,
      "delivered_orders": 40,
      "cancelled_orders": 5,
      "total_spent": "2250000",
      "average_order_value": "50000",
      "last_order_date": "2024-01-15 14:30:00",
      "delivery_rate": 88.89,
      "cancellation_rate": 11.11,
      "favorite_products": [
        {
          "id": 1,
          "title": "کباب کوبیده",
          "image": "uploads/products/kebab.jpg",
          "total_quantity": 15,
          "order_count": 8
        },
        {
          "id": 2,
          "title": "جوجه کباب",
          "image": "uploads/products/chicken.jpg",
          "total_quantity": 12,
          "order_count": 6
        }
      ]
    }
  }
}
```

---

## دریافت محصولات محبوب کاربر از فروشگاه

این API برای دریافت محصولات محبوب یک کاربر از یک فروشگاه خاص استفاده می‌شود.

### درخواست

```http
GET /api/user-orders/favorite-products
```

### پارامترهای Query

| پارامتر | نوع | اجباری | توضیحات | مثال |
|---------|-----|--------|---------|------|
| `user_id` | integer | ✅ | شناسه کاربر | `123` |
| `branch_id` | integer | ✅ | شناسه فروشگاه | `5` |
| `limit` | integer | ❌ | تعداد محصولات (پیش‌فرض: 10) | `5` |

### مثال درخواست

```bash
curl -X GET "https://api.limofood.com/api/user-orders/favorite-products?user_id=123&branch_id=5&limit=5" \
  -H "Accept: application/json" \
  -H "Authorization: Bearer YOUR_TOKEN"
```

### پاسخ موفق

```json
{
  "status": "success",
  "message": "محصولات محبوب کاربر از فروشگاه با موفقیت دریافت شد",
  "data": {
    "user": {
      "id": 123,
      "name": "احمد",
      "family": "احمدی",
      "mobile": "09123456789",
      "email": "ahmad@example.com"
    },
    "branch": {
      "id": 5,
      "title": "رستوران نمونه",
      "address": "تهران، خیابان ولیعصر، پلاک 456",
      "logo": "uploads/branches/logo5.jpg",
      "min_order": "50000",
      "vendor_id": 2
    },
    "favorite_products": [
      {
        "id": 1,
        "title": "کباب کوبیده",
        "image": "uploads/products/kebab.jpg",
        "total_quantity": 15,
        "order_count": 8
      },
      {
        "id": 2,
        "title": "جوجه کباب",
        "image": "uploads/products/chicken.jpg",
        "total_quantity": 12,
        "order_count": 6
      },
      {
        "id": 3,
        "title": "قیمه",
        "image": "uploads/products/ghimeh.jpg",
        "total_quantity": 10,
        "order_count": 5
      }
    ]
  }
}
```

---

## کدهای وضعیت HTTP

| کد | توضیحات |
|----|---------|
| 200 | درخواست موفق |
| 422 | خطا در اعتبارسنجی داده‌ها |
| 500 | خطای سرور |

## پاسخ خطا

### خطای اعتبارسنجی (422)

```json
{
  "status": "error",
  "message": "خطا در اعتبارسنجی داده‌ها",
  "errors": {
    "user_id": [
      "فیلد شناسه کاربر اجباری است."
    ],
    "branch_id": [
      "فیلد شناسه فروشگاه اجباری است."
    ]
  }
}
```

### خطای سرور (500)

```json
{
  "status": "error",
  "message": "کاربر یافت نشد یا غیرفعال است",
  "error": "جزئیات خطا (فقط در حالت debug)"
}
```

## نکات مهم

1. **تاریخ‌ها**: تاریخ‌ها هم به میلادی (`created_at`, `updated_at`) و هم به شمسی (`created_at_jalali`, `updated_at_jalali`) ارائه می‌شوند.

2. **صفحه‌بندی**: API از Laravel pagination استفاده می‌کند و حداکثر 100 آیتم در هر صفحه قابل دریافت است.

3. **فیلترها**: تمام فیلترها اختیاری هستند به جز `user_id` و `branch_id`.

4. **رابطه‌ها**: API شامل اطلاعات کامل کاربر، فروشگاه، آدرس، پیک، نوع تحویل و سبد خرید است.

5. **وضعیت سفارش**: فقط سفارشاتی که وضعیت آن‌ها `wating_payment` یا `ordering` نیست، نمایش داده می‌شوند.

6. **اعتبارسنجی**: سیستم ابتدا بررسی می‌کند که کاربر و فروشگاه وجود دارند و فعال هستند.

7. **محصولات محبوب**: بر اساس تعداد سفارش و مقدار خرید محاسبه می‌شوند.

## مثال‌های استفاده

### دریافت تاریخچه خرید کاربر
```javascript
fetch('/api/user-orders/branch-orders?user_id=123&branch_id=5')
  .then(response => response.json())
  .then(data => console.log(data));
```

### دریافت آمار خرید کاربر
```javascript
fetch('/api/user-orders/branch-stats?user_id=123&branch_id=5')
  .then(response => response.json())
  .then(data => console.log(data));
```

### دریافت محصولات محبوب کاربر
```javascript
fetch('/api/user-orders/favorite-products?user_id=123&branch_id=5&limit=5')
  .then(response => response.json())
  .then(data => console.log(data));
```

### دریافت خریدهای تحویل شده در بازه زمانی
```javascript
fetch('/api/user-orders/branch-orders?user_id=123&branch_id=5&order_status=delivered&start_date=1403/01/01&end_date=1403/01/31')
  .then(response => response.json())
  .then(data => console.log(data));
```

## معماری و Design Patterns

این API بر اساس اصول زیر پیاده‌سازی شده است:

- **Repository Pattern**: جداسازی منطق دسترسی به داده‌ها
- **Service Layer Pattern**: جداسازی منطق کسب‌وکار
- **Resource Pattern**: استانداردسازی پاسخ‌های API
- **Request Validation**: اعتبارسنجی ورودی‌ها
- **Dependency Injection**: تزریق وابستگی‌ها
- **Single Responsibility Principle**: هر کلاس یک مسئولیت دارد
