<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    "accepted" => ":attribute باید پذیرفته شده باشد.",
    'accepted_if' => 'هنگامی که :other، :value است باید با :attribute توافق کنید.',
    "active_url" => "آدرس :attribute معتبر نیست",
    "after" => ":attribute باید تاریخی بعد از :date باشد.",
    'after_or_equal' => ':attribute باید بعد از یا برابر تاریخ :date باشد.',
    "alpha" => ":attribute باید شامل حروف الفبا باشد.",
    "alpha_dash" => ":attribute باید شامل حروف الفبا و عدد و خط تیره(-) باشد.",
    "alpha_num" => ":attribute باید شامل حروف الفبا و عدد باشد.",
    'ascii' => ':attribute باید فقط شامل کاراکترهای تک بایتی الفبایی و نمادها باشد.',
    "array" => ":attribute باید شامل آرایه باشد.",
    "before" => ":attribute باید تاریخی قبل از :date باشد.",
    'before_or_equal' => ':attribute باید قبل از یا برابر تاریخ :date باشد.',
    "between" => [
        "numeric" => ":attribute باید بین :min و :max باشد.",
        "file" => ":attribute باید بین :min و :max کیلوبایت باشد.",
        "string" => ":attribute باید بین :min و :max کاراکتر باشد.",
        "array" => ":attribute باید بین :min و :max آیتم باشد.",
    ],
    "boolean" => "فیلد :attribute فقط میتواند صحیح و یا غلط باشد",
    'can' => 'فیلد :attribute شامل مقدار غیرمجاز است.',
    "confirmed" => ":attribute با تاییدیه مطابقت ندارد.",
    'current_password' => 'رمز عبور اشتباه است.',
    "date" => ":attribute یک تاریخ معتبر نیست.",
    'date_equals' => ':attribute باید برابر تاریخ :date باشد.',
    "date_format" => ":attribute با الگوی :format مطابقت ندارد.",
    'decimal' => ':attribute باید :decimal رقم اعشار داشته باشد.',
    'declined' => ':attribute باید پذیرفته نشود.',
    'declined_if' => 'هنگامی که :other، :value است باید با :attribute نپذیرید.',
    "different" => ":attribute و :other باید متفاوت باشند.",
    "digits" => ":attribute باید :digits رقم باشد.",
    "digits_between" => ":attribute باید بین :min و :max رقم باشد.",
    'dimensions' => 'ابعاد تصویر مربوط به فیلد :attribute اشتباه است.',
    'distinct' => ':attribute مقدار تکراری دارد.',
    'doesnt_end_with' => ':attribute نباید با یکی از این مقادیر تمام شود: :values.',
    'doesnt_start_with' => ':attribute نباید با یکی از این مقادیر شروع شود: :values.',
    "email" => "فرمت :attribute معتبر نیست.",
    'ends_with' => ':attribute باید با یکی از این مقادیر تمام شود: :values.',
    'enum' => ':attribute انتخاب شده معتبر نیست.',
    "exists" => ":attribute انتخاب شده، معتبر نیست.",
    'file' => 'فیلد :attribute باید فایل باشد.',
    "filled" => "فیلد :attribute الزامی است",
    'gt' => [
        'numeric' => ':attribute باید بیشتر از :value باشد.',
        'file' => ':attribute باید بیشتر از :value کیلوبایت باشد.',
        'string' => ':attribute باید بیشتر از :value کاراکتر باشد.',
        'array' => ':attribute باید بیشتر از :value آیتم باشد.',
    ],
    'gte' => [
        'numeric' => ':attribute باید بیشتر یا برابر :value باشد.',
        'file' => ':attribute باید بیشتر یا برابر :value کیلوبایت باشد.',
        'string' => ':attribute باید بیشتر یا برابر :value کاراکتر باشد.',
        'array' => ':attribute باید :value آیتم یا بیشتر را داشته باشد.',
    ],
    "image" => ":attribute باید تصویر باشد.",
    "in" => ":attribute انتخاب شده، معتبر نیست.",
    'in_array' => 'فیلد :attribute در :other موجود نیست.',
    "integer" => ":attribute باید نوع داده ای عددی (integer) باشد.",
    "ip" => ":attribute باید IP آدرس معتبر باشد.",
    'ipv4' => ':attribute باید یک آدرس درست IPv4 باشد.',
    'ipv6' => ':attribute باید یک آدرس درست IPv6 باشد.',
    'json' => ':attribute باید یک مقدار درست JSON باشد.',
    'lowercase' => ':attribute باید با حروف کوچک باشد.',
    'lt' => [
        'numeric' => ':attribute باید کمتر از :value باشد.',
        'file' => ':attribute باید کمتر از :value کیلوبایت باشد.',
        'string' => ':attribute باید کمتر از :value کاراکتر باشد.',
        'array' => ':attribute باید :value آیتم یا کمتر را داشته باشد.',
    ],
    'lte' => [
        'numeric' => ':attribute باید کمتر یا برابر :value باشد.',
        'file' => ':attribute باید کمتر یا برابر :value کیلوبایت باشد.',
        'string' => ':attribute باید کمتر یا برابر :value کاراکتر باشد.',
        'array' => ':attribute باید :value آیتم یا کمتر را داشته باشد.',
    ],
    'mac_address' => ':attribute باید یک آدرس MAC معتبر باشد.',
    "max" => [
        "numeric" => ":attribute نباید بزرگتر از :max باشد.",
        "file" => ":attribute نباید بزرگتر از :max کیلوبایت باشد.",
        "string" => ":attribute نباید بیشتر از :max کاراکتر باشد.",
        "array" => ":attribute نباید بیشتر از :max آیتم باشد.",
    ],
    'max_digits' => ':attribute نباید بیشتر از :max رقم داشته باشد.',
    "mimes" => ":attribute باید یکی از فرمت های :values باشد.",
    'mimetypes' => ':attribute باید تایپ آن از نوع: :values باشد.',
    "min" => [
        "numeric" => ":attribute نباید کوچکتر از :min باشد.",
        "file" => ":attribute نباید کوچکتر از :min کیلوبایت باشد.",
        "string" => ":attribute نباید کمتر از :min کاراکتر باشد.",
        "array" => ":attribute نباید کمتر از :min آیتم باشد.",
    ],
    'min_digits' => ':attribute باید حداقل :min رقم داشته باشد.',
    'missing' => ':attribute باید وجود نداشته باشد.',
    'missing_if' => ':attribute باید وجود نداشته باشد وقتی :other برابر :value است.',
    'missing_unless' => ':attribute باید وجود نداشته باشد مگر اینکه :other برابر :value باشد.',
    'missing_with' => ':attribute باید وجود نداشته باشد وقتی :values موجود است.',
    'missing_with_all' => ':attribute باید وجود نداشته باشد وقتی :values موجود هستند.',
    'multiple_of' => ':attribute باید ضریبی از :value باشد.',
    "not_in" => ":attribute انتخاب شده، معتبر نیست.",
    'not_regex' => ':attribute فرمت معتبر نیست.',
    "numeric" => ":attribute باید شامل عدد باشد.",
    'password' => [
        'letters' => ':attribute باید حداقل شامل یک حرف باشد.',
        'mixed' => ':attribute باید حداقل شامل یک حرف بزرگ و یک حرف کوچک باشد.',
        'numbers' => ':attribute باید حداقل شامل یک عدد باشد.',
        'symbols' => ':attribute باید حداقل شامل یک نماد باشد.',
        'uncompromised' => ':attribute داده شده در نشت اطلاعات ظاهر شده است. لطفاً :attribute دیگری انتخاب کنید.',
    ],
    'present' => ':attribute باید وجود داشته باشد.',
    'prohibited' => 'فیلد :attribute ممنوع است.',
    'prohibited_if' => 'هنگامی که :other، :value است فیلد :attribute ممنوع است.',
    'prohibited_unless' => ':attribute ممنوع است مگر اینکه :other برابر با (:values) باشد.',
    'prohibits' => 'هنگام ورود فیلد :attribute، وارد کردن فیلد :other ممنوع است.',
    "regex" => ":attribute یک فرمت معتبر نیست",
    "required" => "فیلد :attribute الزامی است",
    'required_array_keys' => 'فیلد :attribute باید شامل ورودی‌هایی برای: :values باشد.',
    "required_if" => "فیلد :attribute هنگامی که :other برابر با :value است، الزامیست.",
    'required_if_accepted' => 'فیلد :attribute الزامیست وقتی :other پذیرفته شده است.',
    'required_unless' => 'فیلد :attribute الزامیست مگر اینکه فیلد :other مقدارش :values باشد.',
    "required_with" => ":attribute الزامی است زمانی که :values موجود است.",
    "required_with_all" => ":attribute الزامی است زمانی که :values موجود است.",
    "required_without" => ":attribute الزامی است زمانی که :values موجود نیست.",
    "required_without_all" => ":attribute الزامی است زمانی که :values موجود نیست.",
    "same" => ":attribute و :other باید مانند هم باشند.",
    "size" => [
        "numeric" => ":attribute باید برابر با :size باشد.",
        "file" => ":attribute باید برابر با :size کیلوبایت باشد.",
        "string" => ":attribute باید برابر با :size کاراکتر باشد.",
        "array" => ":attribute باید شامل :size آیتم باشد.",
    ],
    'starts_with' => ':attribute باید با یکی از این مقادیر شروع شود: :values.',
    "string" => ":attribute باید رشته باشد.",
    "timezone" => "فیلد :attribute باید یک منطقه صحیح باشد.",
    "unique" => ":attribute قبلا انتخاب شده است.",
    'uploaded' => 'فیلد :attribute به درستی آپلود نشد.',
    'uppercase' => ':attribute باید با حروف بزرگ باشد.',
    "url" => "فرمت آدرس :attribute اشتباه است.",
    'ulid' => ':attribute باید یک فرمت درست ULID باشد.',
    'uuid' => ':attribute باید یک فرمت درست UUID باشد.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap attribute place-holders
    | with something more reader friendly such as E-Mail Address instead
    | of "email". This simply helps us make messages a little cleaner.
    |
    */
    'attributes' => [
        "name" => "نام",
        "username" => "نام کاربری",
        "email" => "پست الکترونیکی",
        "first_name" => "نام",
        "last_name" => "نام خانوادگی",
        "family" => "نام خانوادگی",
        "password" => "رمز عبور",
        "password_confirmation" => "تاییدیه ی رمز عبور",
        "city" => "شهر",
        "country" => "کشور",
        "address" => "نشانی",
        "phone" => "تلفن",
        "mobile" => "تلفن همراه",
        "age" => "سن",
        "sex" => "جنسیت",
        "gender" => "جنسیت",
        "day" => "روز",
        "month" => "ماه",
        "year" => "سال",
        "hour" => "ساعت",
        "minute" => "دقیقه",
        "second" => "ثانیه",
        "title" => "عنوان",
        "text" => "متن",
        "content" => "محتوا",
        "description" => "توضیحات",
        "excerpt" => "گلچین کردن",
        "date" => "تاریخ",
        "time" => "زمان",
        "available" => "موجود",
        "size" => "اندازه",
        "file" => "فایل",
        "fullname" => "نام کامل",
        "code" => "کد",
        "minDescription" => "توضیحات کوتاه",
        "branch name" => "نام آشپزخانه",
        "branch meta sm" => "توضیحات متا",
        "branch address" => "آدرس آشپزخانه",
        "branch lat" => "طول جغرافیایی",
        "branch lang" => "عرض جغرافیایی",
        "max distance" => "حداکثر فاصله",
        "shipping cost " => "هزینه ارسال",
        "tax percent " => "درصد تخفیف",
        "zarinpal" => "زرین پال",
        "image" => "تصویر",
        "areaSlug" => "اسلاگ (پیوند صفحه)",
        "areaLat" => "طول جغرافیایی",
        "areaLang" => "عرض جغرافیایی",
        "unit_id" => "واحد",
        "pricePerUnit" => "قیمت هر واحد",
        "caloriePerUnit" => "کالری هر واحد",
        "carbohydratePerUnit" => "کربوهیدرات هر واحد",
        "fatPerUnit" => "چربی هر واحد",
        "proteinPerUnit" => "پروتئین هر واحد",
        "categoryId" => "آیدی دسته بندی",
        "discount" => "درصد تخفیف",
        "useMaterial" => "مواد اولیه",
        "price" => "قیمت",
        "pricePaking" => "قیمت بسته بندی",
        "image_1" => "تصویر",
        "image_2" => "تصویر",
        "image_3" => "تصویر",
        "image_4" => "تصویر",
        "accountHolderName" => "صاحب حساب",
        "bankName" => "نام بانک",
        "accountNumber" => "شماره حساب",
        "cardNumber" => "شماره کارت",
        "shabaNumber" => "شماره شبا",
        "discountPercent" => "درصد تخفیف",
        "minOrderPrice" => "حداقل سفارش",
        "maxDiscountPrice" => "حداکثر قیمت تخفیف",
        "discountCode" => "کد تخفیف",
        "percentSystem" => "درصد سیستم",
        "usedCount" => "تعداد استفاده",
        "percentBranch" => "درصد آشپزخانه",
        "subject" => "موضوع تیکت",
        "branchName" => "نام آشپزخانه",
        "branchMinOrder" => "حداقل سفارش",
        "branchMetaSm" => "توضیحات کوتاه",
        "branchAddress" => "آدرس آشپزخانه",
        "areaId" => "منطقه",
        "activitiesSelect" => "حوزه‌های فعالیت",
        "category_id" => "دسته بندی",
        "shippingCostCalculation" => "محاسبه هزینه ارسال",
        "descriptionRequired" => "اجباری بودن توضیحات",
        "isActive" => "وضعیت",
        "descriptionText" => "متن توضیحات",
        "descriptionErrorText" => "متن خطا",
        "cover" => 'کاور',
        "menu_id" => 'منو',
        "tel" => 'تلفن',
        "user_name" => 'نام کاربری',
        "author" => 'نویسنده',
        "area_id" => 'منطقه',
        "post_category_id" => 'دسته بندی',
        "slug" => "اسلاگ",
        "parent_id" => "دسته بندی والد",
        "lat" => "طول جغرافیایی",
        "lng" => "عرض جغرافیایی",
        "branch_id" => "آشپزخانه",
        "schedules" => "برنامه‌ها",
        "service_time_from" => "زمان شروع سرویس",
        "service_time_to" => "زمان پایان سرویس",
        "min_order" => "حداقل سفارش",
        "delivery_time" => "زمان تحویل",
        "order_limit_per_half_hour" => "محدودیت سفارش در نیم ساعت",
        "free_delivery" => "ارسال رایگان",
        "free_delivery_min_amount" => "حداقل مبلغ برای ارسال رایگان",
        "status" => "وضعیت",
        "out_of_range_price" => "قیمت خارج از محدوده",
        "order_amounts" => "مقادیر سفارش",
        "orderAmountDelivery" => "مبلغ تحویل سفارش",
        "shipping_methods" => "روش‌های ارسال",
        // ترجمه فیلدهای آرایه‌ای تو در تو
        "schedules.*.day" => "روز",
        "schedules.*.service_time_from" => "زمان شروع سرویس",
        "schedules.*.service_time_to" => "زمان پایان سرویس",
        "schedules.*.min_order" => "حداقل سفارش",
        "schedules.*.delivery_time" => "زمان تحویل",
        "schedules.*.order_limit_per_half_hour" => "محدودیت سفارش در نیم ساعت",
        "schedules.*.free_delivery" => "ارسال رایگان",
        "schedules.*.free_delivery_min_amount" => "حداقل مبلغ برای ارسال رایگان",
        "schedules.*.status" => "وضعیت",
        "schedules.*.out_of_range_price" => "قیمت خارج از محدوده",
        "schedules.*.order_amounts" => "مقادیر سفارش",
        "schedules.*.order_amounts.*.orderAmountDelivery" => "مبلغ تحویل سفارش",
        "schedules.*.shipping_methods" => "روش‌های ارسال",
        "schedules.*.shipping_methods.*" => "روش ارسال",
    ],
];
