/*
 Navicat Premium Data Transfer

 Source Server         : localhost_3306
 Source Server Type    : MySQL
 Source Server Version : 80031 (8.0.31)
 Source Host           : localhost:3306
 Source Schema         : limofood

 Target Server Type    : MySQL
 Target Server Version : 80031 (8.0.31)
 File Encoding         : 65001

 Date: 01/07/2025 18:17:17
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for active_times
-- ----------------------------
DROP TABLE IF EXISTS `active_times`;
CREATE TABLE `active_times`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `to_time` time NOT NULL,
  `week_day` enum('monday','tuesday','wednesday','thursday','friday','saturday','sunday') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `branch_id` int NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime NULL DEFAULT NULL,
  `from_time` time NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 38 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of active_times
-- ----------------------------
INSERT INTO `active_times` VALUES (1, '23:00:00', 'friday', 1, '2023-12-22 13:19:37', '2024-01-09 19:08:44', '2024-01-09 19:08:44', '11:00:00');
INSERT INTO `active_times` VALUES (3, '23:00:00', 'monday', 1, '2023-12-22 13:19:34', '2024-01-09 19:09:20', '2024-01-09 19:09:20', '11:00:00');
INSERT INTO `active_times` VALUES (4, '23:00:00', 'tuesday', 1, '2023-12-22 13:19:31', '2023-12-22 13:19:31', NULL, '11:00:00');
INSERT INTO `active_times` VALUES (5, '23:00:00', 'wednesday', 1, '2023-12-22 13:19:29', '2023-12-22 13:19:29', NULL, '11:00:00');
INSERT INTO `active_times` VALUES (9, '23:00:00', 'thursday', 1, '2023-12-22 13:19:26', '2023-12-22 13:19:26', NULL, '11:00:00');
INSERT INTO `active_times` VALUES (7, '23:00:00', 'saturday', 1, '2023-12-22 13:19:25', '2023-12-22 13:19:25', NULL, '11:00:00');
INSERT INTO `active_times` VALUES (8, '23:00:00', 'sunday', 1, '2023-12-22 13:19:42', '2023-12-22 13:19:42', NULL, '11:00:00');
INSERT INTO `active_times` VALUES (10, '17:29:00', 'tuesday', 1, '2024-01-09 19:02:39', '2024-01-09 19:02:39', NULL, '17:29:00');
INSERT INTO `active_times` VALUES (11, '17:29:00', 'tuesday', 1, '2024-01-09 19:03:54', '2024-01-09 19:03:54', NULL, '17:29:00');
INSERT INTO `active_times` VALUES (12, '23:58:00', 'saturday', 1, '2024-01-09 19:04:46', '2024-01-09 19:04:46', NULL, '13:05:00');
INSERT INTO `active_times` VALUES (13, '20:43:00', 'friday', 1, '2024-01-09 19:13:20', '2024-01-09 19:13:20', NULL, '18:43:00');
INSERT INTO `active_times` VALUES (14, '22:45:00', 'saturday', 2, '2024-01-09 19:15:16', '2024-01-09 19:15:16', NULL, '13:45:00');
INSERT INTO `active_times` VALUES (15, '12:56:00', 'sunday', 2, '2024-01-20 16:11:38', '2024-01-20 16:37:46', '2024-01-20 16:37:46', '18:30:00');
INSERT INTO `active_times` VALUES (16, '20:00:00', 'sunday', 2, '2024-01-20 18:05:23', '2024-01-20 18:05:23', NULL, '11:45:00');
INSERT INTO `active_times` VALUES (17, '23:50:00', 'sunday', 2, '2024-01-20 18:05:55', '2024-01-20 18:05:55', NULL, '21:00:00');
INSERT INTO `active_times` VALUES (18, '00:55:00', 'saturday', 2, '2024-01-26 04:16:58', '2024-01-26 04:16:58', NULL, '00:10:00');
INSERT INTO `active_times` VALUES (19, '00:15:00', 'saturday', 2, '2024-02-10 07:45:56', '2024-02-10 07:46:07', '2024-02-10 07:46:07', '11:15:00');
INSERT INTO `active_times` VALUES (20, '23:58:00', 'saturday', 3, '2024-03-05 21:08:16', '2024-03-05 21:08:16', NULL, '12:30:00');
INSERT INTO `active_times` VALUES (21, '23:59:00', 'sunday', 3, '2024-03-05 21:08:38', '2024-03-05 21:08:38', NULL, '12:29:00');
INSERT INTO `active_times` VALUES (22, '23:59:00', 'monday', 3, '2024-03-05 21:08:59', '2024-03-05 21:08:59', NULL, '12:29:00');
INSERT INTO `active_times` VALUES (23, '23:59:00', 'tuesday', 3, '2024-03-05 21:09:12', '2024-03-05 21:09:12', NULL, '12:30:00');
INSERT INTO `active_times` VALUES (24, '23:59:00', 'wednesday', 3, '2024-03-05 21:09:35', '2024-03-05 21:09:35', NULL, '12:29:00');
INSERT INTO `active_times` VALUES (25, '23:59:00', 'thursday', 3, '2024-03-05 21:09:48', '2024-03-05 21:09:48', NULL, '12:30:00');
INSERT INTO `active_times` VALUES (26, '23:59:00', 'friday', 3, '2024-03-05 21:10:05', '2024-03-05 21:10:05', NULL, '12:29:00');
INSERT INTO `active_times` VALUES (27, '23:29:00', 'monday', 4, '2024-03-11 14:44:37', '2024-03-21 09:07:53', '2024-03-21 09:07:53', '12:59:00');
INSERT INTO `active_times` VALUES (28, '23:37:00', 'saturday', 4, '2024-03-21 09:07:43', '2024-03-21 09:07:43', NULL, '13:37:00');
INSERT INTO `active_times` VALUES (29, '18:49:00', 'monday', 8, '2024-07-25 11:44:26', '2024-07-25 11:44:26', NULL, '00:49:00');
INSERT INTO `active_times` VALUES (30, '10:59:00', 'saturday', 11, '2024-07-27 12:19:59', '2024-09-21 11:42:40', NULL, '10:59:00');
INSERT INTO `active_times` VALUES (31, '23:59:00', 'sunday', 11, '2024-07-27 12:20:37', '2024-07-27 12:20:37', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (32, '23:59:00', 'monday', 11, '2024-07-27 12:21:11', '2024-07-27 12:21:11', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (33, '23:59:00', 'tuesday', 11, '2024-07-27 12:21:37', '2024-07-27 12:21:37', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (34, '23:59:00', 'wednesday', 11, '2024-07-27 12:22:00', '2024-07-27 12:22:00', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (35, '23:59:00', 'thursday', 11, '2024-07-27 12:22:30', '2024-07-27 12:22:30', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (36, '23:59:00', 'friday', 11, '2024-07-27 12:22:54', '2024-07-27 12:22:54', NULL, '11:59:00');
INSERT INTO `active_times` VALUES (37, '22:00:00', 'sunday', 1, '2024-08-14 11:07:16', '2024-08-14 11:07:25', '2024-08-14 11:07:25', '14:18:00');

-- ----------------------------
-- Table structure for activities
-- ----------------------------
DROP TABLE IF EXISTS `activities`;
CREATE TABLE `activities`  (
  `id` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of activities
-- ----------------------------
INSERT INTO `activities` VALUES (0, 'فروش تعدادی و پرسی', '2024-02-01 18:34:21', NULL, NULL);
INSERT INTO `activities` VALUES (2, 'دورهمی ها و میهمانی ها', '2024-02-01 18:34:07', NULL, NULL);
INSERT INTO `activities` VALUES (3, 'سفارشات شرکتی', '2024-02-01 18:34:13', NULL, NULL);

-- ----------------------------
-- Table structure for addresses
-- ----------------------------
DROP TABLE IF EXISTS `addresses`;
CREATE TABLE `addresses`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `lat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `lng` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `detail` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT '0',
  `phone_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `plaque` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `unit` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `postal_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `area_id` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `user`(`user_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 64 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of addresses
-- ----------------------------
INSERT INTO `addresses` VALUES (1, 1, 'ادرس جدید 1', '31.255215', '51.255611', 'آدرس تست آدرس تست آدرس تست آدرس تست آدرس تست', '0', NULL, '', NULL, NULL, '2023-11-26 17:23:06', '2023-11-26 17:32:26', NULL, NULL);
INSERT INTO `addresses` VALUES (7, 6, 's', '52.3875443331215', '4.623321541585028', 'No. 1, Kerffpad', '0', NULL, '', NULL, NULL, '2023-12-16 20:53:06', '2023-12-16 20:53:06', NULL, NULL);
INSERT INTO `addresses` VALUES (22, 4, 'sss', '31.864118383691125', '54.37406301498413', 'یزد، بلوار امام جعفر صادق، غلامرضاعظیمی، شهید محمدعلی یاوری، یاوری 13', '0', NULL, '11', '11', '8915984769', '2024-02-09 15:58:18', '2024-02-09 15:58:18', NULL, 1);
INSERT INTO `addresses` VALUES (21, 4, 'a', '31.862678672209782', '54.39001679420472', 'یزد، خاتم، شجاعی، طلوع', '0', NULL, '11', '11', '8915984769', '2024-02-09 15:56:09', '2024-02-09 15:56:09', NULL, NULL);
INSERT INTO `addresses` VALUES (13, 6, 'فصشف', '31.862911032257827', '54.38939666741498', 'یزد، خاتم، جام جم، 15 خرداد، مسجد قائم', '11', '1111111111', '', NULL, NULL, '2023-12-23 18:39:21', '2023-12-23 18:39:21', NULL, NULL);
INSERT INTO `addresses` VALUES (20, 54, 'ساختمان آرمان', '36.37876953108212', '59.48135375976563', 'مشهد، بلوار سجادیه، سجادیه 32، بین منجم 2 و 4', '0', NULL, '24', '14', '1918617007', '2024-02-07 12:59:31', '2024-02-07 12:59:31', NULL, NULL);
INSERT INTO `addresses` VALUES (19, 46, 'تستتس', '31.899158397002235', '54.398117065429695', 'استان یزد، شهرستان یزد، بلوار علامه جعفری، سرچشمه، بلوار انتظار', '11', '8945151160', '', NULL, NULL, '2024-01-15 17:15:36', '2024-01-15 17:15:36', NULL, NULL);
INSERT INTO `addresses` VALUES (23, 4, 'ییی', '31.888344078314002', '54.38841819763184', 'یزد، بلوار دهه فجر، خرمشهر 10، شهیدمحموددهقان', '0', NULL, '11', '11', '8915984769', '2024-02-09 20:48:53', '2024-02-09 20:48:53', NULL, NULL);
INSERT INTO `addresses` VALUES (24, 4, 'ییی', '36.28911666456517', '59.61503505706788', 'مشهد، ایت الله خزعلی 4 - بازارچه سراب، ایت الله خزعلی، آیت الله واعظ طبسی', '0', NULL, '11', '11', '8915984769', '2024-02-10 12:32:51', '2024-02-10 12:32:51', NULL, NULL);
INSERT INTO `addresses` VALUES (25, 3, '11', '36.286003366110215', '59.62005615234376', 'مشهد، شهید نواب صفوی، نواب صفوی 4', '0', NULL, '11', '11', '8915984769', '2024-03-08 12:23:23', '2024-03-08 12:23:23', NULL, NULL);
INSERT INTO `addresses` VALUES (26, 3, 'aaa', '31.876555461101418', '54.37758207321168', 'یزد، آیت الله کاشانی، مصدق، بین چمران 5 و ششم', '0', NULL, '11', '11', '8915984769', '2024-03-08 12:24:18', '2024-03-08 12:24:18', NULL, NULL);
INSERT INTO `addresses` VALUES (27, 3, 'gg', '35.8147507632925', '51.39970779418946', 'استان تهران، شهرستان شمیرانات، بخش رودبار قصران، برادران ابوطالبی', '0', NULL, '44', '44', '8915984769', '2024-03-08 12:25:46', '2024-03-08 12:25:46', NULL, NULL);
INSERT INTO `addresses` VALUES (28, 4, '11', '35.82157139161192', '51.448116302490234', 'استان تهران، شهرستان شمیرانات، بخش رودبار قصران، صادقی قمی، کوهستان', '0', NULL, '11', '11', '8915984769', '2024-03-09 09:26:37', '2024-03-09 09:26:37', NULL, NULL);
INSERT INTO `addresses` VALUES (29, 10, 'خانه', '36.28897830261564', '59.60872650081001', 'مشهد، ایت الله خزعلی، شوکت الدوله، نوذر', '0', NULL, '0', '202', '8915441468', '2024-03-11 14:32:35', '2024-03-11 14:32:35', NULL, NULL);
INSERT INTO `addresses` VALUES (30, 10, 'خونه', '31.84697789466625', '54.34558906904387', 'یزد، بلوار فردوسی، نسترن', '0', NULL, '0', '202', '8915441468', '2024-03-11 14:42:19', '2024-03-11 14:42:19', NULL, NULL);
INSERT INTO `addresses` VALUES (31, 7, 'تست آدرس', '31.846503153196576', '54.35125350952149', 'یزد، بلوار فردوسی، نگارستان، گلشن غربی 4 کوچه سوم، مجتمع ققنوس', '0', NULL, '12', '125', '8915169815', '2024-03-14 14:16:24', '2024-03-14 14:16:24', NULL, NULL);
INSERT INTO `addresses` VALUES (32, 10, 'خانه', '31.87162638798932', '54.30042028427124', 'یزد، بلوار گلستان غربی، کمیل، سعدی، بین امیر نکویی 14 و ده متری فرخی', '0', NULL, '0', '0', '8915441496', '2024-04-11 10:42:16', '2024-04-11 10:42:16', NULL, NULL);
INSERT INTO `addresses` VALUES (33, 10, 'خانه', '35.689491737651004', '51.38082504272462', 'تهران، امام خمینی، اسکندری جنوبی، صفی خانی، بین روحی و تفرشی ها', '0', NULL, '0', '0', '8915441485', '2024-04-11 10:43:24', '2024-04-11 10:43:24', NULL, NULL);
INSERT INTO `addresses` VALUES (34, 1, 'ادرس جدید', '31.255215', '51.255611', 'آدرس تست آدرس تست آدرس تست آدرس تست آدرس تست', 'ckjskjcnsd', 'sldkcksdjmcds', NULL, NULL, NULL, '2024-07-10 08:00:22', '2024-07-10 08:00:22', NULL, 1);
INSERT INTO `addresses` VALUES (35, 1, 'ادرس جدید 12222', '31.255215', '51.255611', 'آدرس تست آدرس تست آدرس تست آدرس تست آدرس تست', 'ckjskjcnsd', 'sldkcksdjmcds', NULL, NULL, NULL, '2024-07-10 08:03:14', '2024-07-10 08:03:45', NULL, 2);
INSERT INTO `addresses` VALUES (41, 61, 'cc', '36.29229901904711', '59.58649635314942', 'مشهد، دانشگاه، کفایی، کفایی 2', '0', '09162517728', NULL, NULL, NULL, '2024-07-13 15:11:58', '2024-07-13 15:11:58', NULL, NULL);
INSERT INTO `addresses` VALUES (42, 61, 'test', '31.891124', '54.351850', 'ttt', '0', '09162517728', NULL, NULL, NULL, '2024-07-13 15:14:36', '2024-07-13 15:14:36', NULL, 22);
INSERT INTO `addresses` VALUES (63, 100, 'خانه', '31.891124', '54.351850', 'تهران تهران', '0', '09216922768', NULL, NULL, NULL, '2024-08-05 16:19:47', '2024-08-05 16:19:47', NULL, 22);
INSERT INTO `addresses` VALUES (61, 73, 'Test', '35.711271', '51.404302', 'Test', '0', '09162517728', NULL, NULL, NULL, '2024-07-27 14:30:44', '2024-07-27 14:30:44', NULL, 23);
INSERT INTO `addresses` VALUES (60, 71, 't', '31.891124', '54.351850', 'tttt', '0', '09162517728', NULL, NULL, NULL, '2024-07-27 13:14:34', '2024-07-27 13:59:05', NULL, 22);
INSERT INTO `addresses` VALUES (59, 2, 'تست تست تست تست', '35.711271', '51.404302', 'تست تست تست تست تست تست تست تست تست تست تست', '0', '09013234324', NULL, NULL, NULL, '2024-07-26 19:38:18', '2024-07-26 19:38:18', NULL, 23);
INSERT INTO `addresses` VALUES (57, 60, 'فث', '31.891124', '54.351850', 'یییی-یییی-یییی', '0', '09162517728', NULL, NULL, NULL, '2024-07-25 12:41:30', '2024-07-25 12:41:59', NULL, 21);
INSERT INTO `addresses` VALUES (56, 1, 'تست تست تست', '31.891124', '54.351850', 'تست تست تست تست تست تست', '0', '09013234324', NULL, NULL, NULL, '2024-07-14 06:21:03', '2024-07-14 06:21:03', NULL, 21);

-- ----------------------------
-- Table structure for agents
-- ----------------------------
DROP TABLE IF EXISTS `agents`;
CREATE TABLE `agents`  (
  `id` int UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `family` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `national_code` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `area_id` bigint UNSIGNED NOT NULL,
  `birthday` date NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `agents_code_unique`(`code`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 6 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of agents
-- ----------------------------
INSERT INTO `agents` VALUES (1, 'زیسزیس', 'زیسزیس', '09025045706', '4420893877', 'زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس زیسزیس', '5132513', 1, 5, '2002-10-05', ',mknkjnbkj', NULL, '2024-10-15 20:55:02', '2024-10-16 14:06:28');
INSERT INTO `agents` VALUES (2, 'امیر عباس', 'قلی خان', '09013234324', '4420893877', 'زیسزیزسیزیس', '1513513', 1, 4, NULL, NULL, NULL, '2024-10-16 11:50:06', '2024-10-16 11:50:06');
INSERT INTO `agents` VALUES (3, 'امیر عباس', 'قلی خان', '09013234352', '4420893877', 'زیسزیزسیزیس', '15135cd3', 1, 4, NULL, NULL, NULL, '2024-10-16 11:58:17', '2024-10-16 11:58:17');
INSERT INTO `agents` VALUES (4, 'امیر عباس', 'قلی خان', '09013234358', '4420893877', 'زیسزیزسیزیس', '15cds135cd3', 1, 4, NULL, NULL, NULL, '2024-10-16 11:58:54', '2024-10-16 11:58:54');
INSERT INTO `agents` VALUES (5, 'امیر عباس', 'قلی خان', '09013234359', '4420893877', 'زیسزیزسیزیس', 'cdscsdcds', 1, 4, NULL, NULL, NULL, '2024-10-16 11:59:08', '2024-10-16 11:59:08');

-- ----------------------------
-- Table structure for area_management
-- ----------------------------
DROP TABLE IF EXISTS `area_management`;
CREATE TABLE `area_management`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `area_id` bigint UNSIGNED NOT NULL,
  `branch_id` bigint UNSIGNED NOT NULL,
  `day` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `service_time_from` time NOT NULL,
  `service_time_to` time NOT NULL,
  `min_order` int NOT NULL,
  `delivery_time` int NOT NULL,
  `order_limit_per_half_hour` int NULL DEFAULT NULL,
  `free_delivery` tinyint(1) NOT NULL DEFAULT 0,
  `free_delivery_min_amount` int NULL DEFAULT NULL,
  `out_of_range_price` int NOT NULL DEFAULT 0,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `service_fee` int NOT NULL DEFAULT 0,
  `order_amounts` json NULL,
  `shipping_methods` json NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `area_management_area_id_foreign`(`area_id`) USING BTREE,
  INDEX `area_management_branch_id_foreign`(`branch_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 38 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of area_management
-- ----------------------------

-- ----------------------------
-- Table structure for areas
-- ----------------------------
DROP TABLE IF EXISTS `areas`;
CREATE TABLE `areas`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `parent_id` int NOT NULL,
  `lat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `lng` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `created_at` datetime NULL DEFAULT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  `coordinates` json NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `area_parent`(`parent_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 36 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of areas
-- ----------------------------
INSERT INTO `areas` VALUES (1, 'مشهد', 'mashhad', 0, '36.296454', '59.605470', '2025-06-09 23:39:05', '2024-02-09 15:56:59', NULL, NULL);
INSERT INTO `areas` VALUES (2, 'منطقه 1', 'area1', 1, '36.294444', '59.576389', '2025-06-09 23:39:07', '2024-02-09 16:16:10', NULL, NULL);
INSERT INTO `areas` VALUES (3, 'تهران', 'teh', 2, '32.324', '14.533', '2023-12-22 11:08:21', '2023-12-22 11:31:34', '2023-12-22 11:31:34', NULL);
INSERT INTO `areas` VALUES (4, 'منطقه 2', 'area2', 1, '36.346111', '59.645278', '2024-02-09 16:16:50', '2024-02-09 16:16:50', NULL, NULL);
INSERT INTO `areas` VALUES (5, 'منطقه 3', 'area3', 1, '36.314722', '59.536389', '2024-02-09 16:17:44', '2024-02-09 16:17:44', NULL, NULL);
INSERT INTO `areas` VALUES (6, 'منطقه 4', 'area4', 1, '36.253889', '59.473056', '2024-02-09 16:17:54', '2024-02-09 16:17:54', NULL, NULL);
INSERT INTO `areas` VALUES (7, 'منطقه 5', 'area5', 1, '36.289722', '59.506944', '2024-02-09 16:18:01', '2024-02-09 16:18:01', NULL, NULL);
INSERT INTO `areas` VALUES (8, 'منطقه6', 'area6', 1, '36.241389', '59.598611', '2024-02-09 16:21:00', '2024-02-09 16:21:00', NULL, NULL);
INSERT INTO `areas` VALUES (9, 'منطقه7', 'area7', 1, '36.338056', '59.592222', '2024-02-09 16:21:19', '2024-02-09 16:21:19', NULL, NULL);
INSERT INTO `areas` VALUES (10, 'منطقه8', 'area8', 1, '36.354444', '59.621667', '2024-02-09 16:21:30', '2024-02-09 16:21:30', NULL, NULL);
INSERT INTO `areas` VALUES (11, 'منطقه9', 'area9', 1, '36.227222', '59.558333', '2024-02-09 16:21:39', '2024-02-09 16:21:39', NULL, NULL);
INSERT INTO `areas` VALUES (12, 'منطقه10', 'area10', 1, '36.301111', '59.663611', '2024-02-09 16:21:55', '2024-02-09 16:21:55', NULL, NULL);
INSERT INTO `areas` VALUES (13, 'منطقه 11', 'area11', 1, '36.2075', '59.608333', '2024-02-09 16:24:28', '2024-02-09 16:24:28', NULL, NULL);
INSERT INTO `areas` VALUES (14, 'منطقه 12', 'area12', 1, '36.183333', '59.531944', '2024-02-09 16:24:36', '2024-02-09 16:24:36', NULL, NULL);
INSERT INTO `areas` VALUES (15, 'منطقه 13', 'area13', 1, '36.3225', '59.518889', '2024-02-09 16:24:48', '2024-02-09 16:24:48', NULL, NULL);
INSERT INTO `areas` VALUES (16, 'منطقه 14', 'area14', 1, '36.273056', '59.682222', '2024-02-09 16:24:58', '2024-02-09 16:24:58', NULL, NULL);
INSERT INTO `areas` VALUES (17, 'منطقه 15', 'area15', 1, '36.205556', '59.486944', '2024-02-09 16:25:09', '2024-02-09 16:25:09', NULL, NULL);
INSERT INTO `areas` VALUES (18, 'منطقه 16', 'area16', 1, '36.373889', '59.6975', '2024-02-09 16:25:20', '2024-02-09 16:25:20', NULL, NULL);
INSERT INTO `areas` VALUES (19, 'منطقه 17', 'area17', 1, '36.166944', '59.543333', '2024-02-09 16:25:28', '2024-02-09 16:25:28', NULL, NULL);
INSERT INTO `areas` VALUES (20, 'تهران', 'tehran', 0, '35.714151', '51.356568', '2024-03-05 18:10:16', '2024-03-05 18:10:16', NULL, NULL);
INSERT INTO `areas` VALUES (21, 'یزد', 'yazd', 0, '31.891124', '54.351850', '2024-03-05 18:13:27', '2024-03-05 18:13:27', NULL, NULL);
INSERT INTO `areas` VALUES (22, 'یوسف آباد', 'yosef-abad', 20, '31.891124', '54.351850', '2024-03-05 18:15:22', '2024-03-05 18:15:22', NULL, NULL);
INSERT INTO `areas` VALUES (23, 'خیابان فلسطین', 'flestin', 20, '35.711271', '51.404302', '2024-03-05 20:09:02', '2024-03-05 20:09:02', NULL, NULL);
INSERT INTO `areas` VALUES (25, 'صفائیه', 'yazd-sf', 21, '31.839776', '54.375812', '2024-07-29 10:32:45', '2024-07-29 10:32:45', NULL, NULL);
INSERT INTO `areas` VALUES (26, 'امام شهر', 'yazd-em', 21, '31.902714', '54.323067', '2024-07-29 10:33:46', '2024-07-29 10:33:46', NULL, NULL);
INSERT INTO `areas` VALUES (34, 'aa', 'aa', 0, '23', '42', '2025-06-09 23:56:56', '2025-06-11 19:28:39', NULL, '[[\"35.698218190153\", \"51.403917635578\"], [\"35.699054624715\", \"51.428987193664\"], [\"35.678280570174\", \"51.428300356456\"], [\"35.676607256563\", \"51.398937682421\"], [\"35.693757057643\", \"51.388806833605\"]]');
INSERT INTO `areas` VALUES (35, 'bb', 'bb', 0, '13', '24', '2025-06-11 19:29:01', '2025-06-11 19:29:01', NULL, '[[\"35.693961822119\", \"51.351292225192\"], [\"35.693125334138\", \"51.377734019944\"], [\"35.666632010803\", \"51.378420857152\"], [\"35.668584450598\", \"51.334806694453\"]]');

-- ----------------------------
-- Table structure for bank_accounts
-- ----------------------------
DROP TABLE IF EXISTS `bank_accounts`;
CREATE TABLE `bank_accounts`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `bank_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `account_holder_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `account_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `card_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `shaba_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `before_id` int NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of bank_accounts
-- ----------------------------
INSERT INTO `bank_accounts` VALUES (1, 3, 'ملی', 'امیر حسین دامن دریا', '152252151', '5894631500384730', 'IR0120000000009282635906', 'شماره حساب ملی', '2024-02-01 17:54:45', '2024-02-01 18:17:33', '2024-02-01 18:17:33', 0);
INSERT INTO `bank_accounts` VALUES (2, 3, 'ملی2', 'امیر حسین دامن دریا2', '152252151', '5894631500384730', 'IR0120000000009282635906', 'شماره حساب ملی2', '2024-02-01 18:17:33', '2024-02-01 18:17:33', NULL, 1);
INSERT INTO `bank_accounts` VALUES (3, 7, 'بانک میهمان نواز', 'صابر ایت اللهی', '15515151515151', '5894631500384730', 'IR545454516543843484684', 'حساب بانکی تست', '2024-02-01 18:41:22', '2024-02-01 18:41:30', '2024-02-01 18:41:30', 0);
INSERT INTO `bank_accounts` VALUES (4, 7, 'بانک میهمان نواز', 'صابر ایت اللهی', '15515151515151', '5894631500384730', 'IR545454516543843484684', 'حساب بانکی تست2', '2024-02-01 18:41:30', '2024-02-10 08:02:47', '2024-02-10 08:02:47', 3);
INSERT INTO `bank_accounts` VALUES (5, 7, 'بانک میهمان نواز', 'صابر ایت اللهی', '15515151515151', '5894631500384730', 'IR545454516543843484684', 'حساب بانکی تست2', '2024-02-10 08:02:47', '2024-02-10 08:03:40', '2024-02-10 08:03:40', 4);
INSERT INTO `bank_accounts` VALUES (6, 63, 'ملی', 'امیر حسین دامن دریا', '1511315351', '5894631500384730', 'IR223521351', 'حساب ملی', '2024-07-25 11:42:53', '2024-07-25 11:42:59', '2024-07-25 11:42:59', 0);

-- ----------------------------
-- Table structure for branch_delivery_areas
-- ----------------------------
DROP TABLE IF EXISTS `branch_delivery_areas`;
CREATE TABLE `branch_delivery_areas`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `area_id` int NULL DEFAULT NULL,
  `branch_id` int NULL DEFAULT NULL,
  `shipment_price` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `created_at` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of branch_delivery_areas
-- ----------------------------
INSERT INTO `branch_delivery_areas` VALUES (4, 20, 1, '2000', NULL, NULL, NULL);
INSERT INTO `branch_delivery_areas` VALUES (6, 23, 8, '1500000', NULL, NULL, NULL);
INSERT INTO `branch_delivery_areas` VALUES (5, 1, 1, '350000', NULL, NULL, NULL);
INSERT INTO `branch_delivery_areas` VALUES (7, 21, 8, '15000000', NULL, NULL, NULL);
INSERT INTO `branch_delivery_areas` VALUES (8, 21, 1, '3500000', NULL, NULL, NULL);
INSERT INTO `branch_delivery_areas` VALUES (9, 23, 1, '3500000', NULL, NULL, NULL);

-- ----------------------------
-- Table structure for branch_delivery_types
-- ----------------------------
DROP TABLE IF EXISTS `branch_delivery_types`;
CREATE TABLE `branch_delivery_types`  (
  `branch_id` int NOT NULL,
  `delivery_type_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`branch_id`, `delivery_type_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = FIXED;

-- ----------------------------
-- Records of branch_delivery_types
-- ----------------------------
INSERT INTO `branch_delivery_types` VALUES (1, 1, NULL);
INSERT INTO `branch_delivery_types` VALUES (1, 3, NULL);
INSERT INTO `branch_delivery_types` VALUES (3, 1, NULL);
INSERT INTO `branch_delivery_types` VALUES (1, 4, NULL);
INSERT INTO `branch_delivery_types` VALUES (3, 2, NULL);
INSERT INTO `branch_delivery_types` VALUES (3, 4, NULL);
INSERT INTO `branch_delivery_types` VALUES (2, 1, NULL);
INSERT INTO `branch_delivery_types` VALUES (2, 2, NULL);

-- ----------------------------
-- Table structure for branches
-- ----------------------------
DROP TABLE IF EXISTS `branches`;
CREATE TABLE `branches`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `lat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `lng` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `main_branch` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT 'true',
  `category_id` int NOT NULL,
  `area_id` int NOT NULL,
  `vendor_id` int NOT NULL,
  `min_order` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT '120000',
  `sm_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL,
  `logo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT '0',
  `rate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT '0',
  `activities` json NULL,
  `meals` json NULL COMMENT 'Breakfast,Lunch,Dinner',
  `status` enum('active','disable','temporarily_disabled') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT 'active',
  `cash_back_status` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT 'false',
  `cash_back_percent` int NULL DEFAULT 0,
  `cash_back_max_price` int NULL DEFAULT 0,
  `per_order_status` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT 'true',
  `per_order_day` int NULL DEFAULT 1,
  `agent_id` int NULL DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `vendor`(`vendor_id`) USING BTREE,
  INDEX `area`(`area_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 22 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of branches
-- ----------------------------
INSERT INTO `branches` VALUES (1, 'کترینگ صدرسان (یوسف آباد) 2', 'یوسف آباد، نبش خیابان ۱۱، پلاک ۷۷، طبقه منفی یک، کترینگ صدرسان (یوسف آباد)', '35.839517', '51.403769', 'true', 33, 22, 1, '120000', 'ایرانی, چلو خورشت , کباب, چلو کباب', 'https://api.limofood.ir/file/5Kg8B99pBd5wzOuFPl3zJl7ih34kNGfCazfcU72s', 'https://api.limofood.ir/file/6H6otHzA57lyAORztTOzGN8kn6TbqiDGjHyE45In', 'ایرانی, چلو خورشت , کباب, چلو کباب', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"lunch\", \"dinner\"]', 'disable', '', 2, 50000, 'true', 1, 1, '0000-00-00 00:00:00', '2024-08-10 13:14:17', NULL);
INSERT INTO `branches` VALUES (2, 'رستوران ارکیده', 'میدان آرژانتین - ابتدای خیابان الوند', '35.821089', '51.467885', 'true', 33, 2, 1, '200000', 'شرکت ارکیده فاخر آرین با محوریت کافه و رستوران های زنجیره ای در سطح کشور و تحت برند ارکیده فعالیت می کند.\nدر حال حاضر ۱۱ شعبه کافه و رستوران در استان های تهران، مازندران، گیلان، اصفهان و البرز فعال هستند، که تمامی این شعب با برند ارکیده فعال هستند و تحت مدیریت شرکت ارکیده فاخر آرین فعالیت می کنند. شرکت ارکیده فاخر آرین در واقع تحت عنوان دفتر مرکزی رستوران های ارکیده فعالیت می کند.', 'https://api.limofood.ir/file/zPP3KvfQXQl4gsWWIJjlkXo175PfNbj6zYuDFiNS', 'https://api.limofood.ir/file/o1Nv48AYwt6ptObkPTCACMxjcsqUhmug84o1MQIi', 'همچون ارکیده برایمان ارزش دارید، چون اصیل و گران‌ بهایید', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '0000-00-00 00:00:00', '2024-03-10 15:51:25', NULL);
INSERT INTO `branches` VALUES (3, 'عطاویچ (بلوار کشاورز)', 'خیابان فلسطین، نرسیده بلوار کشاورز، پلاک ۴۳۶، عطاویچ (بلوار کشاورز)', '35.697673', '51.408435', 'true', 34, 23, 1, '120000', 'فست‌فود , پیتزا, ساندویچ, برگر', 'https://api.limofood.ir/file/ZbscEwAsaIRBH4wXpMQ7nBkyoGkdTneMgiK9z1nX', 'https://api.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe', 'فست‌فود , پیتزا, ساندویچ, برگر', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2023-12-21 18:00:02', '2024-03-10 15:56:00', NULL);
INSERT INTO `branches` VALUES (4, 'لانچ باکس (فلسطین)', 'میدان فاطمی، خیابان فلسطین، روبه روی کوچه رنجبر، پلاک ۵۰۵، لانچ باکس (فلسطین)', '32.199461', '54.044027', 'true', 33, 2, 10, '15', 'ایرانی, چلو کباب, چلو خورشت , چلو پلو ایرانی', 'https://api.limofood.ir/file/Sy51EwJOl7MiAOzFUVfFxHiIm5nJvx0jjB790Pbl', 'https://api.limofood.ir/file/gknw70EtqK25Eli6hdfWqawDbMQOdC40vd9R5qi2', 'ایرانی, چلو کباب, چلو خورشت , چلو پلو ایرانی', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2023-12-21 18:05:52', '2024-03-10 15:53:21', NULL);
INSERT INTO `branches` VALUES (5, 'آشپز شماره 6', 'یزد یزد یزد یزد یزد یزد یزد یزد یزد یزد یزد یزد', '31.261423', '51.129637', 'true', 33, 2, 11, '10', 'توضیحات توضیحات توضیحات توضیحات توضیحات توضیحات توضیحات', 'https://api.limofood.ir/file/Ldc8xHP838fIFvCpfx3lbgbgBwaZfG2iX1FmhJgS', 'https://api.limofood.ir/file/MRbvnf8VZNnat1IBbGwdeQwtNVv8dQhDplrzGaSs', 'آشپز شماره 6', '0', '0', '[\"0\", \"2\"]', '[]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-02-01 15:31:58', '2024-07-29 00:03:17', '2024-07-29 13:04:24');
INSERT INTO `branches` VALUES (6, 'آشپز شماره 9', 'آشپز شماره 9', '31.156151', '51.213517', 'true', 33, 2, 12, '150000', 'آشپز شماره 9', 'https://api.limofood.ir/file/D3Pb2G3XnSE59RCbpYyANg4jzc7Ion2wq95fMoc8', 'https://api.limofood.ir/file/NwNvX36ISzROHc76LHeF9PJgUb0jPdsgbrD02c6a', 'آشپز شماره 9', '0', '0', '[\"0\", \"2\"]', '[]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-02-01 15:37:18', '2024-07-29 00:02:41', '2024-07-29 13:04:27');
INSERT INTO `branches` VALUES (7, 'آشپز شماره 900', 'آشپز شماره 900', '31.143816', '51.534104', 'true', 33, 2, 14, '10000', 'آشپز شماره 900', 'https://api.limofood.ir/file/gyq4lGFZOYUpMQP8PJk0EitExJEGKJrHCGVxnAWr', 'https://api.limofood.ir/file/ZRaptUiOeloyA95tKie5mYUabTjwfcHJF04JGJL4', 'آشپز شماره 900', '0', '0', '[\"0\", \"2\"]', '[\"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-02-01 15:42:20', '2024-07-29 00:04:21', '2024-07-29 13:04:30');
INSERT INTO `branches` VALUES (8, 'صفحه تست', 'صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست صفحه تست', '36.344189', '59.412685', 'true', 33, 8, 15, '120000', NULL, 'https://api.limofood.ir/file/ZxhBsdNqwDqZo2QTlakNgxJqaXBj2gg3u1mFgOIW', 'https://api.limofood.ir/file/4BobdFOoRmpxEbiJ9iGSVgSxHd6rrItxRk149enn', NULL, '0', '0', '[\"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-25 10:16:29', '2024-07-25 11:47:44', '2024-07-27 14:29:50');
INSERT INTO `branches` VALUES (9, 'صحفه تست صحفه تست صحفه تست', 'آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس آدرس', '36.312073', '59.579148', 'true', 38, 17, 16, '120000', NULL, 'https://api.limofood.ir/file/WVDUGgpuUR6MzMciMQDpehwkIRPjiuBRzKHY0c80', 'https://api.limofood.ir/file/ZGygF3cB0t1fncPLFclojwzudnL25fE3HtghH8c3', NULL, '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-25 10:57:55', '2024-07-25 10:57:55', '2024-07-27 14:29:46');
INSERT INTO `branches` VALUES (10, 'دربیدی', 'دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی', '32.052022', '54.220831', 'true', 39, 22, 17, '120000', 'دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی', 'https://api.limofood.ir/file/yt8xMYFlpiCZX8RNOEMWtcTdPkELBYuOWbp67A3k', 'https://api.limofood.ir/file/5eu02DiIc4JLBuJhjwsSRmUWEfC76feJBSzy74rC', 'دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی دربیدی', '0', '0', '[\"2\", \"3\"]', '[\"breakfast\", \"lunch\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-25 11:02:29', '2024-07-25 11:16:08', '2024-07-27 14:29:39');
INSERT INTO `branches` VALUES (11, 'سالانی (بلوار کشاورز)', 'بلوار کشاورز، خیابان کبکانیان، پلاک ۱۹، سالانی (بلوار کشاورز)', '36.324878', '59.620829', 'true', 47, 22, 18, '120000', NULL, 'https://api.limofood.ir/file/kcWQhp5UDggKicy6f5fdv36GD0rQs0sS9VR6iHj3', 'https://api.limofood.ir/file/mMxYyLYdXIofyiUOIlTmmqVU2eCWJoQ39YgFtTPJ', NULL, '0', '0', '[\"0\", \"2\", \"3\"]', '[\"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-27 11:07:42', '2024-07-29 00:06:44', NULL);
INSERT INTO `branches` VALUES (12, 'کترینگ تیری اس', 'کشاورز، کوچه یزدان، خیابان زرتشت غربی، پلاک ۹، کترینگ تیری اس', '36.290786', '59.620889', 'true', 38, 22, 19, '120000', NULL, 'https://api.limofood.ir/file/JmkQNDxz0M5blYTtNVfNVPZASZmf6X5o2qJw6dmL', 'https://api.limofood.ir/file/A6iW7DRLuZbFJV2xdeEmhtgpi6tIuBTMdehw4G9I', 'نوشیدنی شرکتی, نوشیدنی, چلو کباب, کباب', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-27 12:44:39', '2024-07-29 00:05:21', NULL);
INSERT INTO `branches` VALUES (13, 'کافه برمودا', 'میدان مدرس، خیابان هجرت، بعد از چهارراه، نبش کوچه جانان، کافه برمودا', '36.287594', '59.605803', 'true', 90, 22, 20, '20000', NULL, 'https://api.limofood.ir/file/ddBiOsjjsvDeTKeHWX2AImFIZDh153BnyfojPyDv', 'https://api.limofood.ir/file/tm1fb7H1bV0UQ4eQzLI4keKDys5d3FRzj9rJDNDG', 'میدان مدرس، خیابان هجرت، بعد از چهارراه، نبش کوچه جانان، کافه برمودا', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-29 10:05:52', '2024-07-29 12:04:30', NULL);
INSERT INTO `branches` VALUES (14, 'کافه کیو (غذای سالم و رژیمی)', 'صفاییه، میدان فرهنگ، کافه کیو (غذای سالم و رژیمی)', '36.334592', '59.615555', 'true', 89, 25, 21, '120000', NULL, 'https://api.limofood.ir/file/UboZnu2b4cLf49tdNrZLwxXLkrl3SesVvvzObgP4', 'https://api.limofood.ir/file/2YTJKQl2JzclBWP85WoMF0OvZpJeplvrU29uZLry', NULL, '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-29 10:35:17', '2024-07-29 12:12:20', NULL);
INSERT INTO `branches` VALUES (15, 'غذای خانگی مِهرناز خانم', 'چهار راه سلمان، بعد از بلوار عاصی زاده، غذای خانگی بقچه پیچ', '36.287594', '59.605803', 'true', 39, 25, 22, '120000', NULL, 'https://api.limofood.ir/file/zlVADjcFpajEK927lHUZJyWecwSEEtTtgZu4A8Gq', 'https://api.limofood.ir/file/T6FyT1roXDuMcPDEYNAeNIh0iAuGoGfRAIG9KyM2', NULL, '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-29 12:23:06', '2024-07-29 12:33:20', NULL);
INSERT INTO `branches` VALUES (16, 'پیتزا و ساندویچ لاله', 'آزادشهر، امیرکبیر شرقی، بلوار شهید امیرسرتیپ محمد کاظم واعظ، طبقه همکف، پیتزا و ساندویچ لاله', '28.207620', '56.203170', 'true', 38, 26, 23, '120000', 'فست فود, پیتزا آمریکایی, نوشیدنی', 'https://api.limofood.ir/file/ePDmIgs9nzU561gVmvxmRHOYPM4NdnS0lIPredrj', 'https://api.limofood.ir/file/IKikmj1Kl8RsAt1Ut0zik2IoYI39BQdTbKuaLF3w', 'فست فود, پیتزا آمریکایی, نوشیدنی', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'false', 0, 0, 'true', 1, NULL, '2024-07-30 09:31:06', '2024-07-30 11:57:41', NULL);
INSERT INTO `branches` VALUES (17, 'رستوران روز طلایی', 'بلوار ۱۷ شهریور، نرسیده به چهارراه شرکت نفت، رستوران روز طلایی', '36.267769', '59.514770', 'true', 36, 25, 24, '120000', 'نوشیدنی شرکتی, نوشیدنی, چلو کباب, کباب, چلو پلو ایرانی', 'https://api.limofood.ir/file/FQ2MdvvDH2MqewdESueSEpOqgjNq5Cudt33xPOZd', 'https://api.limofood.ir/file/QT6BH6K4KRlQ5M48gLANDEgWlcIGiLJWkiWLv9dF', 'نوشیدنی شرکتی, نوشیدنی, چلو کباب, کباب, چلو پلو ایرانی', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'disable', 'false', 0, 0, 'true', 1, NULL, '2024-07-30 11:59:35', '2024-07-30 12:03:44', NULL);
INSERT INTO `branches` VALUES (18, 'تست تست تست تست', 'تست تست تست تست تست تست تست تست تست تست تست', '32.040616', '54.665719', 'true', 38, 18, 25, '120000', 'تست تست تست تست تست تست تست تست تست تست تست تست تست', 'https://api.limofood.ir/file/RVHrkyfv3nrAq46Q2ZPbUmrKxVJpToJ1pOLatiI1', 'https://api.limofood.ir/file/TzNMMxrkb9zzvhHK5u8DMiIhLe97PKx9t2W7AcIn', 'تست تست تست تست تست تست تست تست تست', '0', '0', '[]', '[]', 'disable', 'false', 0, 0, 'true', 1, NULL, '2024-08-02 15:03:46', '2024-08-02 15:10:20', NULL);
INSERT INTO `branches` VALUES (19, 'لبنیات شیر پروران یزد', 'صفائیه، شهرک دانشگاه، کوچه اقاقیا، بلوار آیت الله خاتمی، لبنیات شیر پروران یزد', '36.310853', '59.563458', 'true', 80, 25, 26, '120000', 'لبنیات شیر پروران یزد', 'https://api.limofood.ir/file/PWSCvY1ySAHj6zJocLSxMXFTa5IzTpnl0M6dQh9l', 'https://api.limofood.ir/file/7C74iAssEtqu8AP0ZViXhr7alnmjTlJWoTcf0c95', 'لبنیات شیر پروران یزد', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'true', 0, 0, 'true', 1, NULL, '2024-08-03 09:31:56', '2025-03-30 11:32:34', NULL);
INSERT INTO `branches` VALUES (20, 'کافه بستنی دنج', 'آزادشهر، قبل از فلکه اول، سمت چپ، کافه بستنی دنج', '36.286912', '59.606363', 'true', 79, 26, 27, '120000', 'کافه بستنی دنج', 'https://api.limofood.ir/file/Lh6vnm0KruhWkdO8EragqQhWHW1B7Z0t7t7X1sj8', 'https://api.limofood.ir/file/9iGWbEUfhBuhBvvQxBylHOWyRZ4JUPFpF8WOK5J6', 'کافه بستنی دنج', '0', '0', '[\"0\", \"2\", \"3\"]', '[\"breakfast\", \"lunch\", \"dinner\"]', 'active', 'true', 0, 0, 'true', 1, 2, '2024-08-03 10:47:37', '2025-03-14 10:23:25', NULL);
INSERT INTO `branches` VALUES (21, 'csdcsdc', 'csdcsdcsd', '36.300318', '59.611307', 'true', 38, 17, 28, '120000', 'csdcsdcsd', 'http://localhost/file/wcoq3v0ExOqALtyy4bKQz3I96sZDNA5fCOoxLGis', 'http://localhost/file/RLMlmTZHNbDuIQ3nJbGfM6mhqITGyAOAbVgjEgBw', 'csdcsdcsd', '0', '0', '[\"2\"]', '[]', 'active', 'false', 0, 0, 'true', 1, 1, '2024-10-18 15:51:34', '2024-10-18 15:51:34', NULL);

-- ----------------------------
-- Table structure for categories
-- ----------------------------
DROP TABLE IF EXISTS `categories`;
CREATE TABLE `categories`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `parent_id` int NOT NULL,
  `branch_id` int NOT NULL DEFAULT 0 COMMENT '0:main_site',
  `start_serving` time NULL DEFAULT NULL,
  `end_serving` time NULL DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 159 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of categories
-- ----------------------------
INSERT INTO `categories` VALUES (38, 'فست فود', 'https://api.limofood.ir/file/6oe2R1fDeG692BEeWF0TFJkbfHgK4SdmxTrVd2pq', 33, 0, NULL, NULL, '2024-03-05 19:21:57', '2024-07-29 09:35:26', NULL);
INSERT INTO `categories` VALUES (3, 'چلو کباب', 'https://api.limofood.ir/file/logtrQ67tRtTqnEtv59SqvTzQcEdCdqVYGVdokxZ', 0, 1, '13:10:00', '23:45:00', '0000-00-00 00:00:00', '2024-07-15 12:01:02', NULL);
INSERT INTO `categories` VALUES (4, 'جوجه کباب', NULL, 1, 0, NULL, NULL, '2023-12-10 20:52:06', NULL, NULL);
INSERT INTO `categories` VALUES (5, 'کباب', NULL, 1, 1, NULL, NULL, '2023-12-10 20:52:06', NULL, NULL);
INSERT INTO `categories` VALUES (6, 'سنتی', NULL, 1, 0, NULL, NULL, '2023-12-10 20:52:06', NULL, NULL);
INSERT INTO `categories` VALUES (7, 'پلوی ایرانی', NULL, 1, 0, NULL, NULL, '2023-12-10 20:52:06', NULL, NULL);
INSERT INTO `categories` VALUES (8, 'خورشت', 'https://api.limofood.ir/file/m3OJ61KANzvsI85nOiHLBFJlcaH50G5CuXW8PdFA', 1, 1, NULL, NULL, '2023-12-10 20:52:06', '2023-12-16 19:05:41', NULL);
INSERT INTO `categories` VALUES (33, 'رستوران', 'https://api.limofood.ir/file/jkDgDp4Ysa3OvjE8oBpzxwOV8CZmjZLcYnUlk5Lb', 0, 0, NULL, NULL, '2024-03-05 18:42:43', '2024-07-28 22:48:06', NULL);
INSERT INTO `categories` VALUES (11, 'پیتزا', NULL, 2, 0, NULL, NULL, '2023-12-10 20:54:12', NULL, NULL);
INSERT INTO `categories` VALUES (12, 'ساندویج', NULL, 2, 0, NULL, NULL, '2023-12-10 20:54:12', NULL, NULL);
INSERT INTO `categories` VALUES (13, 'برگر', NULL, 2, 0, NULL, NULL, '2023-12-10 20:54:12', NULL, NULL);
INSERT INTO `categories` VALUES (14, 'سوخاری', NULL, 2, 0, NULL, NULL, '2023-12-10 20:54:12', NULL, NULL);
INSERT INTO `categories` VALUES (15, 'استیک', NULL, 2, 0, NULL, NULL, '2023-12-10 20:54:12', NULL, NULL);
INSERT INTO `categories` VALUES (39, 'ایرانی', 'https://api.limofood.ir/file/RtaDvt9xrtCK0sIlcAowuykPgykSHIoxhIAfbxDh', 33, 0, NULL, NULL, '2024-03-05 19:22:16', '2024-07-29 09:36:31', NULL);
INSERT INTO `categories` VALUES (41, 'عطا غول ها', 'https://api.limofood.ir/file/2MuLxFzi2FS2f8ZXawyvUpAgfTG9q1RrRWcQzNTl', 0, 3, NULL, NULL, '2024-03-05 20:11:26', '2024-03-05 20:11:26', NULL);
INSERT INTO `categories` VALUES (42, 'عطا پیتزا ها', 'https://api.limofood.ir/file/38JNYg5T4Hln1XqyX8xrsWc9Z5fRA4J2QIkmItZ3', 0, 3, NULL, NULL, '2024-03-05 20:11:37', '2024-03-05 20:11:37', NULL);
INSERT INTO `categories` VALUES (40, 'سوپر مارکت', 'https://api.limofood.ir/file/9dRSZd8YryPr1UXO50geJGYyVvpbA2X4NCEpFbXx', 0, 0, NULL, NULL, '2024-03-05 19:45:53', '2024-07-28 22:48:34', NULL);
INSERT INTO `categories` VALUES (36, 'کباب', 'https://api.limofood.ir/file/wtG9IsBQpknB7Mv0kJYwQYSaQHmGTkLmLLcangC9', 33, 0, NULL, NULL, '2024-03-05 19:21:24', '2024-03-05 19:21:24', NULL);
INSERT INTO `categories` VALUES (35, 'کافه', 'https://api.limofood.ir/file/8ikTMfRY8irIrBpfJCEprFyrA5ZKaUDNRMJSYK4B', 0, 0, NULL, NULL, '2024-03-05 18:46:03', '2024-07-28 22:48:46', NULL);
INSERT INTO `categories` VALUES (37, 'سالاد', 'https://api.limofood.ir/file/flpy1Y9n9zkOoZ53uona8zcWUN57dkNxo4csLF9y', 33, 0, NULL, NULL, '2024-03-05 19:21:45', '2024-07-29 09:38:11', NULL);
INSERT INTO `categories` VALUES (34, 'شیرینی', 'https://api.limofood.ir/file/MoYh9jZwgCkmejaiHf2ol3jih1JkaOzl5NpPbMFJ', 0, 0, NULL, NULL, '2024-03-05 18:44:49', '2024-07-28 22:48:59', NULL);
INSERT INTO `categories` VALUES (24, 'سینی‌ها', 'https://api.limofood.ir/file/LHZPSfYijtp6dooDET1WJiuyLkUJrNkT522cZoW6', 0, 2, NULL, NULL, '2024-03-02 21:35:43', '2024-03-02 21:35:43', NULL);
INSERT INTO `categories` VALUES (25, 'غذاهای فرنگی', 'https://api.limofood.ir/file/ltJx823gwMwxut6wWvnwoo0Z2WrfF6Q8FCgxex9y', 0, 2, NULL, NULL, '2024-03-02 21:35:55', '2024-03-02 21:35:55', NULL);
INSERT INTO `categories` VALUES (26, 'خوراک‌ها', 'https://api.limofood.ir/file/8fB8FLdELdBvrPthopNW2zx3Aw1yODTaYWGpu2Ph', 0, 2, NULL, NULL, '2024-03-02 21:36:12', '2024-03-02 21:36:12', NULL);
INSERT INTO `categories` VALUES (27, 'غذای مخصوص', 'https://api.limofood.ir/file/9wjGr7Iuwcj72VlsaDc5tsJfdZ92G8TvvpacfDM5', 0, 2, NULL, NULL, '2024-03-02 21:36:28', '2024-03-02 21:36:28', NULL);
INSERT INTO `categories` VALUES (28, 'سالادها', 'https://api.limofood.ir/file/lGbqGqsciUW4v0uDxSRStIPCTuGx3hhca2sRWIjJ', 0, 2, NULL, NULL, '2024-03-02 21:36:58', '2024-03-02 21:36:58', NULL);
INSERT INTO `categories` VALUES (29, 'پیش‌غذاها', 'https://api.limofood.ir/file/5jEC0WpQEKRBMghIx7U9O4lHkL0cQaWvaCNctTPn', 0, 2, NULL, NULL, '2024-03-02 21:37:12', '2024-03-02 21:37:12', NULL);
INSERT INTO `categories` VALUES (30, 'خورشت', 'https://api.limofood.ir/file/2pgFhWpyUIK3KuLhW0Ky0qOh5liJGQopVSWrQG6Z', 0, 1, NULL, NULL, '2024-03-05 18:27:52', '2024-03-05 18:27:52', NULL);
INSERT INTO `categories` VALUES (31, 'خوراک', 'https://api.limofood.ir/file/pf8t3PmgO7Bbbu82NG7wpPCWwQrrBWlMjwg7nvVQ', 0, 1, NULL, NULL, '2024-03-05 18:28:04', '2024-03-05 18:28:04', NULL);
INSERT INTO `categories` VALUES (32, 'سالاد و پیش غذا', 'https://api.limofood.ir/file/O90mbCksK0KMLZCMqYGlyg1r34yoVVnpL3HoNmlK', 0, 1, NULL, NULL, '2024-03-05 18:28:30', '2024-03-05 18:28:30', NULL);
INSERT INTO `categories` VALUES (43, 'عطا کمبوها', 'https://api.limofood.ir/file/LDGNYs8jLXv0q3F0k28cNECj4b4uKUge1MPoljlh', 0, 3, NULL, NULL, '2024-03-05 20:11:49', '2024-03-05 20:11:49', NULL);
INSERT INTO `categories` VALUES (44, 'عطا برگر ها', 'https://api.limofood.ir/file/AwLI7YUHyqtCwvQddI6ycgxHtt1PZvDzvKxoWf4M', 0, 3, NULL, NULL, '2024-03-05 20:12:02', '2024-03-05 20:12:02', NULL);
INSERT INTO `categories` VALUES (45, 'عطا چیز ها', 'https://api.limofood.ir/file/clcoqRQWLl8ChwO1wVHuzQf32sFSGWqNGRsef012', 0, 3, NULL, NULL, '2024-03-05 20:12:13', '2024-03-05 20:12:13', NULL);
INSERT INTO `categories` VALUES (46, 'عطا میدل ها', 'https://api.limofood.ir/file/SXuMJ0r4tQNksR3IcpO6IzNnMFbtwTQlmsPK07uT', 0, 3, NULL, NULL, '2024-03-05 20:12:51', '2024-03-05 20:12:51', NULL);
INSERT INTO `categories` VALUES (47, 'پیتزا', 'https://api.limofood.ir/file/uyCfrkkWDZZmoP70mbRNnNIsmjp8wh0bfRKy7Xq9', 34, 0, NULL, NULL, '2024-03-05 20:16:07', '2024-03-05 20:16:07', NULL);
INSERT INTO `categories` VALUES (48, 'برگر', 'https://api.limofood.ir/file/ZsF8FNrJercYrbzWlG8y1yAZfdJ3GrLneuEUe7dG', 34, 0, NULL, NULL, '2024-03-05 20:16:24', '2024-03-05 20:16:24', NULL);
INSERT INTO `categories` VALUES (49, 'سوخاری', 'https://api.limofood.ir/file/V5LAEaN0w4oiHQ7VJ67lyCYGx0PnHfOSklePTbrt', 34, 0, NULL, NULL, '2024-03-05 20:16:36', '2024-03-05 20:16:36', NULL);
INSERT INTO `categories` VALUES (50, 'استیک', 'https://api.limofood.ir/file/OSV99vDhdZElmwwAvx1dufSikCuEeerPSMSDXzCq', 34, 0, NULL, NULL, '2024-03-05 20:16:49', '2024-03-05 20:16:49', NULL);
INSERT INTO `categories` VALUES (51, 'پاستا', 'https://api.limofood.ir/file/GEgKAUH5BsULRKhGEwWbEFaqWcSrRxPyzMiJDPxg', 34, 0, NULL, NULL, '2024-03-05 20:17:00', '2024-03-05 20:17:00', NULL);
INSERT INTO `categories` VALUES (52, 'ساندویچ', 'https://api.limofood.ir/file/0XisgrWlvDEVeNdLOCWMA8pV6Ny0R0YbeeI8YM6K', 34, 0, NULL, NULL, '2024-03-05 20:17:17', '2024-03-05 20:17:17', NULL);
INSERT INTO `categories` VALUES (53, 'غذای ایرانی', 'https://api.limofood.ir/file/l7KFN6aUCfCCuG3pEAfocbjGZTt2SyguhUNdDUw9', 0, 4, NULL, NULL, '2024-03-08 11:26:23', '2024-03-08 11:26:23', NULL);
INSERT INTO `categories` VALUES (54, 'خوراک', 'https://api.limofood.ir/file/UmJ6THhevA4vrys65H2AwUbTHzeFyxWQavNCDovh', 0, 4, NULL, NULL, '2024-03-08 11:26:49', '2024-03-08 11:26:49', NULL);
INSERT INTO `categories` VALUES (55, 'قاطی پلو', 'https://api.limofood.ir/file/9lLpOvPVK3OzvSgLw92wwtGoaKFVf2JmIDZhsV9N', 0, 4, NULL, NULL, '2024-03-08 11:27:06', '2024-03-08 11:27:06', NULL);
INSERT INTO `categories` VALUES (56, 'اکو لانچ', 'https://api.limofood.ir/file/2yUYEjkPUY77WLnIJbRFQdaNqJW6Rbayq78TkN1W', 0, 4, NULL, NULL, '2024-03-08 11:27:25', '2024-03-08 11:27:25', NULL);
INSERT INTO `categories` VALUES (57, 'سالاد و پیش غذا', 'https://api.limofood.ir/file/hVhIeVU9f5Iq3q07bXFciWu9plDFBjNkTlD8Hd4Z', 0, 4, NULL, NULL, '2024-03-08 11:27:59', '2024-03-08 11:27:59', NULL);
INSERT INTO `categories` VALUES (58, 'تست', 'https://api.limofood.ir/file/uhivqCG1esoKCezqIMopvIcU21pGMPYPfRAH6dbl', 0, 1, NULL, NULL, '2024-07-15 11:52:51', '2024-07-15 11:52:51', NULL);
INSERT INTO `categories` VALUES (59, 'ایرانی2', 'https://api.limofood.ir/file/D5Ups2awbjVFKVDBEEh88znQ1H8OvDEM3jr0YEEw', 0, 8, NULL, NULL, '2024-07-25 11:32:29', '2024-07-25 11:36:49', '2024-07-25 11:36:49');
INSERT INTO `categories` VALUES (60, 'ایرانی', 'https://api.limofood.ir/file/YDA74OMhkiJEdXAjaDvAItkefnoRntGieZ67NkHh', 0, 8, NULL, NULL, '2024-07-25 11:37:45', '2024-07-25 11:37:45', NULL);
INSERT INTO `categories` VALUES (61, 'فقایقفای', 'https://api.limofood.ir/file/q2ZOmAc6w6kOAdT3dTyZNeItyMF9QtpHXNx0o2fF', 0, 0, NULL, NULL, '2024-07-27 10:36:58', '2024-07-27 10:37:40', '2024-07-27 10:37:40');
INSERT INTO `categories` VALUES (62, 'اقفتففتلغتغ7', 'https://api.limofood.ir/file/aMoiJF1jFZDbNwIobnlxfUWuTO1RUAdR777MTuHn', 0, 1, NULL, NULL, '2024-07-27 10:58:02', '2024-07-27 10:58:32', '2024-07-27 10:58:32');
INSERT INTO `categories` VALUES (63, 'ساندویچ گرم', 'https://api.limofood.ir/file/F9DL1NhUFsBibDBQYsSH6hj6NM4fa7Uh74Jomr7k', 0, 11, NULL, NULL, '2024-07-27 11:09:10', '2024-07-27 12:30:11', NULL);
INSERT INTO `categories` VALUES (64, 'ساندویچ سرد', 'https://api.limofood.ir/file/Os5fMOCVuFDenzWlqppQ4HuNy0MkAIiapD6DOlDL', 0, 11, NULL, NULL, '2024-07-27 11:10:04', '2024-07-27 12:30:23', NULL);
INSERT INTO `categories` VALUES (65, 'نوشیدنی', 'https://api.limofood.ir/file/jkueeCIyTYi2mK3KOHvSecL8vKO2a2uZFLIyvtuu', 0, 11, NULL, NULL, '2024-07-27 12:09:52', '2024-07-27 12:09:52', NULL);
INSERT INTO `categories` VALUES (66, 'تک سیخ', 'https://api.limofood.ir/file/Az7KWHFMF2CrysRVPinqWVc8YkeTHYbV1OyUW3Lk', 0, 12, NULL, NULL, '2024-07-27 12:49:28', '2024-07-27 12:49:28', NULL);
INSERT INTO `categories` VALUES (67, 'چلو کباب', 'https://api.limofood.ir/file/tUS5ad4iVGAuRWfcSLc4aUyVzhMhnUCaOyTtP1Uc', 0, 12, NULL, NULL, '2024-07-27 12:55:24', '2024-07-27 12:55:24', NULL);
INSERT INTO `categories` VALUES (68, 'خوراک', 'https://api.limofood.ir/file/SCTpLUyR8CIeuwoi4oreEODGYsN21UiJRREKEs6e', 0, 12, NULL, NULL, '2024-07-27 12:57:36', '2024-07-27 12:57:36', NULL);
INSERT INTO `categories` VALUES (69, 'غذاهای سنتی ایرانی', 'https://api.limofood.ir/file/iq9f7TmYcDz9i44Gb6EXYtKq6jsdBJIJ3MuSAUyi', 0, 12, NULL, NULL, '2024-07-27 12:59:52', '2024-07-27 14:29:37', '2024-07-27 14:29:37');
INSERT INTO `categories` VALUES (70, 'غذاهای سنتی ایرانی', 'https://api.limofood.ir/file/88giUCiwdEdyKDuyC5rOwQQlTka4P0jihmVg8gpz', 0, 12, NULL, NULL, '2024-07-27 12:59:53', '2024-07-27 13:00:00', '2024-07-27 13:00:00');
INSERT INTO `categories` VALUES (71, 'نوشیدنی', 'https://api.limofood.ir/file/mhPNR11uLTAm32tmpE2srv4L0wNe6EDngJURaeJF', 0, 12, NULL, NULL, '2024-07-27 13:00:33', '2024-07-27 13:00:33', NULL);
INSERT INTO `categories` VALUES (72, 'خورشت ها', 'https://api.limofood.ir/file/N7Foo2UYmOxo80NnVagbmLXESGHik8blaWZP9TgR', 0, 12, NULL, NULL, '2024-07-27 13:01:10', '2024-07-27 13:03:30', '2024-07-27 13:03:30');
INSERT INTO `categories` VALUES (73, 'خورشت ها', 'https://api.limofood.ir/file/FQ5kGDmgTTtYVXYppPjmCpKnVp0lNmGGb1X7RYBc', 0, 12, NULL, NULL, '2024-07-27 13:01:11', '2024-07-27 13:01:11', NULL);
INSERT INTO `categories` VALUES (74, 'خورشت ها', 'https://api.limofood.ir/file/cBQd0QzxSFkLV3fKbmviA1chYOdCpORoUdE7k4ss', 0, 12, NULL, NULL, '2024-07-27 13:01:12', '2024-07-27 13:03:38', '2024-07-27 13:03:38');
INSERT INTO `categories` VALUES (75, 'سالاد و پیش غذا', 'https://api.limofood.ir/file/oqnoLSyOLCfez2QLFImdpNM5KH5NxlLowI0vu4X1', 0, 12, NULL, NULL, '2024-07-27 13:03:21', '2024-07-27 13:03:21', NULL);
INSERT INTO `categories` VALUES (76, 'نانوایی', 'https://api.limofood.ir/file/ywLIe3aFMEOJybR2fd6e3iaJisNLKcGEzOydcYJ9', 0, 0, NULL, NULL, '2024-07-28 22:49:11', '2024-07-28 22:49:11', NULL);
INSERT INTO `categories` VALUES (77, 'میوه', 'https://api.limofood.ir/file/52Ppu4jwCjfDkDtzOVXv1KWLHwFu6spTcJuERCU7', 0, 0, NULL, NULL, '2024-07-28 22:49:25', '2024-07-28 22:49:25', NULL);
INSERT INTO `categories` VALUES (78, 'پروتئین', 'https://api.limofood.ir/file/q6qdAy7VkFsAmcJE6l1yDEWcilZVcExCddgERicA', 0, 0, NULL, NULL, '2024-07-28 22:49:55', '2024-07-28 22:49:55', NULL);
INSERT INTO `categories` VALUES (79, 'آبمیوه بستنی', 'https://api.limofood.ir/file/DxGoLx5XeGozWQfXFxQHkuRUksRpFQGeLqMmQewi', 0, 0, NULL, NULL, '2024-07-28 22:50:13', '2024-07-28 22:50:13', NULL);
INSERT INTO `categories` VALUES (80, 'لبنیات', 'https://api.limofood.ir/file/x07QnatABvUEMuGyRCaufBBuwyOKZQ2gAS4dNsy7', 0, 0, NULL, NULL, '2024-07-28 22:50:59', '2024-07-28 22:50:59', NULL);
INSERT INTO `categories` VALUES (81, 'گل و گیاه', 'https://api.limofood.ir/file/FFS35dfuK3xekxYcDWkpl5bIla2yIBABILQL9pqn', 0, 0, NULL, NULL, '2024-07-28 22:51:12', '2024-07-28 22:51:12', NULL);
INSERT INTO `categories` VALUES (82, 'عطاری', 'https://api.limofood.ir/file/5ovNvPdkGH1EVv2q7StB37GfEAnJjJqbnKDqwVpG', 0, 0, NULL, NULL, '2024-07-28 22:51:23', '2024-07-28 22:51:23', NULL);
INSERT INTO `categories` VALUES (83, 'آجیل و خشکبار', 'https://api.limofood.ir/file/ko7LRO2p2kOL4eUlrDU1QF8o1TbIvDq4jZQrMvQE', 0, 0, NULL, NULL, '2024-07-28 22:51:35', '2024-07-28 22:51:35', NULL);
INSERT INTO `categories` VALUES (84, 'قهوه شکلات', 'https://api.limofood.ir/file/C1gOBbMRrNfyYeRHTydCkALIhOdJbzQFgvVPttXN', 0, 0, NULL, NULL, '2024-07-28 22:51:48', '2024-07-28 22:51:48', NULL);
INSERT INTO `categories` VALUES (85, 'آرایشی بهداشتی', 'https://api.limofood.ir/file/DqjdKfj8ogMwoL5q9q2oyyMUWrc77kXzU86HBp40', 0, 0, NULL, NULL, '2024-07-28 22:52:03', '2024-07-28 22:52:03', NULL);
INSERT INTO `categories` VALUES (86, 'سایر', 'https://api.limofood.ir/file/jHQ9EgQeOtuc4A66YCu2s89nr3gBoWyiVuP0JFKN', 0, 0, NULL, NULL, '2024-07-28 22:52:14', '2024-07-28 22:52:14', NULL);
INSERT INTO `categories` VALUES (87, 'دریایی', 'https://api.limofood.ir/file/HAKjNbGG0QCOGTUWl21qXDc6ryOSHrT51MQ9lMJM', 33, 0, NULL, NULL, '2024-07-29 09:39:22', '2024-07-29 09:39:22', NULL);
INSERT INTO `categories` VALUES (88, 'بین‌الملل', 'https://api.limofood.ir/file/PXVz980kGE9j80srSWRKmCizrfW1NJBqoYl5cQOa', 33, 0, NULL, NULL, '2024-07-29 09:40:49', '2024-07-29 09:40:49', NULL);
INSERT INTO `categories` VALUES (89, 'غذا', 'https://api.limofood.ir/file/uAxXtWhYywfynAbtj1WrtNEH4jaRZVNNFrqLEwTL', 35, 0, NULL, NULL, '2024-07-29 09:42:54', '2024-07-29 09:42:54', NULL);
INSERT INTO `categories` VALUES (90, 'نوشیدنی گرم', 'https://api.limofood.ir/file/RU2czZsFgYJybga5IyKEBM1ZlulZtGw2OoeQPRhH', 35, 0, NULL, NULL, '2024-07-29 09:43:56', '2024-07-29 09:43:56', NULL);
INSERT INTO `categories` VALUES (91, 'نوشیدنی سرد', 'https://api.limofood.ir/file/TFWx25XbUvcaFmov8tZcOey6qItUFgQT4RRYgKJW', 35, 0, NULL, NULL, '2024-07-29 09:45:05', '2024-07-29 09:45:05', NULL);
INSERT INTO `categories` VALUES (92, 'کیک و دسر', 'https://api.limofood.ir/file/x50ApuBho8wxybubavmZYpfjSefI9BHFcmEFlqcz', 35, 0, NULL, NULL, '2024-07-29 09:47:45', '2024-07-29 09:47:45', NULL);
INSERT INTO `categories` VALUES (93, 'بستنی', 'https://api.limofood.ir/file/u9Po521L9BwITioOG227pKNJx7IOtK4uaWXO5Dek', 35, 0, NULL, NULL, '2024-07-29 09:48:51', '2024-07-29 09:48:51', NULL);
INSERT INTO `categories` VALUES (94, 'سنگک', 'https://api.limofood.ir/file/K9wUCbxYJML6rKJk1xRrVsLgrmgVINVhXamLmTmI', 76, 0, NULL, NULL, '2024-07-29 09:50:46', '2024-07-29 09:50:46', NULL);
INSERT INTO `categories` VALUES (95, 'بربری', 'https://api.limofood.ir/file/WUoieDfmhh7SzZWRhdyhbuQJgfPFSTLVTKHVUdeV', 76, 0, NULL, NULL, '2024-07-29 09:51:26', '2024-07-29 09:51:26', NULL);
INSERT INTO `categories` VALUES (96, 'بربری', 'https://api.limofood.ir/file/Z0MGgtQQnLHAyh3WrIbEpGL9mKBiAcjL0IEABOru', 76, 0, NULL, NULL, '2024-07-29 09:51:26', '2024-07-29 09:51:33', '2024-07-29 09:51:33');
INSERT INTO `categories` VALUES (97, 'لواش', 'https://api.limofood.ir/file/rQE1D1El7pXLmWpgBUcXrkkUGusZ02IdktntXJiV', 76, 0, NULL, NULL, '2024-07-29 09:51:56', '2024-07-29 09:51:56', NULL);
INSERT INTO `categories` VALUES (98, 'تافتون', 'https://api.limofood.ir/file/aSALnwV8cnhQZth2qD1zlNYoOFXmGeukn8T2A8Ry', 76, 0, NULL, NULL, '2024-07-29 09:52:17', '2024-07-29 09:52:17', NULL);
INSERT INTO `categories` VALUES (99, 'مرغ', 'https://api.limofood.ir/file/amj9gYgNq7veQkIHJNH2MvKnWOyWj3oyBRYcFYfj', 78, 0, NULL, NULL, '2024-07-29 09:53:50', '2024-07-29 09:53:50', NULL);
INSERT INTO `categories` VALUES (100, 'گوشت قرمز', 'https://api.limofood.ir/file/W7SigkkmmDcgqxfmiwfwlBFk1LkupaU1EXHwTQnv', 78, 0, NULL, NULL, '2024-07-29 09:54:32', '2024-07-29 09:54:32', NULL);
INSERT INTO `categories` VALUES (101, 'گوشت کبابی', 'https://api.limofood.ir/file/GcOx9feELBt0IVlSxZZwX75gv0e3RHDTorV3BunR', 78, 0, NULL, NULL, '2024-07-29 09:54:59', '2024-07-29 09:54:59', NULL);
INSERT INTO `categories` VALUES (102, 'سوسیس و کالباس', 'https://api.limofood.ir/file/JHza4etk2Y3JgtOJ2XJ1Yfvxv5sgJrhddGzdc79C', 78, 0, NULL, NULL, '2024-07-29 09:55:42', '2024-07-29 09:55:42', NULL);
INSERT INTO `categories` VALUES (103, 'ماهی و میگو', 'https://api.limofood.ir/file/0rS0zvYBRmIdx1uTsU67rhgz0LXIRMrMCQNCaEJs', 78, 0, NULL, NULL, '2024-07-29 09:56:15', '2024-07-29 09:56:15', NULL);
INSERT INTO `categories` VALUES (104, 'استیک', 'https://api.limofood.ir/file/F61m1HMxqnrEnhdWMF7P9PeP1B0psuuBR7lZeDPq', 78, 0, NULL, NULL, '2024-07-29 09:56:38', '2024-07-29 09:56:38', NULL);
INSERT INTO `categories` VALUES (105, 'نوشیدنی گرم', 'https://api.limofood.ir/file/cjmwW4kqykabHWKJXDqjAggZjbEqfDvorBkwpg5B', 0, 13, NULL, NULL, '2024-07-29 10:08:21', '2024-07-29 10:08:21', NULL);
INSERT INTO `categories` VALUES (106, 'قهوه', 'https://api.limofood.ir/file/NjKK1NRW2lwIR4PdA1VxvjbIO7V8wRYFXzR6hla0', 0, 13, NULL, NULL, '2024-07-29 10:09:11', '2024-07-29 10:09:11', NULL);
INSERT INTO `categories` VALUES (107, 'صبحانه', 'https://api.limofood.ir/file/2hoollekwD4ARmgRoeH5CXUKlIhcYvVjsE6QuVs8', 0, 14, NULL, NULL, '2024-07-29 10:39:14', '2024-07-29 10:54:16', NULL);
INSERT INTO `categories` VALUES (108, 'بشقاب ها', 'https://api.limofood.ir/file/VqJNyRYaXd1sJ99avR0RIDuGuBuD3RCX9HpmF1tX', 0, 14, NULL, NULL, '2024-07-29 10:41:39', '2024-07-29 10:54:42', NULL);
INSERT INTO `categories` VALUES (109, 'سالاد', 'https://api.limofood.ir/file/MCwDyZGBy4pXzaRAX0zuJJxlKKXd8trz8LwymUB2', 0, 14, NULL, NULL, '2024-07-29 10:53:50', '2024-07-29 10:53:50', NULL);
INSERT INTO `categories` VALUES (110, 'خوراک', 'https://api.limofood.ir/file/e5DsFmqSeYwa2qPBgQmo68YHmJi9BMrdWMIqT0Or', 0, 14, NULL, NULL, '2024-07-29 10:55:51', '2024-07-29 10:55:51', NULL);
INSERT INTO `categories` VALUES (111, 'ساندویچ', 'https://api.limofood.ir/file/75EzmkdhZzEgNGNsN5gCZLHnDMQS8gDghqUoMDyw', 0, 14, NULL, NULL, '2024-07-29 10:56:17', '2024-07-29 10:56:17', NULL);
INSERT INTO `categories` VALUES (112, 'برگر', 'https://api.limofood.ir/file/F3TVVVtD9ekjCXVooKNjBrcRURISsmOobbEatHfc', 0, 14, NULL, NULL, '2024-07-29 10:56:52', '2024-07-29 10:56:52', NULL);
INSERT INTO `categories` VALUES (113, 'میان وعده', 'https://api.limofood.ir/file/Y8kqwvuFRRdtyY2Sx0C5x2U373MNMPL4ToIANLKM', 0, 14, NULL, NULL, '2024-07-29 10:57:56', '2024-07-29 11:59:46', '2024-07-29 11:59:46');
INSERT INTO `categories` VALUES (114, 'نوشیدنی', 'https://api.limofood.ir/file/fmFKAcJGIFQ1KJIwy5BFhmH0McCN9nOHqpNKlJNd', 0, 14, NULL, NULL, '2024-07-29 10:58:28', '2024-07-29 10:58:28', NULL);
INSERT INTO `categories` VALUES (115, 'غذای ایرانی', 'https://api.limofood.ir/file/tm2rpfES1rENGAtpfVR52PuCBL96Yl1udY7PDtt6', 0, 15, NULL, NULL, '2024-07-29 12:26:04', '2024-07-29 12:26:04', NULL);
INSERT INTO `categories` VALUES (116, 'غذای فرنگی', 'https://api.limofood.ir/file/f8rovrXFQVcQzm97XoYZ7cuQqinaHTlnuVWEz2NN', 0, 15, NULL, NULL, '2024-07-29 12:26:37', '2024-07-29 12:26:37', NULL);
INSERT INTO `categories` VALUES (117, 'سرویس اضافه', 'https://api.limofood.ir/file/KSolfNN1J78AvY3hCpQ23qrQPOZrOdm6rra4CTpi', 0, 15, NULL, NULL, '2024-07-29 12:28:57', '2024-07-29 13:13:48', '2024-07-29 13:13:48');
INSERT INTO `categories` VALUES (118, 'چلو خورشت', 'https://api.limofood.ir/file/qkJXOAS75frPB18gBlipztURZph5Jn31yFBsGgYR', 0, 15, NULL, NULL, '2024-07-29 12:29:27', '2024-07-29 12:34:22', NULL);
INSERT INTO `categories` VALUES (119, 'خوراک', 'https://api.limofood.ir/file/MFSCEEo8sjWGgkBTcRN3MXJLInoOH6qrLYzgpfVC', 0, 15, NULL, NULL, '2024-07-29 12:31:37', '2024-07-29 12:31:37', NULL);
INSERT INTO `categories` VALUES (120, 'غذای روزانه', 'https://api.limofood.ir/file/ArenKRf858m721nA9hSr5XEavrL1TPqhrPpDvLRH', 0, 15, NULL, NULL, '2024-07-29 12:32:51', '2024-07-29 13:39:45', '2024-07-29 13:39:45');
INSERT INTO `categories` VALUES (121, 'پیش غذا و سالاد', 'https://api.limofood.ir/file/equ8qX8EXxjl9A7rrSezPtTZFdimA0SHVne7Tzb7', 0, 15, NULL, NULL, '2024-07-29 12:34:49', '2024-07-29 12:34:49', NULL);
INSERT INTO `categories` VALUES (122, 'نوشیدنی', 'https://api.limofood.ir/file/SRIIUvFDCUujqwrfzHToETZKroKcgMPVexsCUIaG', 0, 15, NULL, NULL, '2024-07-29 12:41:49', '2024-07-29 12:41:49', NULL);
INSERT INTO `categories` VALUES (123, 'اسنک', 'https://api.limofood.ir/file/9FGgtXqEu2F47whZNcjRaQiDnYyEKttlUvp8jsYf', 0, 15, NULL, NULL, '2024-07-29 12:42:49', '2024-07-29 14:06:54', '2024-07-29 14:06:54');
INSERT INTO `categories` VALUES (124, 'پیتزا آمریکایی', 'https://api.limofood.ir/file/Ry55p9ECjfzTJ3lBV4sDEfXqR0MS4Hk3xM4hw8Qu', 0, 16, NULL, NULL, '2024-07-30 09:32:41', '2024-07-30 09:32:48', '2024-07-30 09:32:48');
INSERT INTO `categories` VALUES (125, 'پیتزا آمریکایی', 'https://api.limofood.ir/file/7mf5KbP1c24GMt5eNCrqg79mn3KdqjzgfbPbY6vU', 0, 16, NULL, NULL, '2024-07-30 09:32:42', '2024-07-30 09:32:42', NULL);
INSERT INTO `categories` VALUES (126, 'برگر', 'https://api.limofood.ir/file/tiiU1TlLCnSTtUGU37fJIYCVYYJo1BtixAszW9eN', 0, 16, NULL, NULL, '2024-07-30 09:33:15', '2024-07-30 09:33:15', NULL);
INSERT INTO `categories` VALUES (127, 'ساندویچ', 'https://api.limofood.ir/file/NXZCY0i4xdjpwA88REoz4yq2GZt9sqUI0q6oqDDd', 0, 16, NULL, NULL, '2024-07-30 09:33:43', '2024-07-30 09:33:43', NULL);
INSERT INTO `categories` VALUES (128, 'سوخاری', 'https://api.limofood.ir/file/DDjNBty9SrK3ruFcupKceaetgtety1VE2cHzHqPs', 0, 16, NULL, NULL, '2024-07-30 09:34:09', '2024-07-30 09:34:09', NULL);
INSERT INTO `categories` VALUES (129, 'پیش غذا', 'https://api.limofood.ir/file/fFBgn0bKoSrQvv28tQKfp9g5mbLdIxE5tvJSwtvF', 0, 16, NULL, NULL, '2024-07-30 09:35:21', '2024-07-30 09:35:21', NULL);
INSERT INTO `categories` VALUES (130, 'نوشیدنی', 'https://api.limofood.ir/file/gRBBAE7wFn0SxMJSSuLy7CdZisXq1mFipPTb6UWH', 0, 16, NULL, NULL, '2024-07-30 09:35:53', '2024-07-30 09:35:53', NULL);
INSERT INTO `categories` VALUES (131, 'چلو کباب', 'https://api.limofood.ir/file/rRH1WTpU1fnpv9FtNcCWQrsxkFBGVcTgxGLSMj8B', 0, 17, NULL, NULL, '2024-07-30 12:03:16', '2024-07-30 12:03:16', NULL);
INSERT INTO `categories` VALUES (132, 'خوراک', 'https://api.limofood.ir/file/BSXx7CjwhoxrVcCCTfynGfbqsxzHfXAZV3qyYJSI', 0, 17, NULL, NULL, '2024-07-30 12:04:03', '2024-07-30 12:04:03', NULL);
INSERT INTO `categories` VALUES (133, 'غذای ایرانی', 'https://api.limofood.ir/file/fMxV7mhd8Sx90KDnxvKvEvjE17Tuz6YhKLtZIdfv', 0, 17, NULL, NULL, '2024-07-30 12:04:45', '2024-07-30 12:04:45', NULL);
INSERT INTO `categories` VALUES (134, 'نوشیدنی', 'https://api.limofood.ir/file/nueVNKyWrkt7aW7q0LmunINmvevE2yZpxsuNuZo4', 0, 17, NULL, NULL, '2024-07-30 12:05:33', '2024-07-30 12:05:33', NULL);
INSERT INTO `categories` VALUES (135, 'نوشیدنی', 'https://api.limofood.ir/file/sVvOXciDwcC7OPxQl6VGh8mMizZYSDYFLxYHjToQ', 0, 17, NULL, NULL, '2024-07-30 12:05:34', '2024-07-30 12:05:41', '2024-07-30 12:05:41');
INSERT INTO `categories` VALUES (136, 'پنیر', 'https://api.limofood.ir/file/YpAf9X4lPW9H2eloUAmrjMMiWEybMWf70p2BEWDe', 0, 19, NULL, NULL, '2024-08-03 09:36:27', '2024-08-03 09:36:27', NULL);
INSERT INTO `categories` VALUES (137, 'شیر', 'https://api.limofood.ir/file/qmVUkisDQX0pbzEQAaAqTK90SPSWjnlHLnHXJxrB', 0, 19, NULL, NULL, '2024-08-03 09:38:21', '2024-08-03 09:38:21', NULL);
INSERT INTO `categories` VALUES (138, 'ماست', 'https://api.limofood.ir/file/CfQaX9y9ft3Sr2Nwvlt88iDMAPTFRq5rjA0VIe2I', 0, 19, NULL, NULL, '2024-08-03 09:39:57', '2024-08-03 09:39:57', NULL);
INSERT INTO `categories` VALUES (139, 'دوغ', 'https://api.limofood.ir/file/OQiwTkvKF7s0i8dvEN6oSXnqUSNsjcUsNOYhUNum', 0, 19, NULL, NULL, '2024-08-03 09:41:41', '2024-08-03 09:41:41', NULL);
INSERT INTO `categories` VALUES (140, 'پنیر پیتزا فله', 'https://api.limofood.ir/file/Kn3kBYyoTkiTAOJlvoMlvI41ipb2wfcpc2wtSsGj', 0, 19, NULL, NULL, '2024-08-03 09:43:06', '2024-08-03 09:43:16', '2024-08-03 09:43:16');
INSERT INTO `categories` VALUES (141, 'بستنی', 'https://api.limofood.ir/file/rZgLso21RgtY7AkjJpiJ04eepZYMeDx019MpRujW', 0, 20, NULL, NULL, '2024-08-03 10:50:24', '2024-08-03 10:50:24', NULL);
INSERT INTO `categories` VALUES (142, 'آبمیوه طبیعی', 'https://api.limofood.ir/file/h6CeTmftPv2ZVu9W5BtwreT9lI8xC9KHYsQr9sGU', 0, 20, NULL, NULL, '2024-08-03 10:51:17', '2024-08-03 10:51:17', NULL);
INSERT INTO `categories` VALUES (143, 'آبمیوه طبیعی', 'https://api.limofood.ir/file/pcr0jbKLgu9YOhPbNKq9TWMMbbTZkbgNMsvqN7mo', 0, 20, NULL, NULL, '2024-08-03 10:51:18', '2024-08-03 10:51:29', '2024-08-03 10:51:29');
INSERT INTO `categories` VALUES (144, 'آبمیوه ترکیبی', 'https://api.limofood.ir/file/R6avxqKlTSMHcL9C5jIXMcy8Xd6fHOnQUF2rITyk', 0, 20, NULL, NULL, '2024-08-03 10:53:40', '2024-08-03 10:53:40', NULL);
INSERT INTO `categories` VALUES (145, 'میکس شیر', 'https://api.limofood.ir/file/09WzLIUZzCw9lMXjklSTyo6IYIwiBJgsqC0xbSKX', 0, 20, NULL, NULL, '2024-08-03 10:54:48', '2024-08-03 10:54:48', NULL);
INSERT INTO `categories` VALUES (146, 'شیک', 'https://api.limofood.ir/file/lEWUMF1sLQO6WoLzwhosSp2IanpprXvZdYi60u59', 0, 20, NULL, NULL, '2024-08-03 10:56:23', '2024-08-03 10:56:23', NULL);
INSERT INTO `categories` VALUES (147, 'نوشیدنی گرم', 'https://api.limofood.ir/file/7n4lMSRN7TwRAnJqhAgnWeNEMQNCRRylHm2rMR6n', 0, 20, NULL, NULL, '2024-08-03 10:58:11', '2024-08-03 10:58:11', NULL);
INSERT INTO `categories` VALUES (148, 'قهوه', 'https://api.limofood.ir/file/eekhgOY5sF43cZG6u3JhYEeKdj4k5GutoHwftMzh', 0, 20, NULL, NULL, '2024-08-03 10:59:30', '2024-08-03 10:59:30', NULL);
INSERT INTO `categories` VALUES (149, 'عرقیجات', 'https://api.limofood.ir/file/1n7bKITmJYYax7eEsfpICEqxv21cFzVpTL22zWbV', 0, 20, NULL, NULL, '2024-08-03 11:00:21', '2024-08-03 11:00:21', NULL);
INSERT INTO `categories` VALUES (150, 'چای و دمنوش', 'https://api.limofood.ir/file/JlGJm4pFD6nZBVj7tDuSeGTTW9H0x5OfRk9UyE9y', 0, 20, NULL, NULL, '2024-08-03 11:01:14', '2024-08-03 11:01:14', NULL);
INSERT INTO `categories` VALUES (151, 'آبمیوه بستنی', 'https://api.limofood.ir/file/TGcPitCVAFi0kD3tDmfAOl2cPNAluUmMw72dCGzB', 0, 20, NULL, NULL, '2024-08-03 11:03:48', '2024-08-03 11:03:48', NULL);
INSERT INTO `categories` VALUES (152, 'کیک', 'https://api.limofood.ir/file/CxLXACxvXa9TEVYouEfbGTxjAYEpkK87C4JZ63LS', 0, 20, NULL, NULL, '2024-08-03 11:05:35', '2024-08-03 11:05:35', NULL);
INSERT INTO `categories` VALUES (153, 'میان وعده', 'https://api.limofood.ir/file/Tt5Xpdltf2TCg1LYSAQ3GvlZMflnV7fHB3D8ZQ5i', 0, 20, NULL, NULL, '2024-08-03 11:06:46', '2024-08-03 11:06:46', NULL);
INSERT INTO `categories` VALUES (154, 'نوشیدنی', 'https://api.limofood.ir/file/OwSnuE98DgB230N2vNmCrrIPWcWeqhvVqo6emwQI', 0, 20, NULL, NULL, '2024-08-03 11:07:40', '2024-08-03 11:07:40', NULL);
INSERT INTO `categories` VALUES (155, 'تست', 'http://localhost/file/vWpF4McjgofCMxUKtrij1Sp0DPUW4sXfeup6eZMh', 0, 1, NULL, NULL, '2024-09-20 18:34:35', '2024-09-20 18:34:35', NULL);
INSERT INTO `categories` VALUES (156, 'jsj', 'http://localhost/file/AsSYToBYKRPRGdexnp6A9EfsplImoBkOQgksQmOE', 0, 1, '11:02:00', '12:41:00', '2024-09-20 18:38:46', '2024-09-20 18:38:46', NULL);
INSERT INTO `categories` VALUES (157, 'cscsdcsd', 'http://localhost/file/yq5GjloT1vdmppMbvoVkbCDbqsj5TRig6k5zXSB6', 0, 1, '08:41:00', '09:39:00', '2024-09-20 18:39:16', '2024-09-20 18:39:16', NULL);
INSERT INTO `categories` VALUES (158, 'we', 'http://localhost/file/rHXeVeVZxZnifqi5Kji22K66DPKmy5i8irH8n7Nc', 0, 1, NULL, NULL, '2024-09-20 18:40:11', '2024-09-20 18:42:19', NULL);

-- ----------------------------
-- Table structure for charge_wallets
-- ----------------------------
DROP TABLE IF EXISTS `charge_wallets`;
CREATE TABLE `charge_wallets`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `amount` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `code_pay` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `payment_code_gateway` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `status` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT 'false',
  `created_at` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 55 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of charge_wallets
-- ----------------------------
INSERT INTO `charge_wallets` VALUES (1, 1, '15000', 'USvSsw9SDyq0bG0KF0NPy8NIAz47tmeh6YJS0u6U', 'A00000000000000000000000000492248847', 'false', '2024-01-03 19:59:35', '2024-01-03 16:29:35', NULL);
INSERT INTO `charge_wallets` VALUES (2, 1, '15000', 'B4IzH8mkSprUH7P87fpDCHhgzBacDudMc9Aq38Vt', NULL, 'false', '2024-01-03 18:24:07', '2024-01-03 18:24:07', NULL);
INSERT INTO `charge_wallets` VALUES (3, 4, '15000', 'kTxpilx5ixy6YnMIIOPoc1tzADKRPOuhWXeHP8H2', NULL, 'false', '2024-01-05 20:46:34', '2024-01-05 20:46:34', NULL);
INSERT INTO `charge_wallets` VALUES (4, 4, '5000', 'jujdnoh2eYZgMdaUWFHuNXD5xZWyEZRmXyfBOJZM', 'A00000000000000000000000000492913023', 'false', '2024-01-06 00:26:33', '2024-01-05 20:56:33', NULL);
INSERT INTO `charge_wallets` VALUES (5, 4, '5000', 'ic35lWm9gbzDAdSQvyXBUZyOE8uUS3Q6mxpSkcEw', 'A00000000000000000000000000492913222', 'false', '2024-01-06 00:27:21', '2024-01-05 20:57:21', NULL);
INSERT INTO `charge_wallets` VALUES (6, 3, '50000', 'pEBUoHhSu5yPwp6JG47UNX1moF2mK7F5rb0IYkkq', 'A00000000000000000000000000495122658', 'false', '2024-01-12 11:48:02', '2024-01-12 08:18:02', NULL);
INSERT INTO `charge_wallets` VALUES (7, 43, '5004', 'kIbsXaRGMS2VEkp2FVLeOdI4TLvS6ZMBGJ0ymkGp', 'A00000000000000000000000000495241959', 'false', '2024-01-12 18:54:58', '2024-01-12 15:24:58', NULL);
INSERT INTO `charge_wallets` VALUES (8, 56, '5000', 'G39h7pMiKO8GnTpb8hndEzXfjdfGkZyCjJBqkNEq', 'A00000000000000000000000000005rwM3OP', 'false', '2024-02-10 12:35:11', '2024-02-10 09:05:11', NULL);
INSERT INTO `charge_wallets` VALUES (9, 54, '5000', 'nzcBRg0rLqORq3FpWFh1nZ6B2nCCxT2UyUmZVzyX', 'A0000000000000000000000000000PEQKKK5', 'false', '2024-02-17 11:17:54', '2024-02-17 11:17:54', NULL);
INSERT INTO `charge_wallets` VALUES (10, 4, '5000', 'JX9D5lcNDlKSCTE75Cbxk4wJPaaVUw5RK0tsy30t', 'A000000000000000000000000000vw8yyl3e', 'false', '2024-03-09 12:53:27', '2024-03-09 09:23:27', NULL);
INSERT INTO `charge_wallets` VALUES (11, 59, '5000', 'IAUMcVHHIS1nxM63vXmBvC6V8hfYfMhXQ8MT8lHp', 'A000000000000000000000000000m123m8lv', 'false', '2024-04-08 23:58:48', '2024-04-08 20:28:48', NULL);
INSERT INTO `charge_wallets` VALUES (12, 60, '5000', 'L3mTprBnnK1BBEpQpApYgqvWR7ItWPrZfqRR6oLK', 'A000000000000000000000000000zvnp1j1p', 'false', '2024-07-25 13:13:18', '2024-07-25 13:13:18', NULL);
INSERT INTO `charge_wallets` VALUES (13, 2, '5000', '3iK9DPGLvASyY8kqCKvqs68wOWym2oGUGQ6tZXOV', 'A000000000000000000000000000j38j1yw5', 'false', '2024-07-27 14:09:46', '2024-07-27 14:09:46', NULL);
INSERT INTO `charge_wallets` VALUES (14, 99, '5000', 'yGu7R2YiBfFD8hdJSzOffboHV6D9kxgEswoTU4Al', 'A00000000000000000000000000015vdxpom', 'false', '2024-08-04 23:08:50', '2024-08-04 23:08:50', NULL);
INSERT INTO `charge_wallets` VALUES (54, 2, '2115000', 'uuSvAvGkdn', 'wallet', 'true', '2025-06-27 18:34:36', '2025-06-27 18:34:36', NULL);

-- ----------------------------
-- Table structure for comments
-- ----------------------------
DROP TABLE IF EXISTS `comments`;
CREATE TABLE `comments`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `user_id` int NOT NULL,
  `rate` float NOT NULL DEFAULT 0,
  `products` json NULL COMMENT '{{\'id\':\'1\',\'title\':\'مرغ سوخاری\'}}',
  `branch_id` int NULL DEFAULT 0,
  `order_id` int NOT NULL DEFAULT 0,
  `parent_id` int NOT NULL DEFAULT 0,
  `created_at` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of comments
-- ----------------------------
INSERT INTO `comments` VALUES (3, 'متن پیغام', 4, 3.5, '[{\"rate\": \"3.5\", \"title\": \"قورمه سبزی با سالاد شیرازی\", \"variety_id\": 55}, {\"rate\": \"3.5\", \"title\": \"کوکو سبزی با زرشک و گردو\", \"variety_id\": 54}]', 1, 11, 0, '2023-12-27 18:15:40', '2023-12-27 18:15:40', NULL);
INSERT INTO `comments` VALUES (4, 'csdcsdcdscsd', 3, 0, NULL, 0, 0, 1, '2024-01-05 11:07:42', '2024-01-05 11:07:42', NULL);
INSERT INTO `comments` VALUES (5, 'جواب', 3, 0, NULL, 0, 0, 2, '2024-01-31 16:12:46', '2024-01-31 16:12:46', NULL);
INSERT INTO `comments` VALUES (6, 'پاسخ داده شد', 3, 0, NULL, 0, 0, 2, '2024-01-31 16:13:36', '2024-01-31 16:13:36', NULL);
INSERT INTO `comments` VALUES (7, 'پاسخ', 3, 0, NULL, 0, 0, 1, '2024-03-21 07:35:32', '2024-03-21 07:35:32', NULL);
INSERT INTO `comments` VALUES (8, 'تست', 1, 0, NULL, 1, 0, 1, '2024-07-14 09:21:07', '2024-07-14 09:21:07', NULL);

-- ----------------------------
-- Table structure for components
-- ----------------------------
DROP TABLE IF EXISTS `components`;
CREATE TABLE `components`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `name_component` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` enum('home') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'home',
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `filter` json NULL,
  `extra` json NULL,
  `order` int NOT NULL,
  `is_request` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` enum('header','main','footer') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'main',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `components_code_unique`(`code`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 33 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of components
-- ----------------------------
INSERT INTO `components` VALUES (1, 'DiscountProductType1', 'home', 'csdcsmdkcm25454', '{\"order_by\": \"desc\", \"branch_id\": \"2\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/uploads/06-01-2025-TRSKKfysEsFRuzUK1Ok7LgcNqhgrdVuz.png\", \"title\": \"تخفیف های بیشتر\", \"link_more\": \"http://demo.limofood.ir/\", \"btn_text_more\": \"مشاهده همه\", \"background_color\": \"#c20000\"}', 3, 'true', 'main', NULL, NULL, '2025-01-06 19:05:21');
INSERT INTO `components` VALUES (30, 'ProductSliderType1', 'home', 'ZjjScQnmmq', '{\"order_by\": \"desc\", \"branch_id\": \"20\", \"order_by_field\": \"id\"}', '{\"title\": \"تایمن\", \"link_more\": \"http://demo.limofood.ir/\", \"btn_text_more\": \"مشاهده همه\"}', 50, 'true', 'main', NULL, '2024-09-30 20:22:48', '2024-09-30 20:22:58');
INSERT INTO `components` VALUES (4, 'ProductSliderType2', 'home', 'csdcsmdkcm25454235', NULL, '{\"title\": \"تخفیف های بیشتر\", \"link-more\": \"/\", \"title-more\": \"مشاهده بیشتر\"}', 11, 'true', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (5, 'ProductSliderType3', 'home', 'csdcsmdkcm254542358', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"title\": \"تخفیف های بیشتر\", \"link_more\": \"http://demo.limofood.ir/\", \"btn_text_more\": \"مشاهده همه\"}', 10, 'true', 'main', NULL, NULL, '2024-09-30 16:12:57');
INSERT INTO `components` VALUES (6, 'SingleSlider', 'home', 'csdcsmdkcm254542357', NULL, '{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}', 9, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (8, 'TripleSlider', 'home', 'csdcsmdkcm25454234', NULL, '[{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}]', 2, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (9, 'FourthSlider', 'home', 'csdcsmdkcm2545428', NULL, '[{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}]', 15, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (32, 'RegisterSeller1', 'home', 'bOzmDv8kKY', NULL, '{\"text\": \"توضیح\", \"image\": \"http://localhost/uploads/06-01-2025-H8NouOr3RjKGHfumiXWR7MA3qIOOUXsx.png\", \"title\": \"ثبت نام\", \"btn_text\": \"زسیزیس\", \"sub_description\": \"توضیح\"}', 1, 'true', 'main', NULL, '2025-01-06 18:45:38', '2025-01-06 19:14:46');
INSERT INTO `components` VALUES (11, 'SixSlider', 'home', 'csdcsmdkcm25855400', NULL, '[{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}]', 6, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (14, 'TripleBanner', 'home', 'csdcsm0024cd3s1c3', NULL, '[{\"link\": \"http://demo.limofood.ir/\", \"image\": \"http://limoofood-api2.ii/file/n2WojToFMuRaeNtOqzbD8HL58EvizRk9NImZW0hb\", \"title\": \"زیزس\"}, {\"link\": \"http://demo.limofood.ir/\", \"image\": \"http://limoofood-api2.ii/file/pQzQ95YFObYF084zEB0j8PJvf00KZ6aG7rMcG8RZ\", \"title\": \"زیزیسیزس\"}, {\"link\": \"http://demo.limofood.ir/\", \"image\": \"http://limoofood-api2.ii/file/sZkhKfXelzzNNiLi6RObOD9qV9Y0XMsfpsbcmTc6\", \"title\": \"زیزیسیزس\"}]', 8, 'false', 'main', NULL, NULL, '2024-09-30 16:23:08');
INSERT INTO `components` VALUES (15, 'FourthBanner', 'home', 'csdcsm0csd5c13511c3', NULL, '[{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}]', 7, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (17, 'SixBanner', 'home', 'csdcsm0c2csdcds5213851c3', NULL, '[{\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}, {\"image\": \"https://api2.limofood.ir/file/zxCO5qyczNNtibeUSyRNo7YiTkAAWCWnCb31R7Oe\", \"title\": \"بنر\"}]', 4, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (18, 'SellerSliderType1', 'home', 'csdcsm0c2csdcds521321353851c3', NULL, '{\"title\": \"تامین کنندگان برتر\", \"link-more\": \"/\", \"title-more\": \"مشاهده بیشتر\"}', 5, 'false', 'main', NULL, NULL, NULL);
INSERT INTO `components` VALUES (19, 'DiscountProductType1', 'home', 'csdcsmdkcm51351325454', '{\"order_by\": \"desc\", \"category_id\": \"6\", \"order_by_field\": \"id\"}', '{\"image\": \"http://limoofood-api2.ii/file/JUcjGnCzycm0jqva3UXrBQ8q8OMwCJTswy6cR6AR\", \"title\": \"تخفیف های بیشتر\", \"link_more\": \"https://demo.limofood.ir/chefs?category=38\", \"btn_text_more\": \"مشاهده همه\", \"background_color\": \"#dd2222\"}', 30, 'true', 'main', NULL, NULL, '2024-09-30 14:33:17');
INSERT INTO `components` VALUES (20, 'SellerSliderType1', 'home', 'csdcsm0c2csdcd51351s521321353851c3', '{\"sort_type\": \"desc\", \"sort_column\": \"id\"}', '{\"title\": \"تامین کنندگان برتر\", \"link_more\": \"http://demo.limofood.ir/\", \"btn_text_more\": \"مشاهده همه\"}', 3, 'true', 'main', NULL, NULL, '2024-09-30 16:21:50');
INSERT INTO `components` VALUES (21, 'DiscountProductType1', 'home', 'YEj9b8XnWo', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/AGdVd5NX0hzfPXzyt9GANzvGcDHCKtJvE1UDtXbG\", \"title\": \"cdscsdc\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"csdcsdcsd\", \"background-color\": \"#f50000\"}', 1, 'true', 'header', NULL, '2024-09-29 13:40:22', '2024-09-29 13:40:22');
INSERT INTO `components` VALUES (22, 'DiscountProductType1', 'home', 'hVLhOe108i', '{\"order_by\": \"desc\", \"category_id\": \"34\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/GzKj7Jk2iwFFNw0iURdJaYcpXzHU5zpE8RcV2Q8A\", \"title\": \"cdscds\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"cdscds\", \"background-color\": \"#cb1010\"}', 1, 'true', 'header', NULL, '2024-09-29 13:42:05', '2024-09-29 13:42:05');
INSERT INTO `components` VALUES (23, 'DiscountProductType1', 'home', 'fkCMtlo99a', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/aWqqWk7SaYY4KLMWFzCBmklxQQ9DZw5bwUZTvPcj\", \"title\": \"csdcds\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"cdscds\", \"background-color\": \"#bb3030\"}', 1, 'true', 'header', NULL, '2024-09-29 13:44:05', '2024-09-29 13:44:05');
INSERT INTO `components` VALUES (24, 'DiscountProductType1', 'home', 'Vz0wna0q0q', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/GhI1DGQnpH5x6BYWXbBkKFIjNgWSCiUuQgEq6g4j\", \"title\": \"csdcds\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"cdscds\", \"background-color\": \"#bb3030\"}', 1, 'true', 'header', NULL, '2024-09-29 13:45:41', '2024-09-29 13:45:41');
INSERT INTO `components` VALUES (25, 'DiscountProductType1', 'home', 'rsTZADFgcw', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/cBe6Nugs7DqVBBCJfI9rtCqbBBoWRloLBpiTnis9\", \"title\": \"csdcds\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"cdscds\", \"background-color\": \"#bb3030\"}', 1, 'true', 'header', NULL, '2024-09-29 13:46:01', '2024-09-29 13:46:01');
INSERT INTO `components` VALUES (26, 'DiscountProductType1', 'home', '2aolDweUl4', '{\"order_by\": \"desc\", \"order_by_field\": \"id\"}', '{\"image\": \"http://localhost/file/dxAvaaGdxtdtgHeNVkC7XiTgmRG1g7mc7NaEDHwr\", \"title\": \"csdcds\", \"link-more\": \"http://limofood-panel2.ii/admin/component/create/DiscountProductType1\", \"btn-text-more\": \"cdscds\", \"background-color\": \"#bb3030\"}', 1, 'true', 'header', NULL, '2024-09-29 13:48:08', '2024-09-29 13:48:08');
INSERT INTO `components` VALUES (27, 'SingleSlider', 'home', 'Z9RV3uGhtb', NULL, '[{\"link\": \"http://limofood-panel2.ii/admin/component/create/SingleSlider\", \"image\": \"http://localhost/file/m9TxXULYRxJbxEOT0MMshbPsJAr6vmCKi28rKFcd\", \"title\": \"cdscsdcds\"}, {\"link\": \"http://limofood-panel2.ii/admin/component/create/SingleSlider\", \"image\": \"http://localhost/file/J6YWi4AvtWXZQWIatt2WWYXqoeOz2pSldB0wU4DB\", \"title\": \"csdcdscsd\"}]', 1, 'true', 'header', NULL, '2024-09-29 17:00:55', '2024-09-29 17:00:55');
INSERT INTO `components` VALUES (28, 'DoubleSlider', 'home', '0XYqOSKBhq', NULL, '[{\"link\": \"http://limofood-panel2.ii/admin/component/create/DoubleSlider\", \"image\": \"http://localhost/file/PS0TgYi2X26UKuEwUdiLsc0MvtWq35dEBsjVM0RT\", \"title\": \"csdcsdcds\"}, {\"link\": \"http://limofood-panel2.ii/admin/component/create/DoubleSlider\", \"image\": \"http://localhost/file/l9pTzhewb0IXdAtLbbW8igJ6dRE7c3eei5gK7Irr\", \"title\": \"cdscdscsd\"}]', 150, 'true', 'header', NULL, '2024-09-29 17:04:12', '2024-09-29 17:04:12');

-- ----------------------------
-- Table structure for coupon_branches
-- ----------------------------
DROP TABLE IF EXISTS `coupon_branches`;
CREATE TABLE `coupon_branches`  (
  `coupon_id` int NOT NULL,
  `branch_id` int NOT NULL,
  `crated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`coupon_id`, `branch_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of coupon_branches
-- ----------------------------

-- ----------------------------
-- Table structure for coupon_users
-- ----------------------------
DROP TABLE IF EXISTS `coupon_users`;
CREATE TABLE `coupon_users`  (
  `coupon_id` int NOT NULL,
  `user_id` int NOT NULL,
  `used` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL DEFAULT 'false',
  `order_id` int NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `used_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`coupon_id`, `user_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of coupon_users
-- ----------------------------

-- ----------------------------
-- Table structure for coupons
-- ----------------------------
DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_id` int UNSIGNED NOT NULL DEFAULT 0,
  `type` int NOT NULL DEFAULT 1 COMMENT '0 - Fixed, 1 - Percentage',
  `percent` int NOT NULL,
  `price` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `active_from` datetime NOT NULL,
  `active_to` datetime NOT NULL,
  `limit_uses` int NOT NULL COMMENT 'محدودیت استفاده ',
  `limit_user` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `limit_branch` enum('true','false') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'false',
  `used_count` int NOT NULL,
  `max_price_discount` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'سقف تخفیف',
  `min_price_order` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT 'حداقل خرید برای اعمال تخفیف',
  `condition_type` enum('count-order','after-rate','after-order','public') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  `percent_system` int NOT NULL DEFAULT 0,
  `percent_branch` int NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = COMPACT;

-- ----------------------------
-- Records of coupons
-- ----------------------------
INSERT INTO `coupons` VALUES (1, 'تست ', '1234', 1, 1, 2, '', '2024-01-25 00:00:00', '2024-01-31 00:00:00', 5, 'false', 'false', 0, '10000000000', '1000', 'public', 0, 0, '2023-12-22 14:23:16', '2024-07-24 09:02:01', '2024-07-24 09:02:01');
INSERT INTO `coupons` VALUES (2, 'تست ', '12342', 1, 1, 2, '', '2024-01-25 00:00:00', '2024-01-31 00:00:00', 5, 'false', 'false', 0, '10000000000', '1000', 'public', 0, 0, '2023-12-22 14:23:16', '2024-07-24 09:02:06', '2024-07-24 09:02:06');
INSERT INTO `coupons` VALUES (3, 'تست ', '12842', 1, 1, 2, '', '2024-01-26 00:00:00', '2024-01-31 00:00:00', 5, 'false', 'false', 0, '10000000000', '1000', 'public', 0, 0, '2023-12-22 14:23:16', '2024-02-05 18:31:50', '2024-02-05 18:31:50');
INSERT INTO `coupons` VALUES (6, 'تشست', '5135d1cs', 0, 1, 60, '0', '2024-02-05 00:00:00', '2024-02-13 00:00:00', 0, '', '', 60, '100000', '10000', 'public', 40, 60, '2024-02-05 18:05:39', '2024-07-24 09:02:09', '2024-07-24 09:02:09');
INSERT INTO `coupons` VALUES (7, 'تخفیف ویژه', 'takhfif', 0, 1, 10, '0', '2024-07-22 00:00:00', '2024-08-11 00:00:00', 1, '', '', 1000, '10000', '100000', 'public', 0, 100, '2024-07-24 09:01:54', '2024-07-24 09:02:15', '2024-07-24 09:02:15');
INSERT INTO `coupons` VALUES (8, 'bhvj2hvh', 'bhbjhbv', 0, 1, 47, '0', '2024-06-30 00:00:00', '2024-08-04 00:00:00', 67, '', '', 79, '576577', '58888', 'public', 0, 100, '2024-07-27 09:52:26', '2024-07-27 09:54:34', '2024-07-27 09:54:34');
INSERT INTO `coupons` VALUES (9, '02552223', '0500', 0, 1, 20, '0', '2024-07-27 00:00:00', '2024-08-19 00:00:00', 100, '', '', 0, '10000', '100000', 'public', 20, 80, '2024-07-27 09:57:01', '2024-07-27 09:57:05', '2024-07-27 09:57:05');

-- ----------------------------
-- Table structure for delivery_types
-- ----------------------------
DROP TABLE IF EXISTS `delivery_types`;
CREATE TABLE `delivery_types`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `is_address` tinyint(1) NULL DEFAULT 1,
  `description_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `description_required` tinyint(1) NOT NULL DEFAULT 0,
  `description_error_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `is_active` tinyint(1) NULL DEFAULT 1,
  `message` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `delivery_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of delivery_types
-- ----------------------------
INSERT INTO `delivery_types` VALUES (1, 'درب پارکنیگ', 0, 'لطفا پلاک و نوع ماشین را وارد کنید', 1, 'لطفا پلاک و نوع ماشین را وارد کنید', 1, NULL, '2024-07-13 20:07:30', '2024-07-12 19:47:32', NULL, NULL);
INSERT INTO `delivery_types` VALUES (2, 'پیک', 1, 'توضیحات سفارش را وارد کنید', 1, 'توضیحات سفارش را وارد کنید', 1, NULL, '2024-07-06 17:52:44', '2024-07-06 17:52:44', NULL, NULL);
INSERT INTO `delivery_types` VALUES (3, 'سرو در رستوران', 0, 'لطفا در صورت حضور در رستوران شماره میز را وارد کنید', 0, NULL, 1, 'در صورت نبودن شما در رستوران ممکن است در صورت پر بودن میز منتظر بمانید', '2025-06-09 22:19:28', '2025-06-09 22:19:28', NULL, NULL);
INSERT INTO `delivery_types` VALUES (4, 'دریافت حضوری', 0, 'لطفا توضیحات خود را وارد کنید ', 0, NULL, 1, NULL, '2024-07-13 20:07:35', '2024-07-12 21:01:35', NULL, NULL);
INSERT INTO `delivery_types` VALUES (6, 'روش 4', 1, 'متن باکس', 1, 'متن ارور', 1, 'پیغام', '2025-06-09 15:43:51', '2025-06-09 15:39:39', NULL, NULL);
INSERT INTO `delivery_types` VALUES (7, 'پیک پلتفرم', 1, '122', 0, '123321', 1, '231312123', '2025-06-09 15:44:19', '2025-06-09 15:44:19', NULL, NULL);
INSERT INTO `delivery_types` VALUES (8, 'روش 4', 1, 'متن باکس', 1, 'متن ارور', 1, 'پیغام', '2025-06-09 23:30:02', '2025-06-09 23:30:02', NULL, NULL);

-- ----------------------------
-- Table structure for export_imports
-- ----------------------------
DROP TABLE IF EXISTS `export_imports`;
CREATE TABLE `export_imports`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `type` enum('import','export') CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 30 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of export_imports
-- ----------------------------
INSERT INTO `export_imports` VALUES (17, 'https://api2.limofood.ir/excel/vpLSsx8Y0mto9BHD.xlsx', 'export', '2024-07-27 10:06:52', '2024-07-27 10:06:52', NULL);
INSERT INTO `export_imports` VALUES (18, 'https://api2.limofood.ir/excel/CJaiio9udAdFXGRh.xlsx', 'export', '2024-07-27 10:06:52', '2024-07-27 10:06:52', NULL);
INSERT INTO `export_imports` VALUES (19, 'https://api2.limofood.ir/excel/PFUZQtBXPP4Fq7sI.xlsx', 'export', '2024-07-27 10:10:22', '2024-07-27 10:10:22', NULL);
INSERT INTO `export_imports` VALUES (20, 'https://api2.limofood.ir/excel/aPeGSQevSlBp9G4Y.xlsx', 'export', '2024-07-27 10:10:22', '2024-07-27 10:10:22', NULL);
INSERT INTO `export_imports` VALUES (21, 'https://api2.limofood.ir/excel/Bixtf4NRwxHzrqXc.xlsx', 'export', '2024-07-27 10:20:53', '2024-07-27 10:20:53', NULL);
INSERT INTO `export_imports` VALUES (22, 'https://api2.limofood.ir/excel/nosuZwBy3odPSJvv.xlsx', 'export', '2024-07-27 10:20:54', '2024-07-27 10:20:54', NULL);
INSERT INTO `export_imports` VALUES (23, 'https://api2.limofood.ir/excel/KpkOSXWDXFpG9WXM.xlsx', 'export', '2024-07-27 10:20:54', '2024-07-27 10:20:54', NULL);
INSERT INTO `export_imports` VALUES (24, 'https://api2.limofood.ir/excel/hE7OSWPDf5jlIE9R.xlsx', 'export', '2024-07-27 10:20:54', '2024-07-27 10:20:54', NULL);
INSERT INTO `export_imports` VALUES (25, 'https://api2.limofood.ir/excel/sbz071s7CejTcM66.xlsx', 'export', '2024-07-27 10:25:56', '2024-07-27 10:25:56', NULL);
INSERT INTO `export_imports` VALUES (26, 'https://api2.limofood.ir/excel/DzttP2K1HuPdvXFU.xlsx', 'export', '2024-07-27 10:25:56', '2024-07-27 10:25:56', NULL);
INSERT INTO `export_imports` VALUES (27, 'https://api.limofood.ir/excel/Ev9W3A89VC41Pyge.xlsx', 'export', '2024-08-06 20:21:02', '2024-08-06 20:21:02', NULL);
INSERT INTO `export_imports` VALUES (28, 'http://localhost/excel/ltEFylfdqXByEAFw.xlsx', 'export', '2024-10-16 14:12:39', '2024-10-16 14:12:39', NULL);
INSERT INTO `export_imports` VALUES (29, 'http://localhost/excel/rGmi6E8wzsA5qVx9.xlsx', 'export', '2024-10-16 14:12:42', '2024-10-16 14:12:42', NULL);

-- ----------------------------
-- Table structure for extra_types
-- ----------------------------
DROP TABLE IF EXISTS `extra_types`;
CREATE TABLE `extra_types`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NULL DEFAULT NULL,
  `branch_id` int NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `branch`(`branch_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 31 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of extra_types
-- ----------------------------
INSERT INTO `extra_types` VALUES (1, 'سس ها', 1);
INSERT INTO `extra_types` VALUES (2, 'تک نفره', 1);
INSERT INTO `extra_types` VALUES (3, 'تک نفره', 1);
INSERT INTO `extra_types` VALUES (4, 'تست اپدیت', 1);
INSERT INTO `extra_types` VALUES (5, 'تست دوم', 1);
INSERT INTO `extra_types` VALUES (7, 'درج گروه بندی', 1);
INSERT INTO `extra_types` VALUES (10, 'چرت', 2);
INSERT INTO `extra_types` VALUES (9, 'سس ها', 2);
INSERT INTO `extra_types` VALUES (19, 'سس ها', 4);
INSERT INTO `extra_types` VALUES (20, 'ییقلیقعفغتا', 1);
INSERT INTO `extra_types` VALUES (21, 'داقفعافقغا', 1);
INSERT INTO `extra_types` VALUES (22, 'ففیبل', 1);
INSERT INTO `extra_types` VALUES (23, 'افقافداتمقفتن', 1);
INSERT INTO `extra_types` VALUES (24, 'فست فود', 1);
INSERT INTO `extra_types` VALUES (25, 'لتبفتت', 1);
INSERT INTO `extra_types` VALUES (26, 'تست', 1);
INSERT INTO `extra_types` VALUES (27, 'تست', 1);
INSERT INTO `extra_types` VALUES (28, 'تست', 1);
INSERT INTO `extra_types` VALUES (29, 'فافبغت', 1);
INSERT INTO `extra_types` VALUES (30, 'شیبل', 1);

-- ----------------------------
-- Table structure for extras
-- ----------------------------
DROP TABLE IF EXISTS `extras`;
CREATE TABLE `extras`  (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `price` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `branch_id` int NOT NULL,
  `extra_type_id` int NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_persian_ci NOT NULL,
  `created_at` datetime NOT NULL ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` datetime NULL DEFAULT NULL,
  `deleted_at` datetime NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `branch`(`branch_id`) USING BTREE,
  INDEX `type`(`extra_type_id`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 7 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_persian_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of extras
-- ----------------------------
INSERT INTO `extras` VALUES (1, 'سس کچاپ', '12000', 1, 1, 'توضیحات', '2024-02-09 17:04:17', '2024-02-09 13:34:17', NULL);
INSERT INTO `extras` VALUES (2, 'نان', '2000', 1, 1, '', '2024-02-09 17:04:31', '2024-02-09 13:34:31', '2024-02-09 13:34:31');
INSERT INTO `extras` VALUES (3, 'نان باکت', '150000', 1, 1, '', '2023-12-26 22:49:31', '2023-12-16 18:00:19', NULL);
INSERT INTO `extras` VALUES (4, 'مواد اضافه یک2', '15000', 2, 8, 'توضیحات', '2024-01-19 22:16:20', '2024-01-19 18:46:20', '2024-01-19 18:46:20');
INSERT INTO `extras` VALUES (5, 'سس کچاپ', '1500', 2, 9, 'توضیحات', '2024-02-09 12:50:00', '2024-02-09 12:50:00', NULL);
INSERT INTO `extras` VALUES (6, 'سس ویژه', '15000', 1, 1, 'سس ویژه', '2024-03-21 07:33:41', '2024-03-21 07:33:41', NULL);

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs`  (
  `id` bigint UNSIGNED NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `failed_jobs_uuid_unique`(`uuid`) USING BTREE
) ENGINE = MyISAM AUTO_INCREMENT = 62 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = DYNAMIC;

-- ----------------------------
-- Records of failed_jobs
-- ----------------------------
INSERT INTO `failed_jobs` VALUES (1, '38fc6abe-012a-4605-b0a4-294445659a1b', 'database', 'default', '{\"uuid\":\"38fc6abe-012a-4605-b0a4-294445659a1b\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550257&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=197c4a095fd1d628cb773f0d686624a34eea7f4c1c64bb9cb1b986664340efa8 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:20:59');
INSERT INTO `failed_jobs` VALUES (2, 'a827f543-13a7-426e-9b03-5d9d1a4b1d82', 'database', 'default', '{\"uuid\":\"a827f543-13a7-426e-9b03-5d9d1a4b1d82\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550259&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=2800d545691f120d9bcb2e028af007fa9d6c6dc42ab3d9db11e609e255c5de91 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:00');
INSERT INTO `failed_jobs` VALUES (3, '18579667-c91d-47fa-b42c-aec1835b13af', 'database', 'default', '{\"uuid\":\"18579667-c91d-47fa-b42c-aec1835b13af\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550260&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=a2477c5c2e4dc83c424bdb083353d4fcf11e4b11c6b83f796cb6995645780407 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:01');
INSERT INTO `failed_jobs` VALUES (4, 'd37ee063-9012-4e5d-ba31-3bee028d777e', 'database', 'default', '{\"uuid\":\"d37ee063-9012-4e5d-ba31-3bee028d777e\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550261&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=644fbbaac0b52f06c2f3841f2489aaa8e3f1e9269f92effaafd189a4d0a2d30b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:01');
INSERT INTO `failed_jobs` VALUES (5, '834e7f6a-10cb-4497-bb59-4326d390fb20', 'database', 'default', '{\"uuid\":\"834e7f6a-10cb-4497-bb59-4326d390fb20\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550261&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=644fbbaac0b52f06c2f3841f2489aaa8e3f1e9269f92effaafd189a4d0a2d30b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:02');
INSERT INTO `failed_jobs` VALUES (6, '2bcdcc69-46c8-4d35-b5f6-2f1080eafdc1', 'database', 'default', '{\"uuid\":\"2bcdcc69-46c8-4d35-b5f6-2f1080eafdc1\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550262&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=1c639817dea271f98a99002299f4880592613ba648895ac0b554c3b0aab6b78b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:02');
INSERT INTO `failed_jobs` VALUES (7, '0e12185d-5488-417f-9f3f-2e51e9f70dd0', 'database', 'default', '{\"uuid\":\"0e12185d-5488-417f-9f3f-2e51e9f70dd0\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550262&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=1c639817dea271f98a99002299f4880592613ba648895ac0b554c3b0aab6b78b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:03');
INSERT INTO `failed_jobs` VALUES (8, '8af899dd-1767-47d4-8cdc-e230075a27f0', 'database', 'default', '{\"uuid\":\"8af899dd-1767-47d4-8cdc-e230075a27f0\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550263&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=155d8ee256103743be56154cdc7f5e4b4a54c7e8ecfab3e826d3af46c5f3dade in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:04');
INSERT INTO `failed_jobs` VALUES (9, '7ff8a13b-6406-4fda-a579-607049c7dbfb', 'database', 'default', '{\"uuid\":\"7ff8a13b-6406-4fda-a579-607049c7dbfb\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550264&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=ad152a7b0152634e26b5da32a4b486c378ce3349e6661add435772c04be24268 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:04');
INSERT INTO `failed_jobs` VALUES (10, '76a07924-6387-431e-a752-81ce555370d6', 'database', 'default', '{\"uuid\":\"76a07924-6387-431e-a752-81ce555370d6\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550264&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=ad152a7b0152634e26b5da32a4b486c378ce3349e6661add435772c04be24268 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:05');
INSERT INTO `failed_jobs` VALUES (11, '489d3eeb-6064-48f7-afd8-7a84ac4027bd', 'database', 'default', '{\"uuid\":\"489d3eeb-6064-48f7-afd8-7a84ac4027bd\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:4:\\\"data\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550265&auth_version=1.0&body_md5=8fd2366bdd98030f833cd83ddcfe7250&auth_signature=60e151378c0e62758d2a46296eeca93a033045412d443184313b64a2a02f4d05 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:05');
INSERT INTO `failed_jobs` VALUES (12, 'c069969a-3a87-4805-a668-dd1fc3a6cb71', 'database', 'default', '{\"uuid\":\"c069969a-3a87-4805-a668-dd1fc3a6cb71\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550265&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=a11e9209367fab7933a377a07c49199e36e85cb6f20c2d1b9c9714a53a6a7bf0 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:06');
INSERT INTO `failed_jobs` VALUES (13, 'b8129e2d-273d-4bcb-9239-b524eee61aa3', 'database', 'default', '{\"uuid\":\"b8129e2d-273d-4bcb-9239-b524eee61aa3\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550266&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=b5f5f1fec06940809c62b9435755a4fe45bf1b2745d43b26ef0b4c61e8c89a30 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:07');
INSERT INTO `failed_jobs` VALUES (14, 'ca3c6800-e4ff-46b6-acbd-e06310591731', 'database', 'default', '{\"uuid\":\"ca3c6800-e4ff-46b6-acbd-e06310591731\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550267&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=724c7d9d7c0f4f6529e4790bfa57120e0ba1ee1f9cfe4763d9fa9ada64e93214 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:08');
INSERT INTO `failed_jobs` VALUES (15, 'c3699938-33aa-468c-b565-8cf5780bca51', 'database', 'default', '{\"uuid\":\"c3699938-33aa-468c-b565-8cf5780bca51\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550268&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=55f6072a75b32cc4293bd84d63f01b142da185a486723618beac04a85b3e70f1 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:08');
INSERT INTO `failed_jobs` VALUES (16, '93d44d14-78d9-4830-946f-22e81329e824', 'database', 'default', '{\"uuid\":\"93d44d14-78d9-4830-946f-22e81329e824\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550268&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=55f6072a75b32cc4293bd84d63f01b142da185a486723618beac04a85b3e70f1 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:09');
INSERT INTO `failed_jobs` VALUES (17, '96bf8ce1-c6ef-4897-a06d-e8a0cf972f6b', 'database', 'default', '{\"uuid\":\"96bf8ce1-c6ef-4897-a06d-e8a0cf972f6b\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550269&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=289c79a2ae171d2af0d8077861d3ccafeadc65aabf7a59fefd531a0f5c37d045 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:10');
INSERT INTO `failed_jobs` VALUES (18, '06ef94e3-e24f-440f-9a94-e4583465a4de', 'database', 'default', '{\"uuid\":\"06ef94e3-e24f-440f-9a94-e4583465a4de\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550270&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=838b8dc99e7b4192134aa4446c1d6bf980284ab3296e381d64a628df0146852c in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:11');
INSERT INTO `failed_jobs` VALUES (19, 'aad57091-b8c4-46ac-86b5-10c86a3b7681', 'database', 'default', '{\"uuid\":\"aad57091-b8c4-46ac-86b5-10c86a3b7681\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550271&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=e77e6169852ff83f244f4fd8c1cc0a4b834d885c358508c6b42e7258032fec97 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:11');
INSERT INTO `failed_jobs` VALUES (20, '80adcb81-f793-4685-8912-7ada75f9ebf9', 'database', 'default', '{\"uuid\":\"80adcb81-f793-4685-8912-7ada75f9ebf9\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550271&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=e77e6169852ff83f244f4fd8c1cc0a4b834d885c358508c6b42e7258032fec97 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:12');
INSERT INTO `failed_jobs` VALUES (21, 'b46c9c3b-04be-448a-8783-58ea0b4bc51c', 'database', 'default', '{\"uuid\":\"b46c9c3b-04be-448a-8783-58ea0b4bc51c\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550272&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=9a899fc12114c241223a0220f67df56398ec114d1aad936dc9713277b361485c in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:12');
INSERT INTO `failed_jobs` VALUES (22, '5ebd2a3f-a2a8-49ea-bf87-a4c28883b9d3', 'database', 'default', '{\"uuid\":\"5ebd2a3f-a2a8-49ea-bf87-a4c28883b9d3\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550272&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=9a899fc12114c241223a0220f67df56398ec114d1aad936dc9713277b361485c in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:13');
INSERT INTO `failed_jobs` VALUES (23, 'f3995bcc-4166-46d4-8421-1fb2b8bb0f1d', 'database', 'default', '{\"uuid\":\"f3995bcc-4166-46d4-8421-1fb2b8bb0f1d\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550273&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=bd41e4864b875e8fbf803afcec456e8b6c31ae01124039d39e1e7c5f1982421a in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:13');
INSERT INTO `failed_jobs` VALUES (24, 'f9b2f12d-26e7-4f45-8970-7bd65c293311', 'database', 'default', '{\"uuid\":\"f9b2f12d-26e7-4f45-8970-7bd65c293311\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550273&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=bd41e4864b875e8fbf803afcec456e8b6c31ae01124039d39e1e7c5f1982421a in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:14');
INSERT INTO `failed_jobs` VALUES (25, '6e811f18-7795-4140-a9c3-ba7beb58f3b7', 'database', 'default', '{\"uuid\":\"6e811f18-7795-4140-a9c3-ba7beb58f3b7\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550274&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=7df19aba2e7d705e4a2abb10d1ed95eef68535f91a0982fb95928531da04f89b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:14');
INSERT INTO `failed_jobs` VALUES (26, '7a051754-74b5-4669-ac5f-cf2ec56037bc', 'database', 'default', '{\"uuid\":\"7a051754-74b5-4669-ac5f-cf2ec56037bc\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550274&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=7df19aba2e7d705e4a2abb10d1ed95eef68535f91a0982fb95928531da04f89b in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:15');
INSERT INTO `failed_jobs` VALUES (27, 'c270a213-9e06-4283-89e6-f4b598c38c22', 'database', 'default', '{\"uuid\":\"c270a213-9e06-4283-89e6-f4b598c38c22\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550275&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=896c9d0da12a4fbc3b971143f985da1be0b30095468f91a469f66ce7c6b19881 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:16');
INSERT INTO `failed_jobs` VALUES (28, '68f93f76-574c-456f-b46d-336dba059a42', 'database', 'default', '{\"uuid\":\"68f93f76-574c-456f-b46d-336dba059a42\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550276&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=de0b506723945a995dda3cf02cb4d6ace3456ed637cba42c1c24cef2e552bd14 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:16');
INSERT INTO `failed_jobs` VALUES (29, 'fb308b9c-2cf7-40e0-b691-f8532a8c6242', 'database', 'default', '{\"uuid\":\"fb308b9c-2cf7-40e0-b691-f8532a8c6242\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550276&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=de0b506723945a995dda3cf02cb4d6ace3456ed637cba42c1c24cef2e552bd14 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:17');
INSERT INTO `failed_jobs` VALUES (30, '3bab5d64-25c0-404b-93c0-a300591129e2', 'database', 'default', '{\"uuid\":\"3bab5d64-25c0-404b-93c0-a300591129e2\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550277&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=33f2d9057e8c9832209c6326023bc4fa258fbfb2d20bc0877d389b2e7be92c58 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:18');
INSERT INTO `failed_jobs` VALUES (31, 'c041f3eb-564a-4c36-8d46-028b1a83c19c', 'database', 'default', '{\"uuid\":\"c041f3eb-564a-4c36-8d46-028b1a83c19c\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550278&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=223b4544bc24917d7a7f08687e6f1d43cef6156f1a43e63346023345b8f41ed8 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:19');
INSERT INTO `failed_jobs` VALUES (32, '87bc6897-b50c-41ef-82d4-afb1b632b6df', 'database', 'default', '{\"uuid\":\"87bc6897-b50c-41ef-82d4-afb1b632b6df\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550279&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=ed8cc8cf07e11d82082d6ecfcac559c8f06518316766fd9244b5ae8a9984a477 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:20');
INSERT INTO `failed_jobs` VALUES (33, '98b156a6-a125-4d29-b0a3-bb58d2fff16a', 'database', 'default', '{\"uuid\":\"98b156a6-a125-4d29-b0a3-bb58d2fff16a\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550280&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=1c42247ef38e4f43939f3b6be746b59657c67592838adb1aa28f9b9cab2d7370 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:20');
INSERT INTO `failed_jobs` VALUES (34, '387b02fb-1c39-4a12-8201-eb69b18c8bbf', 'database', 'default', '{\"uuid\":\"387b02fb-1c39-4a12-8201-eb69b18c8bbf\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550280&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=1c42247ef38e4f43939f3b6be746b59657c67592838adb1aa28f9b9cab2d7370 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:21');
INSERT INTO `failed_jobs` VALUES (35, '6bb919e3-08a9-4a8a-9a33-7c1763f55b1d', 'database', 'default', '{\"uuid\":\"6bb919e3-08a9-4a8a-9a33-7c1763f55b1d\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550281&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=a3598844e13a8cb79d75261108f882ef7f8ed2e09ff3055b459c2f9df5ebd860 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:22');
INSERT INTO `failed_jobs` VALUES (36, 'b31c9787-ed86-4d89-915c-17d518d86813', 'database', 'default', '{\"uuid\":\"b31c9787-ed86-4d89-915c-17d518d86813\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550282&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=33ce945f3052476d80f1bcf710d76d640831748e525c8da6805c4e2537e4d8f3 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:22');
INSERT INTO `failed_jobs` VALUES (37, 'aa1e4104-fe75-4122-9884-60da91756064', 'database', 'default', '{\"uuid\":\"aa1e4104-fe75-4122-9884-60da91756064\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550282&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=33ce945f3052476d80f1bcf710d76d640831748e525c8da6805c4e2537e4d8f3 in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:23');
INSERT INTO `failed_jobs` VALUES (38, '11201406-20c2-46ca-9c32-a9d9076b91d0', 'database', 'default', '{\"uuid\":\"11201406-20c2-46ca-9c32-a9d9076b91d0\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550283&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=fb083ae77621aae2fe5edb07b9620e29587e5aa3c7e4c36dd999f4562b1620ef in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php(71): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#8 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(63): GuzzleHttp\\RedirectMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#9 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\HandlerStack.php(75): GuzzleHttp\\Middleware::GuzzleHttp\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#10 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(333): GuzzleHttp\\HandlerStack->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#11 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(169): GuzzleHttp\\Client->transfer(Object(GuzzleHttp\\Psr7\\Request), Array)\n#12 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Client.php(189): GuzzleHttp\\Client->requestAsync(\'POST\', Object(GuzzleHttp\\Psr7\\Uri), Array)\n#13 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\ClientTrait.php(95): GuzzleHttp\\Client->request(\'POST\', \'apps//events\', Array)\n#14 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(776): GuzzleHttp\\Client->post(\'apps//events\', Array)\n#15 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\pusher\\pusher-php-server\\src\\Pusher.php(441): Pusher\\Pusher->post(\'/apps//events\', \'{\"name\":\"App\\\\\\\\E...\')\n#16 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(161): Pusher\\Pusher->trigger(Array, \'App\\\\Events\\\\Noti...\', Array, Array)\n#17 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Collections\\Traits\\EnumeratesValues.php(238): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->Illuminate\\Broadcasting\\Broadcasters\\{closure}(Object(Illuminate\\Support\\Collection), 0)\n#18 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster.php(160): Illuminate\\Support\\Collection->each(Object(Closure))\n#19 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Broadcasting\\BroadcastEvent.php(92): Illuminate\\Broadcasting\\Broadcasters\\PusherBroadcaster->broadcast(Object(Illuminate\\Support\\Collection), \'App\\\\Events\\\\Noti...\', Array)\n#20 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Broadcasting\\BroadcastEvent->handle(Object(Illuminate\\Broadcasting\\BroadcastManager))\n#21 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#22 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#23 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#24 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#25 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(128): Illuminate\\Container\\Container->call(Array)\n#26 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Bus\\Dispatcher->Illuminate\\Bus\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#27 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#28 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Bus\\Dispatcher.php(132): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#29 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(123): Illuminate\\Bus\\Dispatcher->dispatchNow(Object(Illuminate\\Broadcasting\\BroadcastEvent), false)\n#30 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Queue\\CallQueuedHandler->Illuminate\\Queue\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#31 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#32 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(122): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#33 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\CallQueuedHandler.php(70): Illuminate\\Queue\\CallQueuedHandler->dispatchThroughMiddleware(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Broadcasting\\BroadcastEvent))\n#34 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Jobs\\Job.php(102): Illuminate\\Queue\\CallQueuedHandler->call(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Array)\n#35 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(439): Illuminate\\Queue\\Jobs\\Job->fire()\n#36 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(389): Illuminate\\Queue\\Worker->process(\'database\', Object(Illuminate\\Queue\\Jobs\\DatabaseJob), Object(Illuminate\\Queue\\WorkerOptions))\n#37 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Worker.php(176): Illuminate\\Queue\\Worker->runJob(Object(Illuminate\\Queue\\Jobs\\DatabaseJob), \'database\', Object(Illuminate\\Queue\\WorkerOptions))\n#38 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(137): Illuminate\\Queue\\Worker->daemon(\'database\', \'default\', Object(Illuminate\\Queue\\WorkerOptions))\n#39 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Queue\\Console\\WorkCommand.php(120): Illuminate\\Queue\\Console\\WorkCommand->runWorker(\'database\', \'default\')\n#40 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(36): Illuminate\\Queue\\Console\\WorkCommand->handle()\n#41 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Util.php(41): Illuminate\\Container\\BoundMethod::Illuminate\\Container\\{closure}()\n#42 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(93): Illuminate\\Container\\Util::unwrapIfClosure(Object(Closure))\n#43 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\BoundMethod.php(35): Illuminate\\Container\\BoundMethod::callBoundMethod(Object(Illuminate\\Foundation\\Application), Array, Object(Closure))\n#44 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Container\\Container.php(662): Illuminate\\Container\\BoundMethod::call(Object(Illuminate\\Foundation\\Application), Array, Array, NULL)\n#45 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(211): Illuminate\\Container\\Container->call(Array)\n#46 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Command\\Command.php(326): Illuminate\\Console\\Command->execute(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#47 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Command.php(180): Symfony\\Component\\Console\\Command\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Illuminate\\Console\\OutputStyle))\n#48 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(1081): Illuminate\\Console\\Command->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#49 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(320): Symfony\\Component\\Console\\Application->doRunCommand(Object(Illuminate\\Queue\\Console\\WorkCommand), Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#50 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\symfony\\console\\Application.php(174): Symfony\\Component\\Console\\Application->doRun(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#51 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Console\\Application.php(162): Symfony\\Component\\Console\\Application->run(Object(Symfony\\Component\\Console\\Input\\StringInput), Object(Symfony\\Component\\Console\\Output\\BufferedOutput))\n#52 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Console\\Kernel.php(400): Illuminate\\Console\\Application->call(\'queue:work\', Array, NULL)\n#53 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Support\\Facades\\Facade.php(353): Illuminate\\Foundation\\Console\\Kernel->call(\'queue:work\')\n#54 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\routes\\web.php(38): Illuminate\\Support\\Facades\\Facade::__callStatic(\'call\', Array)\n#55 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\CallableDispatcher.php(40): Illuminate\\Routing\\RouteFileRegistrar->{closure}()\n#56 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(237): Illuminate\\Routing\\CallableDispatcher->dispatch(Object(Illuminate\\Routing\\Route), Object(Closure))\n#57 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Route.php(208): Illuminate\\Routing\\Route->runCallable()\n#58 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(799): Illuminate\\Routing\\Route->run()\n#59 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Routing\\Router->Illuminate\\Routing\\{closure}(Object(Illuminate\\Http\\Request))\n#60 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Middleware\\SubstituteBindings.php(50): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#61 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Routing\\Middleware\\SubstituteBindings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#62 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken.php(78): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#63 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\VerifyCsrfToken->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#64 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\View\\Middleware\\ShareErrorsFromSession.php(49): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#65 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\View\\Middleware\\ShareErrorsFromSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#66 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(121): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#67 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Session\\Middleware\\StartSession.php(64): Illuminate\\Session\\Middleware\\StartSession->handleStatefulRequest(Object(Illuminate\\Http\\Request), Object(Illuminate\\Session\\Store), Object(Closure))\n#68 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Session\\Middleware\\StartSession->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#69 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse.php(37): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#70 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\AddQueuedCookiesToResponse->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#71 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Cookie\\Middleware\\EncryptCookies.php(67): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#72 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Cookie\\Middleware\\EncryptCookies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#73 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#74 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(798): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#75 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(777): Illuminate\\Routing\\Router->runRouteWithinStack(Object(Illuminate\\Routing\\Route), Object(Illuminate\\Http\\Request))\n#76 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(741): Illuminate\\Routing\\Router->runRoute(Object(Illuminate\\Http\\Request), Object(Illuminate\\Routing\\Route))\n#77 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Routing\\Router.php(730): Illuminate\\Routing\\Router->dispatchToRoute(Object(Illuminate\\Http\\Request))\n#78 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(200): Illuminate\\Routing\\Router->dispatch(Object(Illuminate\\Http\\Request))\n#79 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(141): Illuminate\\Foundation\\Http\\Kernel->Illuminate\\Foundation\\Http\\{closure}(Object(Illuminate\\Http\\Request))\n#80 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#81 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull.php(31): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#82 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ConvertEmptyStringsToNull->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#83 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest.php(21): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#84 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\TrimStrings.php(40): Illuminate\\Foundation\\Http\\Middleware\\TransformsRequest->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#85 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\TrimStrings->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#86 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize.php(27): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#87 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\ValidatePostSize->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#88 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance.php(99): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#89 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Foundation\\Http\\Middleware\\PreventRequestsDuringMaintenance->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#90 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\HandleCors.php(62): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#91 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\HandleCors->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#92 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Http\\Middleware\\TrustProxies.php(39): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#93 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(180): Illuminate\\Http\\Middleware\\TrustProxies->handle(Object(Illuminate\\Http\\Request), Object(Closure))\n#94 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Pipeline\\Pipeline.php(116): Illuminate\\Pipeline\\Pipeline->Illuminate\\Pipeline\\{closure}(Object(Illuminate\\Http\\Request))\n#95 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(175): Illuminate\\Pipeline\\Pipeline->then(Object(Closure))\n#96 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\laravel\\framework\\src\\Illuminate\\Foundation\\Http\\Kernel.php(144): Illuminate\\Foundation\\Http\\Kernel->sendRequestThroughRouter(Object(Illuminate\\Http\\Request))\n#97 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\public\\index.php(51): Illuminate\\Foundation\\Http\\Kernel->handle(Object(Illuminate\\Http\\Request))\n#98 {main}', '2024-10-10 12:21:24');
INSERT INTO `failed_jobs` VALUES (39, '98fe2692-5e51-48fb-98ff-642d26f3eb2a', 'database', 'default', '{\"uuid\":\"98fe2692-5e51-48fb-98ff-642d26f3eb2a\",\"displayName\":\"App\\\\Events\\\\NotificationPanelSent\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\",\"command\":\"O:38:\\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\\":14:{s:5:\\\"event\\\";O:32:\\\"App\\\\Events\\\\NotificationPanelSent\\\":1:{s:7:\\\"message\\\";s:18:\\\"پیام جدید!\\\";}s:5:\\\"tries\\\";N;s:7:\\\"timeout\\\";N;s:7:\\\"backoff\\\";N;s:13:\\\"maxExceptions\\\";N;s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}', 'GuzzleHttp\\Exception\\RequestException: cURL error 60: SSL certificate problem: unable to get local issuer certificate (see https://curl.haxx.se/libcurl/c/libcurl-errors.html) for https://api-mt1.pusher.com/apps//events?auth_key=&auth_timestamp=1728550284&auth_version=1.0&body_md5=088fb91f658eabd9c41cf284c968435b&auth_signature=c05cdc0d5ba7064333519308dd3be254c0eb02ab949eee7dff3aa478adff27bf in D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php:211\nStack trace:\n#0 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(158): GuzzleHttp\\Handler\\CurlFactory::createRejection(Object(GuzzleHttp\\Handler\\EasyHandle), Array)\n#1 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlFactory.php(110): GuzzleHttp\\Handler\\CurlFactory::finishError(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#2 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\CurlHandler.php(47): GuzzleHttp\\Handler\\CurlFactory::finish(Object(GuzzleHttp\\Handler\\CurlHandler), Object(GuzzleHttp\\Handler\\EasyHandle), Object(GuzzleHttp\\Handler\\CurlFactory))\n#3 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(28): GuzzleHttp\\Handler\\CurlHandler->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#4 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Handler\\Proxy.php(48): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#5 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\PrepareBodyMiddleware.php(64): GuzzleHttp\\Handler\\Proxy::GuzzleHttp\\Handler\\{closure}(Object(GuzzleHttp\\Psr7\\Request), Array)\n#6 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\Middleware.php(31): GuzzleHttp\\PrepareBodyMiddleware->__invoke(Object(GuzzleHttp\\Psr7\\Request), Array)\n#7 D:\\develop\\food\\mihmannaxaz\\api\\laravel\\vendor\\guzzlehttp\\guzzle\\src\\RedirectMiddleware.php