<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['throttle:500,1'])->prefix('v1')->group(function () {
    Route::post('/upload', [\App\Http\Controllers\V1\FileManager\FileController::class, 'upload']);
    Route::get('/get-all-id-branches', [\App\Http\Controllers\V1\BranchController::class, 'getAllId']);

//    #d
    Route::get('/home-info', [\App\Http\Controllers\V1\SettingsController::class, 'homeInfo']);
    Route::get('/home-setting', [\App\Http\Controllers\V1\SettingsController::class, 'homeSetting']);
    Route::get('/front-logo', [\App\Http\Controllers\V1\SettingsController::class, 'getLogo']);

//#d
    Route::get('/front-setting', [\App\Http\Controllers\V1\SettingsController::class, 'frontSetting']);


    Route::get('/sitemap-list-products', [\App\Http\Controllers\V1\ProductController::class, 'sitemapListProducts']);
    Route::get('/sitemap-list-branches', [\App\Http\Controllers\V1\BranchController::class, 'sitemapList']);


    Route::prefix('auth')->group(function () {
        Route::post('/send_code', [\Modules\User\app\Http\Controllers\UserController::class, 'sendCode']);
        Route::post('/check_code', [\Modules\User\app\Http\Controllers\UserController::class, 'checkCode']);
    });


    Route::prefix('branch')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\VendorController::class, 'getAllBranches']);
        Route::get('/show/{id}', [\App\Http\Controllers\V1\BranchController::class, 'show']);
        Route::get('/get-gallery/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'getGallery']);
        Route::get('/delivery-types/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'deliveryTypes']);
        Route::get('/getActivityTime/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'getActivityTime']);
        Route::get('/get-status-now/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'getNowStatus']);
        Route::get('/per-order-time/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'perOrderTime']);
        Route::get('/get-times-active-day/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'getActivityDay']);
        Route::get('/status/{branchId}', [\App\Http\Controllers\V1\BranchController::class, 'getBranchStatus']);
    });

    Route::prefix('page')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\PageController::class, 'index']);
        Route::get('/show/{slug}', [\App\Http\Controllers\V1\PageController::class, 'show']);
    });


    Route::prefix('component')->group(function () {
        Route::get('/get-with-code/{code}', [\App\Http\Controllers\V1\ComponentController::class, 'getWithCode']);
        Route::get('/get-list-components/{type}/{slug?}', [\App\Http\Controllers\V1\ComponentController::class, 'getListComponents']);
    });


    Route::prefix('product')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\ProductController::class, 'index']);
        Route::get('/get_category_all_with_branch', [\App\Http\Controllers\V1\ProductController::class, 'getCategoryAll']);
        Route::get('/{id}', [\App\Http\Controllers\V1\ProductController::class, 'show']);

        //delete
        Route::get('/get-calories/{id}', [\App\Http\Controllers\V1\ProductController::class, 'getCalories']);
        //end delete
    });


    Route::prefix('/areas')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\AreaController::class, 'getArea']);
        Route::get('/active-shipping-methods', [\App\Http\Controllers\V1\AreaController::class, 'getActiveShippingMethods']);
        Route::get('/user-addresses-for-delivery-type', [\App\Http\Controllers\V1\AreaController::class, 'getUserAddressesForDeliveryType']);
        Route::get('/area-management-for-address', [\App\Http\Controllers\V1\AreaController::class, 'getAreaManagementForAddress']);
        Route::get('/delivery-methods-by-time', [\App\Http\Controllers\V1\AreaController::class, 'getDeliveryMethodsAndAreaManagementByLocation']);
    });


    Route::prefix('search')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\SearchController::class, 'searchProductAndBranch']);
    });


    Route::prefix('slider')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\SliderController::class, 'index']);
    });


    Route::prefix('category')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\CategoryController::class, 'getCategories']);
    });


    Route::prefix('activity')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\ActivityController::class, 'index']);
    });


    Route::prefix('vendors')->group(function () {
        Route::post('/register', [\App\Http\Controllers\V1\VendorController::class, 'register']);
    });


    Route::prefix('comment')->group(function () {
        Route::get('/product/{productId}', [\App\Http\Controllers\V1\CommentController::class, 'getCommentProduct']);
        Route::get('/branch/{branchId}', [\App\Http\Controllers\V1\CommentController::class, 'getCommentBranch']);
        Route::get('/branch/rate/{branchId}', [\App\Http\Controllers\V1\CommentController::class, 'getBranchRate']);
    });

    Route::prefix('order')->group(function () {
        Route::prefix('cart')->middleware('CheckCartUserOrGust')->group(function () {
            Route::post('/add-product', [\App\Http\Controllers\V1\OrderController::class, 'addProductCart']);
        });
        Route::get('/with-items', [\App\Http\Controllers\V1\OrderController::class, 'getAllWithItems'])->middleware('CheckCartUserOrGust');

    });

    Route::prefix('popup-alarms')->group(function () {
        Route::get('/unseen-alarms', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getUnseenAlarms']);
    });


});

// User routes without CheckAccess middleware
Route::middleware(['auth:api'])->prefix('v1')->name('api.v1.')->group(function () {
    Route::prefix('user')->group(function () {
        Route::put('/update-profile', [\Modules\User\app\Http\Controllers\ProfileController::class, 'updateProfile']);
        Route::get('/get-profile', [\Modules\User\app\Http\Controllers\ProfileController::class, 'getProfile']);
        Route::get('/get-coupons-active-list', [\Modules\User\app\Http\Controllers\ProfileController::class, 'getCouponActiveList']);
        Route::get('/user-inventory', [\App\Http\Controllers\V1\TransactionController::class, 'userInventory']);
        Route::get('/get-order-user', [\App\Http\Controllers\V1\OrderController::class, 'getOrderUser'])->name('getOrderUser');
        Route::get('/get-transactions', [\App\Http\Controllers\V1\TransactionController::class, 'getTransactions'])->name('getTransactions');
        Route::put('/set-address/{id}', [\Modules\User\app\Http\Controllers\ProfileController::class, 'setAddress'])->name('setAddress');
        Route::post('/set-charge-wallet', [\App\Http\Controllers\V1\PaymentController::class, 'setChargeWallet'])->name('setChargeWallet');

        // Cash Back APIs
        Route::prefix('cash-back')->group(function () {
            Route::get('/balance', [\App\Http\Controllers\V1\CashBackController::class, 'getUserCashBackBalance'])->name('cashBack.balance');
            Route::get('/balance/{branchId}', [\App\Http\Controllers\V1\CashBackController::class, 'getUserCashBackBalanceByBranch'])->name('cashBack.balanceByBranch');
            Route::get('/details', [\App\Http\Controllers\V1\CashBackController::class, 'getUserCashBackDetails'])->name('cashBack.details');
        });

        Route::prefix('bank-account')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\BankAccountController::class, 'index']);
            Route::post('/store', [\App\Http\Controllers\V1\BankAccountController::class, 'store']);
            Route::get('/show', [\App\Http\Controllers\V1\BankAccountController::class, 'show']);
            Route::put('/update', [\App\Http\Controllers\V1\BankAccountController::class, 'update']);
            Route::delete('/destroy', [\App\Http\Controllers\V1\BankAccountController::class, 'destroy'])->name('destroy');
        });
    });
    Route::prefix('order')->group(function () {
        Route::prefix('cart')->middleware('CheckCartUserOrGust')->group(function () {
            Route::put('/mines-product', [\App\Http\Controllers\V1\OrderController::class, 'minesProductCart']);
            Route::delete('/delete-product', [\App\Http\Controllers\V1\OrderController::class, 'deleteProductCart']);
            Route::get('/count', [\App\Http\Controllers\V1\OrderController::class, 'getCountItem']);

        });

        Route::get('/get-list-gateways', [\App\Http\Controllers\V1\OrderController::class, 'getListGateways']);

                Route::post('/store-or-update-order-with-list', [\App\Http\Controllers\V1\OrderController::class, 'storeOrUpdateOrderWithList']);
        Route::post('/set-delivery-info', [\App\Http\Controllers\V1\OrderController::class, 'setDeliveryInfo']);
        Route::post('/change-delivery-type', [\App\Http\Controllers\V1\OrderController::class, 'changeDeliveryType']);
        Route::post('/check-date', [\App\Http\Controllers\V1\OrderController::class, 'checkTimeSet']);
        Route::get('/list-address', [\App\Http\Controllers\V1\OrderController::class, 'getListAddressAccessCart']);
        Route::get('/order-list-before', [\App\Http\Controllers\V1\OrderController::class, 'orderListBefore']);
        // Route::get('/get-list-gateways', [\App\Http\Controllers\V1\OrderController::class, 'getListGateways']);
        Route::get('/shipping-methods', [\App\Http\Controllers\V1\OrderController::class, 'getShippingMethods']);
        Route::post('/set-order', [\App\Http\Controllers\V1\PaymentController::class, 'setOrder']);
        Route::post('/comment/{id}', [\App\Http\Controllers\V1\OrderController::class, 'createComment']);
        Route::get('/check-coupon', [\App\Http\Controllers\V1\OrderController::class, 'checkCoupon']);
        Route::delete('/delete-user-active-order', [\App\Http\Controllers\V1\OrderController::class, 'deleteUserActiveCart']);
        Route::get('/{id}', [\App\Http\Controllers\V1\OrderController::class, 'getOrder']);

    });

    Route::prefix('address')->name('address')->group(function () {
        Route::get('/get-all', [\Modules\User\app\Http\Controllers\AddressController::class, 'index']);
        Route::post('/create', [\Modules\User\app\Http\Controllers\AddressController::class, 'create']);
        Route::put('/update/{id}', [\Modules\User\app\Http\Controllers\AddressController::class, 'update']);
        Route::get('/{id}', [\Modules\User\app\Http\Controllers\AddressController::class, 'show']);
        Route::delete('/destroy', [\Modules\User\app\Http\Controllers\AddressController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('ticket')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\TicketController::class, 'index']);
        Route::post('/create', [\App\Http\Controllers\V1\TicketController::class, 'create']);
        Route::get('/show/{id}', [\App\Http\Controllers\V1\TicketController::class, 'show']);
        Route::get('/get-category', [\App\Http\Controllers\V1\TicketController::class, 'getCategory'])->name('getCategory');
    });

    Route::get('/user-inventory-by-id', [\App\Http\Controllers\V1\TransactionController::class, 'userInventoryByUserId']);

    Route::prefix('popup-alarms')->group(function () {
        Route::get('/unseen-alarms', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getUnseenAlarms']);
        Route::post('/mark-viewed', [\App\Http\Controllers\V1\PopupAlarmController::class, 'markAsViewed']);

        // Route های رستوران برای مدیریت آلارم‌های خود
        Route::post('/store', [\App\Http\Controllers\V1\PopupAlarmController::class, 'store']);
        Route::get('/my-alarms', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getMyBranchAlarms'])->name('getMyBranchAlarms');
        //Route::put('/update/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'update']);
        //Route::delete('/destroy/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'destroy']);
        Route::get('/view-stats/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getViewStats']);
        //Route::get('/get-alarm-by-id/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getAlarmById']);
        Route::get('/page-types', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getPageTypes']);
    });
});

//middleware('auth:api','CheckAccess')->
Route::middleware(['auth:api','CheckAccess'])->prefix('v1')->name('api.v1.')->group(function () {
    Route::prefix('customer')->name('customer.')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\CustomerBranchController::class, 'index'])->name('index');
        Route::post('/', [\App\Http\Controllers\V1\CustomerBranchController::class, 'store'])->name('store');
        Route::get('/search', [\App\Http\Controllers\V1\CustomerBranchController::class, 'search'])->name('search');
        Route::get('/stats', [\App\Http\Controllers\V1\CustomerBranchController::class, 'stats'])->name('stats');
        Route::get('/show/{id}', [\App\Http\Controllers\V1\CustomerBranchController::class, 'show'])->name('show');
        Route::put('/update/{id}', [\App\Http\Controllers\V1\CustomerBranchController::class, 'update'])->name('update');
        Route::delete('/destroy/{id}', [\App\Http\Controllers\V1\CustomerBranchController::class, 'destroy'])->name('destroy');
    });

    Route::prefix('holidays')->name('holidays.')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\BranchHolidayController::class, 'index'])->name('index');
        Route::post('/', [\App\Http\Controllers\V1\BranchHolidayController::class, 'store'])->name('store');
        Route::get('/{holidayId}', [\App\Http\Controllers\V1\BranchHolidayController::class, 'show'])->name('show');
        Route::put('/{holidayId}', [\App\Http\Controllers\V1\BranchHolidayController::class, 'update'])->name('update');
        Route::delete('/{holidayId}', [\App\Http\Controllers\V1\BranchHolidayController::class, 'destroy'])->name('destroy');
        Route::get('/check-status', [\App\Http\Controllers\V1\BranchHolidayController::class, 'checkBranchStatus'])->name('checkBranchStatus');
        Route::get('/upcoming', [\App\Http\Controllers\V1\BranchHolidayController::class, 'getUpcomingHolidays'])->name('getUpcomingHolidays');
        Route::get('/range', [\App\Http\Controllers\V1\BranchHolidayController::class, 'getHolidaysInRange'])->name('getHolidaysInRange');
    });

    Route::prefix('comment')->name('comment.')->group(function () {
        Route::get('/', [\App\Http\Controllers\V1\Admin\CommentController::class, 'index'])->name('index');
        Route::get('/show', [\App\Http\Controllers\V1\Admin\CommentController::class, 'show'])->name('show');
        Route::post('/store', [\App\Http\Controllers\V1\Admin\CommentController::class, 'store'])->name('store');
        Route::post('/toggle-approval', [\App\Http\Controllers\V1\Admin\CommentController::class, 'toggleApproval'])->name('toggle-approval');
    });

    Route::prefix('couriers')->group(function () {
        Route::post('/search-and-create', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'searchAndCreate'])->name('couriers.search-and-create');
        Route::get('/search-users', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'searchUsers'])->name('couriers.search-users');
        Route::get('/orders', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'getCourierOrders'])->name('couriers.orders');
        Route::get('/orders/stats', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'getCourierOrderStats'])->name('couriers.orders.stats');
        Route::get('/', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'index'])->name('couriers.index');
        Route::post('/', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'store'])->name('couriers.store');
        Route::get('/{id}', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'show'])->name('couriers.show');
        Route::put('/{id}', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'update'])->name('couriers.update');
        Route::delete('/{id}', [\Modules\Courier\app\Http\Controllers\CourierController::class, 'destroy'])->name('couriers.destroy');
    });

    // User Order APIs
    Route::prefix('user-orders')->group(function () {
        Route::get('/branch-orders', [\App\Http\Controllers\V1\UserOrderController::class, 'getUserBranchOrders'])->name('user-orders.branch-orders');
        Route::get('/branch-stats', [\App\Http\Controllers\V1\UserOrderController::class, 'getUserBranchOrderStats'])->name('user-orders.branch-stats');
        Route::get('/favorite-products', [\App\Http\Controllers\V1\UserOrderController::class, 'getUserFavoriteProducts'])->name('user-orders.favorite-products');
    });


    Route::prefix('favorite')->group(function () {
        Route::get('/get-all-favorite-ids', [\App\Http\Controllers\V1\FavoriteController::class, 'getAllFavoriteIds']);
        Route::get('/with-type/{type}', [\App\Http\Controllers\V1\FavoriteController::class, 'getWithType']);
        Route::post('/create', [\App\Http\Controllers\V1\FavoriteController::class, 'store']);
        Route::delete('/remove', [\App\Http\Controllers\V1\FavoriteController::class, 'remove']);
        Route::get('/check-status', [\App\Http\Controllers\V1\FavoriteController::class, 'checkStatus']);
    });

 
    Route::prefix('admin')->name('admin.')->middleware('CheckAccess')->group(function () {

        Route::prefix('popup-alarms')->name('popupAlarms.')->group(function () {
            Route::post('/store', [\App\Http\Controllers\V1\PopupAlarmController::class, 'store'])->name('store');
            Route::get('/branch-alarms', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getBranchAlarms'])->name('getBranchAlarms');
            Route::get('/find/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getAlarmById'])->name('show');
            Route::put('/update/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'update'])->name('update');
            Route::delete('/destroy/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'destroy'])->name('destroy');
            Route::get('/view-stats/{id}', [\App\Http\Controllers\V1\PopupAlarmController::class, 'getViewStats'])->name('getViewStats');
        });
        Route::post('login-as-branch/{branch}', [\App\Http\Controllers\V1\Admin\UserController::class, 'loginAsBranch'])->name('loginAsBranch');

        Route::prefix('component')->name('component.')->group(function () {
            Route::get('/get-list-access-component', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'getListComponentAccess'])->name('getListComponentAccess');
            Route::get('/filter-extra-component/{type}', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'getFilterAndExtraInput'])->name('getFilterAndExtraInput');
            Route::get('/show/{id}', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'show'])->name('show');
            Route::post('/create', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'store'])->name('store');
            Route::put('/update/{id}', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'update'])->name('update');
            Route::get('/list/{slug?}/{type?}', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'list'])->name('list');
            Route::delete('/destroy/{id}', [\App\Http\Controllers\V1\Admin\ComponentController::class, 'destroy'])->name('destroy');

        });

        Route::prefix('dashboard')->name('dashboard.')->group(function () {
            Route::get('/get-count', [\App\Http\Controllers\V1\Admin\DashboardController::class, 'getCount'])->name('getCount');
            Route::get('/get-latest-user-register-count', [\App\Http\Controllers\V1\Admin\DashboardController::class, 'getLatestUserRegisterCount'])->name('getLatestUserRegisterCount');

        });
        Route::prefix('user')->name('user.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\UserController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\UserController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\UserController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\UserController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\UserController::class, 'update'])->name('update');
            Route::post('/set-delivery-order', [\App\Http\Controllers\V1\Admin\OrderController::class, 'setDeliveryOrder'])->name('setDeliveryOrder');
            Route::get('/bank-account-user', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'index'])->name('bankAccountUser');
            Route::get('/history-order', [\App\Http\Controllers\V1\Admin\OrderController::class, 'historyOrder'])->name('historyOrder');
            Route::get('/get-user-by-branch-id', [\App\Http\Controllers\V1\Admin\UserController::class, 'getUserByBranchId'])->name('getUserByBranchId');
        });

        // Admin Bank Account Management
        Route::prefix('bank-account')->name('bankAccount.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'update'])->name('update');
            Route::patch('/toggle-status', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'toggleStatus'])->name('toggleStatus');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\BankAccountController::class, 'destroy'])->name('destroy');
        });

        // Admin Cash Back APIs
        Route::prefix('cash-back')->name('cashBack.')->group(function () {
            Route::get('/user-balance', [\App\Http\Controllers\V1\Admin\CashBackController::class, 'getUserCashBackBalance'])->name('userBalance');
            Route::get('/user-balance/{branchId}', [\App\Http\Controllers\V1\Admin\CashBackController::class, 'getUserCashBackBalanceByBranch'])->name('userBalanceByBranch');
            Route::get('/user-details', [\App\Http\Controllers\V1\Admin\CashBackController::class, 'getUserCashBackDetails'])->name('userDetails');
            Route::get('/all-users', [\App\Http\Controllers\V1\Admin\CashBackController::class, 'getAllUsersCashBack'])->name('allUsers');
            Route::get('/statistics', [\App\Http\Controllers\V1\Admin\CashBackController::class, 'getCashBackStatistics'])->name('statistics');
        });
 


        Route::prefix('address')->name('address.')->group(function () {
            Route::get('/', [\Modules\User\app\Http\Controllers\Admin\AddressController::class, 'index'])->name('index');
            Route::post('/create', [\Modules\User\app\Http\Controllers\Admin\AddressController::class, 'store'])->name('create');
            Route::put('/update/{id}', [\Modules\User\app\Http\Controllers\Admin\AddressController::class, 'update'])->name('update');
            Route::get('/{id}', [\Modules\User\app\Http\Controllers\Admin\AddressController::class, 'show'])->name('show');
            Route::delete('/destroy/{id}', [\Modules\User\app\Http\Controllers\Admin\AddressController::class, 'destroy'])->name('destroy');
        });
        Route::prefix('agent')->name('agent.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\AgentController::class, 'index'])->name('index');
            Route::get('/show/{id}', [\App\Http\Controllers\V1\Admin\AgentController::class, 'show'])->name('show');
            Route::delete('/destroy/{id}', [\App\Http\Controllers\V1\Admin\AgentController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\AgentController::class, 'store'])->name('store');
            Route::put('/update/{id}', [\App\Http\Controllers\V1\Admin\AgentController::class, 'update'])->name('update');
        });


        Route::prefix('ticket')->name('ticket.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\TicketController::class, 'index'])->name('index');
            Route::get('/get-category', [\App\Http\Controllers\V1\Admin\TicketController::class, 'getCategory'])->name('getCategory');
            Route::post('/create', [\App\Http\Controllers\V1\Admin\TicketController::class, 'create'])->name('store');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\TicketController::class, 'show'])->name('show');
        });
        Route::prefix('category')->name('category.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'index'])->name('index');
            Route::get('/get-with-products', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'getWithProducts'])->name('getWithProducts');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'update'])->name('update');
            Route::post('/toggle-status', [\App\Http\Controllers\V1\Admin\CategoryController::class, 'toggleStatus'])->name('toggleStatus');
        });
        Route::prefix('settlement')->name('settlement.')->group(function () {
            Route::post('/store', [\App\Http\Controllers\V1\Admin\SettlementController::class, 'store'])->name('store');
            Route::get('/', [\App\Http\Controllers\V1\Admin\SettlementController::class, 'index'])->name('index');
            Route::get('/get-wallet-restaurant', [\App\Http\Controllers\V1\Admin\SettlementController::class, 'getWalletRestaurant'])->name('getWalletRestaurant');
            Route::put('/change-status', [\App\Http\Controllers\V1\Admin\SettlementController::class, 'changeStatus'])->name('ageStatus');
        });
        Route::prefix('transaction')->name('transaction.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\TransactionsController::class, 'index'])->name('index');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\TransactionsController::class, 'store'])->name('store');
        });
        Route::prefix('vendor')->name('vendor.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\VendorController::class, 'index'])->name('index');
            Route::get('/get-registers', [\App\Http\Controllers\V1\Admin\VendorController::class, 'getRegisters'])->name('getRegisters');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\VendorController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\VendorController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\VendorController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\VendorController::class, 'update'])->name('update');
        });
        Route::prefix('branch')->name('branch.')->group(function () {
            Route::get('/show', [\App\Http\Controllers\V1\Admin\BranchController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\BranchController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\BranchController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\BranchController::class, 'update'])->name('update');
            Route::get('/get_branch_phones', [\App\Http\Controllers\V1\Admin\BranchController::class, 'getBranchPhones'])->name('getBranchPhones');
            Route::get('/get-gallery', [\App\Http\Controllers\V1\Admin\BranchController::class, 'getGallery'])->name('getGallery');
            Route::post('/set-gallery', [\App\Http\Controllers\V1\Admin\BranchController::class, 'setGallery'])->name('setGallery');
            Route::get('/get-activity', [\App\Http\Controllers\V1\Admin\BranchController::class, 'getActivity'])->name('getActivity');
            Route::post('/set-activity', [\App\Http\Controllers\V1\Admin\BranchController::class, 'setActivity'])->name('setActivity');
            Route::delete('/delete-activity', [\App\Http\Controllers\V1\Admin\BranchController::class, 'destroyActivity'])->name('destroyActivity');
            Route::get('/', [\App\Http\Controllers\V1\Admin\BranchController::class, 'index'])->name('index');

            //delivery-areas
            Route::get('/delivery-areas', [\App\Http\Controllers\V1\Admin\BranchController::class, 'getBranchDeliveryAreas'])->name('deliveryAreas');
            Route::post('/set-or-update-area-delivery', [\App\Http\Controllers\V1\Admin\BranchController::class, 'setOrUpdateDeliveryArea'])->name('setOrUpdateDeliveryArea');
            Route::delete('/detach-delivery-area', [\App\Http\Controllers\V1\Admin\BranchController::class, 'detachDeliveryArea'])->name('detachDeliveryArea');


            Route::get('/get-delivery-type/{branchId}', [\App\Http\Controllers\V1\Admin\BranchController::class, 'getDeliveryType'])->name('getDeliveryType');
            Route::post('/set-or-update-delivery-type/{branchId}', [\App\Http\Controllers\V1\Admin\BranchController::class, 'setOrUpdateDeliveryType'])->name('setOrUpdateDeliveryType');

        });

        Route::prefix('comment')->name('comment.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\CommentController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\CommentController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\CommentController::class, 'store'])->name('store');
            Route::post('/toggle-approval', [\App\Http\Controllers\V1\Admin\CommentController::class, 'toggleApproval'])->name('toggle-approval');
        });

        Route::prefix('area')->name('area.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\AreaController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\AreaController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\AreaController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\AreaController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\AreaController::class, 'update'])->name('update');
            Route::post('/create-management', [\App\Http\Controllers\V1\Admin\AreaController::class, 'createManagement'])->name('createManagement');
            Route::put('/update-management', [\App\Http\Controllers\V1\Admin\AreaController::class, 'updateManagement'])->name('updateManagement');
            Route::get('/branch-areas', [\App\Http\Controllers\V1\Admin\AreaController::class, 'getBranchAreas'])->name('getBranchAreas');
            Route::get('/show-management', [\App\Http\Controllers\V1\Admin\AreaController::class, 'showManagement'])->name('showManagement');
            Route::delete('/delete-management', [\App\Http\Controllers\V1\Admin\AreaController::class, 'deleteManagement'])->name('deleteManagement');
            Route::post('/toggle-area-status', [\App\Http\Controllers\V1\Admin\AreaController::class, 'toggleAreaStatus'])->name('toggleAreaStatus');
            Route::get('/area-branches', [\App\Http\Controllers\V1\Admin\AreaController::class, 'getAreaBranches'])->name('getAreaBranches');
        });
        Route::prefix('delivery-type')->name('deliveryType.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\DeliveryTypeController::class, 'index'])->name('index');
            Route::get('/show/{deliveryType}', [\App\Http\Controllers\V1\Admin\DeliveryTypeController::class, 'show'])->name('show');
            Route::delete('/destroy/{deliveryType}', [\App\Http\Controllers\V1\Admin\DeliveryTypeController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\DeliveryTypeController::class, 'store'])->name('store');
            Route::put('/update/{deliveryType}', [\App\Http\Controllers\V1\Admin\DeliveryTypeController::class, 'update'])->name('update');
        });
        Route::prefix('product')->name('product.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\ProductController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\ProductController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\ProductController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\ProductController::class, 'store'])->name('store');
            Route::post('/store-with-ids-default', [\App\Http\Controllers\V1\Admin\ProductController::class, 'storeWithIdsDefault'])->name('storeWithIdsDefault');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\ProductController::class, 'update'])->name('update');
            Route::post('/update_count_variety', [\App\Http\Controllers\V1\Admin\ProductController::class, 'updateCountVariety'])->name('updateCountVariety');
            Route::post('/update-or-store-varieties/{productId}', [\App\Http\Controllers\V1\Admin\ProductController::class, 'updateOrStoreVarieties'])->name('updateOrStoreVarieties');
            Route::post('/set-materials', [\App\Http\Controllers\V1\Admin\ProductController::class, 'setMaterials'])->name('setMaterials');
            Route::post('/set-gallery', [\App\Http\Controllers\V1\Admin\ProductController::class, 'setGallery'])->name('setGallery');
        });


        Route::prefix('product-default')->name('product-default.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'index'])->name('index');
            Route::post('/import', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'productDefaultImport'])->name('productDefaultImport');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'update'])->name('update');
            Route::post('/set-gallery', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'setGallery'])->name('setGallery');
        });


        Route::prefix('order')->name('order.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\OrderController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\OrderController::class, 'show'])->name('show');
            Route::post('/change-status', [\App\Http\Controllers\V1\Admin\OrderController::class, 'changeStatus'])->name('changeStatus');
            Route::post('/order-accept', [\App\Http\Controllers\V1\Admin\OrderController::class, 'acceptOrder'])->name('acceptOrder');
            Route::post('/get-order-for-send', [\App\Http\Controllers\V1\Admin\OrderController::class, 'getOrderForSend'])->name('getOrderForSend');
            Route::post('/order-returned', [\App\Http\Controllers\V1\Admin\OrderController::class, 'orderReturned'])->name('orderReturned');
            Route::post('/update', [\App\Http\Controllers\V1\Admin\OrderController::class, 'orderUpdate'])->name('orderUpdate');
        });

        Route::prefix('refund')->name('refund.')->group(function () {
            Route::post('/order', [\App\Http\Controllers\V1\Admin\RefundController::class, 'refundOrder'])->name('order');
            Route::post('/partial', [\App\Http\Controllers\V1\Admin\RefundController::class, 'partialRefund'])->name('partial');
            Route::post('/full', [\App\Http\Controllers\V1\Admin\RefundController::class, 'fullRefund'])->name('full');
            Route::get('/status', [\App\Http\Controllers\V1\Admin\RefundController::class, 'checkRefundStatus'])->name('status');
        });


        Route::prefix('preparation-time')->name('preparationTime.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\PreparationTimeController::class, 'index'])->name('index');
        });


        Route::prefix('unit')->name('unit.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\UnitController::class, 'index'])->name('index');
        });
        Route::prefix('material')->name('material.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'index'])->name('index');
            Route::get('/all', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'all'])->name('all');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\MaterialController::class, 'update'])->name('update');
        });
        Route::prefix('extra-type')->name('extraType.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\ExtraTypeController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\ExtraTypeController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\ExtraTypeController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\ExtraTypeController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\ExtraTypeController::class, 'update'])->name('update');
        });
        Route::prefix('extra')->name('extra.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\ExtraController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\ExtraController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\ExtraController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\ExtraController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\ExtraController::class, 'update'])->name('update');
        });
        Route::prefix('slider')->name('slider.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\SliderController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\SliderController::class, 'show'])->name('show');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\SliderController::class, 'destroy'])->name('destroy');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\SliderController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\SliderController::class, 'update'])->name('update');
        });

        Route::prefix('setting')->name('setting.')->group(function () {
            Route::post('/storeOrUpdate', [\App\Http\Controllers\V1\Admin\SettingController::class, 'storeOrUpdate'])->name('store');
            Route::get('/get-with-names', [\App\Http\Controllers\V1\Admin\SettingController::class, 'getWithNames'])->name('getWithNames');
        });

        Route::prefix('coupon')->name('coupon.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\CouponController::class, 'index'])->name('index');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\CouponController::class, 'store'])->name('store');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\CouponController::class, 'destroy'])->name('destroy');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\CouponController::class, 'show'])->name('show');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\CouponController::class, 'update'])->name('update');
           // Route::get('/check-coupon', [\App\Http\Controllers\V1\Admin\CouponController::class, 'checkCoupon']);

        });

        Route::prefix('export-import')->name('export-import.')->group(function () {
            Route::get('/export', [\App\Http\Controllers\V1\Admin\ExportImportController::class, 'listExport'])->name('listExport');
        });

        Route::prefix('page')->name('page.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\PageController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\PageController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\PageController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\PageController::class, 'update'])->name('update');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\PageController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('percent-branch')->name('percentBranch.')->group(function () {
            Route::post('/store', [\App\Http\Controllers\V1\Admin\PercentOrderBranchController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\PercentOrderBranchController::class, 'update'])->name('update');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\PercentOrderBranchController::class, 'show'])->name('show');
            Route::delete('/delete/{id}', [\App\Http\Controllers\V1\Admin\PercentOrderBranchController::class, 'destroy'])->name('destroy');
        });

        Route::prefix('area-management')->name('areaManagement.')->group(function () {
            Route::get('/get-price-by-address', [\App\Http\Controllers\V1\Admin\AreaController::class, 'getPriceByAddress'])->name('getPriceByAddress');
        });

        Route::prefix('area-special-conditions')->name('areaSpecialConditions.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'index'])->name('index');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'store'])->name('store');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'show'])->name('show');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'update'])->name('update');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'destroy'])->name('destroy');
            Route::get('/by-branch', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'getByBranch'])->name('getByBranch');
            Route::get('/by-area', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'getByArea'])->name('getByArea');
            Route::get('/currently-active', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'getCurrentlyActive'])->name('getCurrentlyActive');
            Route::post('/toggle-status', [\App\Http\Controllers\V1\Admin\AreaSpecialConditionController::class, 'toggleStatus'])->name('toggleStatus');
        });

        Route::prefix('printer-settings')->name('printerSettings.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'update'])->name('update');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'destroy'])->name('destroy');
            Route::get('/by-branch', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'getByBranch'])->name('getByBranch');
            Route::get('/by-type', [\App\Http\Controllers\V1\Admin\PrinterSettingController::class, 'getByType'])->name('getByType');
        });

        Route::prefix('sms-settings')->name('smsSettings.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'update'])->name('update');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'destroy'])->name('destroy');
            Route::get('/by-repository', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'getByRepository'])->name('getByRepository');
            Route::get('/active', [\App\Http\Controllers\V1\Admin\SmsSettingController::class, 'getActiveSettings'])->name('getActiveSettings');
        });

  

        Route::prefix('notification-mobiles')->name('notificationMobiles.')->group(function () {
            Route::get('/', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'index'])->name('index');
            Route::get('/show', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'show'])->name('show');
            Route::post('/store', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'store'])->name('store');
            Route::put('/update', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'update'])->name('update');
            Route::delete('/destroy', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'destroy'])->name('destroy');
            Route::get('/by-branch', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'getByBranch'])->name('getByBranch');
            Route::get('/by-type', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'getByType'])->name('getByType');
            Route::get('/mobile-numbers', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'getMobileNumbers'])->name('getMobileNumbers');
            Route::get('/notification-types', [\App\Http\Controllers\V1\Admin\NotificationMobileController::class, 'getNotificationTypes'])->name('getNotificationTypes');
        });
    });
});
