<?php

use App\Http\Controllers\V1\BranchController;
use App\Repositories\Address\AddressRepository;
use App\Repositories\SMS\SMSRepositoryInterface;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::post('/branches/{fromBranch}/copy-to/{toBranch}', [BranchController::class, 'copyBranchData']);

Route::prefix('payment')->group(function () {
    Route::get('/pay_order', [\App\Http\Controllers\V1\PaymentController::class, 'payOrder']);
    Route::get('/pay_confirm', [\App\Http\Controllers\V1\PaymentController::class, 'payConfirm'])->name('payConfirm');
    Route::post('/pay_confirm', [\App\Http\Controllers\V1\PaymentController::class, 'payConfirm'])->name('payConfirm');
});

Route::prefix('charge')->group(function () {
    Route::get('/wallet', [\App\Http\Controllers\V1\PaymentController::class, 'chargeWallet'])->name('chargeWallet');
    Route::get('/confirm', [\App\Http\Controllers\V1\PaymentController::class, 'chargeWalletConfirm'])->name('chargeWalletConfirm');
});

Route::get('/file/{code}', [\App\Http\Controllers\V1\FileManager\FileController::class, 'find']);

Route::get('/clear', function () {
    \Illuminate\Support\Facades\Artisan::call('cache:clear');
    \Illuminate\Support\Facades\Artisan::call('config:clear');
    \Illuminate\Support\Facades\Artisan::call('config:cache');
    \Illuminate\Support\Facades\Artisan::call('view:clear');
    \Illuminate\Support\Facades\Artisan::call('route:clear');
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
    return "Cleared!";
});

Route::get('/qr/{id}', function ($id) {
    $route = env('FrontQrcode') . $id;
    return redirect($route);
});

Route::get('logs', [\Rap2hpoutre\LaravelLogViewer\LogViewerController::class, 'index']);

Route::get('/', function () {

    return view('welcome');
});

Route::get('/importP', [\App\Http\Controllers\V1\Admin\ProductDefaultController::class, 'productDefaultImport'])->name('productDefaultImport');

Route::get('/chf', function () {
    $records = \App\Models\Slider::paginate(50);
    foreach ($records as $record) {
        $image = explode('/', $record->image);
        if (isset($image[4])) {
            $file = \App\Models\File::where('code', $image[4])->first();
            if ($file != null) {
                $record->image = $file->path;
            }

//            if ($record->images != null) {
//                $images = json_decode($record->images, true);
//                foreach ($images as $keys => $img) {
//                    $im1 = explode('/', $img['path']);
//                    if (!isset($im1[4]))
//                        continue;
//                    $f = \App\Models\File::where('code', $image[4])->first();
//                    if ($file != null) {
//                        $images[$keys]['path'] = $f->path;
//                    }
//                }
//                $record->images = json_encode($images);
//            }
            $record->update();
        }
    }

    if ($records->currentPage() < $records->total()) {
        return redirect()->route('dd', ['page' => $records->currentPage() + 1]);
    }
})->name("dd");



